/*    */ package org.jboss.remoting.transporter;
/*    */ 
/*    */ import java.lang.reflect.Method;
/*    */ import javax.management.MBeanServer;
/*    */ import org.jboss.remoting.InvocationRequest;
/*    */ import org.jboss.remoting.ServerInvocationHandler;
/*    */ import org.jboss.remoting.ServerInvoker;
/*    */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*    */ import org.jboss.remoting.invocation.NameBasedInvocation;
/*    */ 
/*    */ public class TransporterHandler
/*    */   implements ServerInvocationHandler
/*    */ {
/* 41 */   private Object targetPOJO = null;
/*    */ 
/*    */   public TransporterHandler(Object target)
/*    */   {
/* 45 */     this.targetPOJO = target;
/*    */   }
/*    */ 
/*    */   public Object invoke(InvocationRequest invocation)
/*    */     throws Throwable
/*    */   {
/* 59 */     Object request = invocation.getParameter();
/*    */ 
/* 62 */     NameBasedInvocation nbInvocation = (NameBasedInvocation)request;
/*    */ 
/* 64 */     String methodName = nbInvocation.getMethodName();
/* 65 */     Object[] params = nbInvocation.getParameters();
/* 66 */     String[] sig = nbInvocation.getSignature();
/* 67 */     Class[] classSig = new Class[sig.length];
/* 68 */     for (int x = 0; x < sig.length; x++)
/*    */     {
/* 70 */       Class signature = getPrimitiveType(sig[x]);
/* 71 */       if (signature != null)
/*    */       {
/* 73 */         classSig[x] = signature;
/*    */       }
/*    */       else
/*    */       {
/* 77 */         classSig[x] = Class.forName(sig[x]);
/*    */       }
/*    */ 
/*    */     }
/*    */ 
/* 82 */     Method method = this.targetPOJO.getClass().getMethod(methodName, classSig);
/* 83 */     Object responseObject = method.invoke(this.targetPOJO, params);
/*    */ 
/* 85 */     return responseObject;
/*    */   }
/*    */ 
/*    */   private Class getPrimitiveType(String name)
/*    */   {
/* 90 */     if (name.equals("byte")) return Byte.TYPE;
/* 91 */     if (name.equals("short")) return Short.TYPE;
/* 92 */     if (name.equals("int")) return Integer.TYPE;
/* 93 */     if (name.equals("long")) return Long.TYPE;
/* 94 */     if (name.equals("char")) return Character.TYPE;
/* 95 */     if (name.equals("float")) return Float.TYPE;
/* 96 */     if (name.equals("double")) return Double.TYPE;
/* 97 */     if (name.equals("boolean")) return Boolean.TYPE;
/* 98 */     if (name.equals("void")) return Void.TYPE;
/* 99 */     return null;
/*    */   }
/*    */ 
/*    */   public void setMBeanServer(MBeanServer server)
/*    */   {
/*    */   }
/*    */ 
/*    */   public void setInvoker(ServerInvoker invoker)
/*    */   {
/*    */   }
/*    */ 
/*    */   public void addListener(InvokerCallbackHandler callbackHandler)
/*    */   {
/*    */   }
/*    */ 
/*    */   public void removeListener(InvokerCallbackHandler callbackHandler)
/*    */   {
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transporter.TransporterHandler
 * JD-Core Version:    0.6.0
 */