/*     */ package org.jboss.resource.adapter.jdbc;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
/*     */ import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import java.math.BigDecimal;
/*     */ import java.net.URL;
/*     */ import java.sql.Array;
/*     */ import java.sql.Blob;
/*     */ import java.sql.Clob;
/*     */ import java.sql.Connection;
/*     */ import java.sql.Date;
/*     */ import java.sql.ParameterMetaData;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.Ref;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.ResultSetMetaData;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.SQLWarning;
/*     */ import java.sql.Time;
/*     */ import java.sql.Timestamp;
/*     */ import java.util.Calendar;
/*     */ 
/*     */ public abstract class CachedPreparedStatement extends JBossWrapper
/*     */   implements PreparedStatement
/*     */ {
/*     */   private PreparedStatement ps;
/*  52 */   private SynchronizedBoolean cached = new SynchronizedBoolean(true);
/*  53 */   private SynchronizedInt inUse = new SynchronizedInt(1);
/*     */   private int defaultMaxFieldSize;
/*     */   private int defaultMaxRows;
/*     */   private int defaultQueryTimeout;
/*     */   private int defaultFetchDirection;
/*     */   private int defaultFetchSize;
/*     */   private int currentMaxFieldSize;
/*     */   private int currentMaxRows;
/*     */   private int currentQueryTimeout;
/*     */   private int currentFetchDirection;
/*     */   private int currentFetchSize;
/*     */ 
/*     */   public CachedPreparedStatement(PreparedStatement ps)
/*     */     throws SQLException
/*     */   {
/*  68 */     this.ps = ps;
/*     */ 
/*  71 */     this.defaultMaxFieldSize = ps.getMaxFieldSize();
/*  72 */     this.defaultMaxRows = ps.getMaxRows();
/*  73 */     this.defaultQueryTimeout = ps.getQueryTimeout();
/*  74 */     this.defaultFetchDirection = ps.getFetchDirection();
/*  75 */     this.defaultFetchSize = ps.getFetchSize();
/*  76 */     this.currentMaxFieldSize = this.defaultMaxFieldSize;
/*  77 */     this.currentMaxRows = this.defaultMaxRows;
/*  78 */     this.currentQueryTimeout = this.defaultQueryTimeout;
/*  79 */     this.currentFetchDirection = this.defaultFetchDirection;
/*  80 */     this.currentFetchSize = this.defaultFetchSize;
/*     */   }
/*     */ 
/*     */   public PreparedStatement getUnderlyingPreparedStatement()
/*     */   {
/*  85 */     return this.ps;
/*     */   }
/*     */ 
/*     */   public ResultSet executeQuery() throws SQLException
/*     */   {
/*  90 */     return this.ps.executeQuery();
/*     */   }
/*     */ 
/*     */   public int executeUpdate() throws SQLException
/*     */   {
/*  95 */     return this.ps.executeUpdate();
/*     */   }
/*     */ 
/*     */   public void setNull(int parameterIndex, int sqlType) throws SQLException
/*     */   {
/* 100 */     this.ps.setNull(parameterIndex, sqlType);
/*     */   }
/*     */ 
/*     */   public void setBoolean(int parameterIndex, boolean x) throws SQLException
/*     */   {
/* 105 */     this.ps.setBoolean(parameterIndex, x);
/*     */   }
/*     */ 
/*     */   public void setByte(int parameterIndex, byte x) throws SQLException
/*     */   {
/* 110 */     this.ps.setByte(parameterIndex, x);
/*     */   }
/*     */ 
/*     */   public void setShort(int parameterIndex, short x) throws SQLException
/*     */   {
/* 115 */     this.ps.setShort(parameterIndex, x);
/*     */   }
/*     */ 
/*     */   public void setInt(int parameterIndex, int x) throws SQLException
/*     */   {
/* 120 */     this.ps.setInt(parameterIndex, x);
/*     */   }
/*     */ 
/*     */   public void setLong(int parameterIndex, long x) throws SQLException
/*     */   {
/* 125 */     this.ps.setLong(parameterIndex, x);
/*     */   }
/*     */ 
/*     */   public void setFloat(int parameterIndex, float x) throws SQLException
/*     */   {
/* 130 */     this.ps.setFloat(parameterIndex, x);
/*     */   }
/*     */ 
/*     */   public void setDouble(int parameterIndex, double x) throws SQLException
/*     */   {
/* 135 */     this.ps.setDouble(parameterIndex, x);
/*     */   }
/*     */ 
/*     */   public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException
/*     */   {
/* 140 */     this.ps.setBigDecimal(parameterIndex, x);
/*     */   }
/*     */ 
/*     */   public void setString(int parameterIndex, String x) throws SQLException
/*     */   {
/* 145 */     this.ps.setString(parameterIndex, x);
/*     */   }
/*     */ 
/*     */   public void setBytes(int parameterIndex, byte[] x) throws SQLException
/*     */   {
/* 150 */     this.ps.setBytes(parameterIndex, x);
/*     */   }
/*     */ 
/*     */   public void setDate(int parameterIndex, Date x)
/*     */     throws SQLException
/*     */   {
/* 156 */     this.ps.setDate(parameterIndex, x);
/*     */   }
/*     */ 
/*     */   public void setTime(int parameterIndex, Time x)
/*     */     throws SQLException
/*     */   {
/* 162 */     this.ps.setTime(parameterIndex, x);
/*     */   }
/*     */ 
/*     */   public void setTimestamp(int parameterIndex, Timestamp x)
/*     */     throws SQLException
/*     */   {
/* 168 */     this.ps.setTimestamp(parameterIndex, x);
/*     */   }
/*     */ 
/*     */   public void setAsciiStream(int parameterIndex, InputStream x, int length)
/*     */     throws SQLException
/*     */   {
/* 174 */     this.ps.setAsciiStream(parameterIndex, x, length);
/*     */   }
/*     */ 
/*     */   @Deprecated
/*     */   public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException
/*     */   {
/* 181 */     this.ps.setUnicodeStream(parameterIndex, x, length);
/*     */   }
/*     */ 
/*     */   public void setBinaryStream(int parameterIndex, InputStream x, int length)
/*     */     throws SQLException
/*     */   {
/* 187 */     this.ps.setBinaryStream(parameterIndex, x, length);
/*     */   }
/*     */ 
/*     */   public void clearParameters() throws SQLException
/*     */   {
/* 192 */     this.ps.clearParameters();
/*     */   }
/*     */ 
/*     */   public void setObject(int parameterIndex, Object x, int targetSqlType, int scale)
/*     */     throws SQLException
/*     */   {
/* 198 */     this.ps.setObject(parameterIndex, x, targetSqlType, scale);
/*     */   }
/*     */ 
/*     */   public void setObject(int parameterIndex, Object x, int targetSqlType)
/*     */     throws SQLException
/*     */   {
/* 204 */     this.ps.setObject(parameterIndex, x, targetSqlType);
/*     */   }
/*     */ 
/*     */   public void setObject(int parameterIndex, Object x) throws SQLException
/*     */   {
/* 209 */     this.ps.setObject(parameterIndex, x);
/*     */   }
/*     */ 
/*     */   public boolean execute() throws SQLException
/*     */   {
/* 214 */     return this.ps.execute();
/*     */   }
/*     */ 
/*     */   public void addBatch() throws SQLException
/*     */   {
/* 219 */     this.ps.addBatch();
/*     */   }
/*     */ 
/*     */   public void setCharacterStream(int parameterIndex, Reader reader, int length)
/*     */     throws SQLException
/*     */   {
/* 226 */     this.ps.setCharacterStream(parameterIndex, reader, length);
/*     */   }
/*     */ 
/*     */   public void setRef(int i, Ref x) throws SQLException
/*     */   {
/* 231 */     this.ps.setRef(i, x);
/*     */   }
/*     */ 
/*     */   public void setBlob(int i, Blob x) throws SQLException
/*     */   {
/* 236 */     this.ps.setBlob(i, x);
/*     */   }
/*     */ 
/*     */   public void setClob(int i, Clob x) throws SQLException
/*     */   {
/* 241 */     this.ps.setClob(i, x);
/*     */   }
/*     */ 
/*     */   public void setArray(int i, Array x) throws SQLException
/*     */   {
/* 246 */     this.ps.setArray(i, x);
/*     */   }
/*     */ 
/*     */   public ResultSetMetaData getMetaData() throws SQLException
/*     */   {
/* 251 */     return this.ps.getMetaData();
/*     */   }
/*     */ 
/*     */   public void setDate(int parameterIndex, Date x, Calendar cal)
/*     */     throws SQLException
/*     */   {
/* 257 */     this.ps.setDate(parameterIndex, x, cal);
/*     */   }
/*     */ 
/*     */   public void setTime(int parameterIndex, Time x, Calendar cal)
/*     */     throws SQLException
/*     */   {
/* 263 */     this.ps.setTime(parameterIndex, x, cal);
/*     */   }
/*     */ 
/*     */   public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal)
/*     */     throws SQLException
/*     */   {
/* 269 */     this.ps.setTimestamp(parameterIndex, x, cal);
/*     */   }
/*     */ 
/*     */   public void setNull(int paramIndex, int sqlType, String typeName)
/*     */     throws SQLException
/*     */   {
/* 275 */     this.ps.setNull(paramIndex, sqlType, typeName);
/*     */   }
/*     */ 
/*     */   public void setURL(int parameterIndex, URL x) throws SQLException
/*     */   {
/* 280 */     this.ps.setURL(parameterIndex, x);
/*     */   }
/*     */ 
/*     */   public ParameterMetaData getParameterMetaData() throws SQLException
/*     */   {
/* 285 */     return this.ps.getParameterMetaData();
/*     */   }
/*     */ 
/*     */   public ResultSet executeQuery(String sql) throws SQLException
/*     */   {
/* 290 */     return this.ps.executeQuery(sql);
/*     */   }
/*     */ 
/*     */   public int executeUpdate(String sql) throws SQLException
/*     */   {
/* 295 */     return this.ps.executeUpdate(sql);
/*     */   }
/*     */ 
/*     */   public boolean isInUse()
/*     */   {
/* 300 */     return this.inUse.get() > 0;
/*     */   }
/*     */ 
/*     */   public void inUse()
/*     */   {
/* 305 */     this.inUse.increment();
/*     */   }
/*     */ 
/*     */   public void agedOut() throws SQLException
/*     */   {
/* 310 */     this.cached.set(false);
/* 311 */     if (this.inUse.get() == 0)
/* 312 */       this.ps.close();
/*     */   }
/*     */ 
/*     */   public void close() throws SQLException
/*     */   {
/* 317 */     this.inUse.decrement();
/* 318 */     if (this.inUse.get() == 0)
/*     */     {
/* 320 */       if (!this.cached.get()) {
/* 321 */         this.ps.close();
/*     */       }
/*     */       else
/*     */       {
/* 325 */         if (this.defaultMaxFieldSize != this.currentMaxFieldSize)
/*     */         {
/* 327 */           this.ps.setMaxFieldSize(this.defaultMaxFieldSize);
/* 328 */           this.currentMaxFieldSize = this.defaultMaxFieldSize;
/*     */         }
/* 330 */         if (this.defaultMaxRows != this.currentMaxRows)
/*     */         {
/* 332 */           this.ps.setMaxRows(this.defaultMaxRows);
/* 333 */           this.currentMaxRows = this.defaultMaxRows;
/*     */         }
/* 335 */         if (this.defaultQueryTimeout != this.currentQueryTimeout)
/*     */         {
/* 337 */           this.ps.setQueryTimeout(this.defaultQueryTimeout);
/* 338 */           this.currentQueryTimeout = this.defaultQueryTimeout;
/*     */         }
/* 340 */         if (this.defaultFetchDirection != this.currentFetchDirection)
/*     */         {
/* 342 */           this.ps.setFetchDirection(this.defaultFetchDirection);
/* 343 */           this.currentFetchDirection = this.defaultFetchDirection;
/*     */         }
/* 345 */         if (this.defaultFetchSize != this.currentFetchSize)
/*     */         {
/* 347 */           this.ps.setFetchSize(this.defaultFetchSize);
/* 348 */           this.currentFetchSize = this.defaultFetchSize;
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getMaxFieldSize() throws SQLException
/*     */   {
/* 356 */     return this.ps.getMaxFieldSize();
/*     */   }
/*     */ 
/*     */   public void setMaxFieldSize(int max) throws SQLException
/*     */   {
/* 361 */     this.ps.setMaxFieldSize(max);
/* 362 */     this.currentMaxFieldSize = max;
/*     */   }
/*     */ 
/*     */   public int getMaxRows() throws SQLException
/*     */   {
/* 367 */     return this.ps.getMaxRows();
/*     */   }
/*     */ 
/*     */   public void setMaxRows(int max) throws SQLException
/*     */   {
/* 372 */     this.ps.setMaxRows(max);
/* 373 */     this.currentMaxRows = max;
/*     */   }
/*     */ 
/*     */   public void setEscapeProcessing(boolean enable) throws SQLException
/*     */   {
/* 378 */     this.ps.setEscapeProcessing(enable);
/*     */   }
/*     */ 
/*     */   public int getQueryTimeout() throws SQLException
/*     */   {
/* 383 */     return this.ps.getQueryTimeout();
/*     */   }
/*     */ 
/*     */   public void setQueryTimeout(int seconds) throws SQLException
/*     */   {
/* 388 */     this.ps.setQueryTimeout(seconds);
/* 389 */     this.currentQueryTimeout = seconds;
/*     */   }
/*     */ 
/*     */   public void cancel() throws SQLException
/*     */   {
/* 394 */     this.ps.cancel();
/*     */   }
/*     */ 
/*     */   public SQLWarning getWarnings() throws SQLException
/*     */   {
/* 399 */     return this.ps.getWarnings();
/*     */   }
/*     */ 
/*     */   public void clearWarnings() throws SQLException
/*     */   {
/* 404 */     this.ps.clearWarnings();
/*     */   }
/*     */ 
/*     */   public void setCursorName(String name) throws SQLException
/*     */   {
/* 409 */     this.ps.setCursorName(name);
/*     */   }
/*     */ 
/*     */   public boolean execute(String sql) throws SQLException
/*     */   {
/* 414 */     return this.ps.execute(sql);
/*     */   }
/*     */ 
/*     */   public ResultSet getResultSet() throws SQLException
/*     */   {
/* 419 */     return this.ps.getResultSet();
/*     */   }
/*     */ 
/*     */   public int getUpdateCount() throws SQLException
/*     */   {
/* 424 */     return this.ps.getUpdateCount();
/*     */   }
/*     */ 
/*     */   public boolean getMoreResults() throws SQLException
/*     */   {
/* 429 */     return this.ps.getMoreResults();
/*     */   }
/*     */ 
/*     */   public void setFetchDirection(int direction) throws SQLException
/*     */   {
/* 434 */     this.ps.setFetchDirection(direction);
/* 435 */     this.currentFetchDirection = direction;
/*     */   }
/*     */ 
/*     */   public int getFetchDirection() throws SQLException
/*     */   {
/* 440 */     return this.ps.getFetchDirection();
/*     */   }
/*     */ 
/*     */   public void setFetchSize(int rows) throws SQLException
/*     */   {
/* 445 */     this.ps.setFetchSize(rows);
/* 446 */     this.currentFetchSize = rows;
/*     */   }
/*     */ 
/*     */   public int getFetchSize() throws SQLException
/*     */   {
/* 451 */     return this.ps.getFetchSize();
/*     */   }
/*     */ 
/*     */   public int getResultSetConcurrency() throws SQLException
/*     */   {
/* 456 */     return this.ps.getResultSetConcurrency();
/*     */   }
/*     */ 
/*     */   public int getResultSetType() throws SQLException
/*     */   {
/* 461 */     return this.ps.getResultSetType();
/*     */   }
/*     */ 
/*     */   public void addBatch(String sql) throws SQLException
/*     */   {
/* 466 */     this.ps.addBatch(sql);
/*     */   }
/*     */ 
/*     */   public void clearBatch() throws SQLException
/*     */   {
/* 471 */     this.ps.clearBatch();
/*     */   }
/*     */ 
/*     */   public int[] executeBatch() throws SQLException
/*     */   {
/* 476 */     return this.ps.executeBatch();
/*     */   }
/*     */ 
/*     */   public Connection getConnection() throws SQLException
/*     */   {
/* 481 */     return this.ps.getConnection();
/*     */   }
/*     */ 
/*     */   public boolean getMoreResults(int current) throws SQLException
/*     */   {
/* 486 */     return this.ps.getMoreResults(current);
/*     */   }
/*     */ 
/*     */   public ResultSet getGeneratedKeys() throws SQLException
/*     */   {
/* 491 */     return this.ps.getGeneratedKeys();
/*     */   }
/*     */ 
/*     */   public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException
/*     */   {
/* 496 */     return this.ps.executeUpdate(sql, autoGeneratedKeys);
/*     */   }
/*     */ 
/*     */   public int executeUpdate(String sql, int[] columnIndexes) throws SQLException
/*     */   {
/* 501 */     return this.ps.executeUpdate(sql, columnIndexes);
/*     */   }
/*     */ 
/*     */   public int executeUpdate(String sql, String[] columnNames) throws SQLException
/*     */   {
/* 506 */     return this.ps.executeUpdate(sql, columnNames);
/*     */   }
/*     */ 
/*     */   public boolean execute(String sql, int autoGeneratedKeys) throws SQLException
/*     */   {
/* 511 */     return this.ps.execute(sql, autoGeneratedKeys);
/*     */   }
/*     */ 
/*     */   public boolean execute(String sql, int[] columnIndexes) throws SQLException
/*     */   {
/* 516 */     return this.ps.execute(sql, columnIndexes);
/*     */   }
/*     */ 
/*     */   public boolean execute(String sql, String[] columnNames) throws SQLException
/*     */   {
/* 521 */     return this.ps.execute(sql, columnNames);
/*     */   }
/*     */ 
/*     */   public int getResultSetHoldability() throws SQLException
/*     */   {
/* 526 */     return this.ps.getResultSetHoldability();
/*     */   }
/*     */ 
/*     */   protected PreparedStatement getWrappedObject() throws SQLException
/*     */   {
/* 531 */     return this.ps;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.CachedPreparedStatement
 * JD-Core Version:    0.6.0
 */