/*      */ package org.jboss.resource.adapter.jdbc;
/*      */ 
/*      */ import java.io.InputStream;
/*      */ import java.io.Reader;
/*      */ import java.math.BigDecimal;
/*      */ import java.net.URL;
/*      */ import java.sql.Array;
/*      */ import java.sql.Blob;
/*      */ import java.sql.CallableStatement;
/*      */ import java.sql.Clob;
/*      */ import java.sql.Date;
/*      */ import java.sql.Ref;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.Time;
/*      */ import java.sql.Timestamp;
/*      */ import java.util.Calendar;
/*      */ import java.util.Map;
/*      */ 
/*      */ public abstract class WrappedCallableStatement extends WrappedPreparedStatement
/*      */   implements CallableStatement
/*      */ {
/*      */   private final CallableStatement cs;
/*      */ 
/*      */   public WrappedCallableStatement(WrappedConnection lc, CallableStatement cs)
/*      */   {
/*   54 */     super(lc, cs);
/*   55 */     this.cs = cs;
/*      */   }
/*      */ 
/*      */   public CallableStatement getUnderlyingStatement() throws SQLException
/*      */   {
/*   60 */     return (CallableStatement)super.getUnderlyingStatement();
/*      */   }
/*      */ 
/*      */   public Object getObject(int parameterIndex) throws SQLException
/*      */   {
/*   65 */     checkState();
/*      */     try
/*      */     {
/*   68 */       return this.cs.getObject(parameterIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*   72 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Object getObject(int parameterIndex, Map typeMap)
/*      */     throws SQLException
/*      */   {
/*   78 */     checkState();
/*      */     try
/*      */     {
/*   81 */       return this.cs.getObject(parameterIndex, typeMap);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*   85 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Object getObject(String parameterName)
/*      */     throws SQLException
/*      */   {
/*   91 */     checkState();
/*      */     try
/*      */     {
/*   94 */       return this.cs.getObject(parameterName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*   98 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Object getObject(String parameterName, Map typeMap)
/*      */     throws SQLException
/*      */   {
/*  104 */     checkState();
/*      */     try
/*      */     {
/*  107 */       return this.cs.getObject(parameterName, typeMap);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  111 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public boolean getBoolean(int parameterIndex)
/*      */     throws SQLException
/*      */   {
/*  117 */     checkState();
/*      */     try
/*      */     {
/*  120 */       return this.cs.getBoolean(parameterIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  124 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public boolean getBoolean(String parameterName)
/*      */     throws SQLException
/*      */   {
/*  130 */     checkState();
/*      */     try
/*      */     {
/*  133 */       return this.cs.getBoolean(parameterName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  137 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public byte getByte(int parameterIndex)
/*      */     throws SQLException
/*      */   {
/*  143 */     checkState();
/*      */     try
/*      */     {
/*  146 */       return this.cs.getByte(parameterIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  150 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public byte getByte(String parameterName)
/*      */     throws SQLException
/*      */   {
/*  156 */     checkState();
/*      */     try
/*      */     {
/*  159 */       return this.cs.getByte(parameterName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  163 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public short getShort(int parameterIndex)
/*      */     throws SQLException
/*      */   {
/*  169 */     checkState();
/*      */     try
/*      */     {
/*  172 */       return this.cs.getShort(parameterIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  176 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public short getShort(String parameterName)
/*      */     throws SQLException
/*      */   {
/*  182 */     checkState();
/*      */     try
/*      */     {
/*  185 */       return this.cs.getShort(parameterName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  189 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public int getInt(int parameterIndex)
/*      */     throws SQLException
/*      */   {
/*  195 */     checkState();
/*      */     try
/*      */     {
/*  198 */       return this.cs.getInt(parameterIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  202 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public int getInt(String parameterName)
/*      */     throws SQLException
/*      */   {
/*  208 */     checkState();
/*      */     try
/*      */     {
/*  211 */       return this.cs.getInt(parameterName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  215 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public long getLong(int parameterIndex)
/*      */     throws SQLException
/*      */   {
/*  221 */     checkState();
/*      */     try
/*      */     {
/*  224 */       return this.cs.getLong(parameterIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  228 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public long getLong(String parameterName)
/*      */     throws SQLException
/*      */   {
/*  234 */     checkState();
/*      */     try
/*      */     {
/*  237 */       return this.cs.getLong(parameterName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  241 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public float getFloat(int parameterIndex)
/*      */     throws SQLException
/*      */   {
/*  247 */     checkState();
/*      */     try
/*      */     {
/*  250 */       return this.cs.getFloat(parameterIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  254 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public float getFloat(String parameterName)
/*      */     throws SQLException
/*      */   {
/*  260 */     checkState();
/*      */     try
/*      */     {
/*  263 */       return this.cs.getFloat(parameterName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  267 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public double getDouble(int parameterIndex)
/*      */     throws SQLException
/*      */   {
/*  273 */     checkState();
/*      */     try
/*      */     {
/*  276 */       return this.cs.getDouble(parameterIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  280 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public double getDouble(String parameterName)
/*      */     throws SQLException
/*      */   {
/*  286 */     checkState();
/*      */     try
/*      */     {
/*  289 */       return this.cs.getDouble(parameterName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  293 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public byte[] getBytes(int parameterIndex)
/*      */     throws SQLException
/*      */   {
/*  299 */     checkState();
/*      */     try
/*      */     {
/*  302 */       return this.cs.getBytes(parameterIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  306 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public byte[] getBytes(String parameterName)
/*      */     throws SQLException
/*      */   {
/*  312 */     checkState();
/*      */     try
/*      */     {
/*  315 */       return this.cs.getBytes(parameterName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  319 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public URL getURL(int parameterIndex)
/*      */     throws SQLException
/*      */   {
/*  325 */     checkState();
/*      */     try
/*      */     {
/*  328 */       return this.cs.getURL(parameterIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  332 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public URL getURL(String parameterName)
/*      */     throws SQLException
/*      */   {
/*  338 */     checkState();
/*      */     try
/*      */     {
/*  341 */       return this.cs.getURL(parameterName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  345 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public String getString(int parameterIndex)
/*      */     throws SQLException
/*      */   {
/*  351 */     checkState();
/*      */     try
/*      */     {
/*  354 */       return this.cs.getString(parameterIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  358 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public String getString(String parameterName)
/*      */     throws SQLException
/*      */   {
/*  364 */     checkState();
/*      */     try
/*      */     {
/*  367 */       return this.cs.getString(parameterName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  371 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Ref getRef(int parameterIndex)
/*      */     throws SQLException
/*      */   {
/*  377 */     checkState();
/*      */     try
/*      */     {
/*  380 */       return this.cs.getRef(parameterIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  384 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Ref getRef(String parameterName)
/*      */     throws SQLException
/*      */   {
/*  390 */     checkState();
/*      */     try
/*      */     {
/*  393 */       return this.cs.getRef(parameterName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  397 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Time getTime(int parameterIndex)
/*      */     throws SQLException
/*      */   {
/*  403 */     checkState();
/*      */     try
/*      */     {
/*  406 */       return this.cs.getTime(parameterIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  410 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Time getTime(int parameterIndex, Calendar calendar)
/*      */     throws SQLException
/*      */   {
/*  416 */     checkState();
/*      */     try
/*      */     {
/*  419 */       return this.cs.getTime(parameterIndex, calendar);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  423 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Time getTime(String parameterName)
/*      */     throws SQLException
/*      */   {
/*  429 */     checkState();
/*      */     try
/*      */     {
/*  432 */       return this.cs.getTime(parameterName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  436 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Time getTime(String parameterName, Calendar calendar)
/*      */     throws SQLException
/*      */   {
/*  442 */     checkState();
/*      */     try
/*      */     {
/*  445 */       return this.cs.getTime(parameterName, calendar);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  449 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Date getDate(int parameterIndex)
/*      */     throws SQLException
/*      */   {
/*  455 */     checkState();
/*      */     try
/*      */     {
/*  458 */       return this.cs.getDate(parameterIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  462 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Date getDate(int parameterIndex, Calendar calendar)
/*      */     throws SQLException
/*      */   {
/*  468 */     checkState();
/*      */     try
/*      */     {
/*  471 */       return this.cs.getDate(parameterIndex, calendar);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  475 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Date getDate(String parameterName)
/*      */     throws SQLException
/*      */   {
/*  481 */     checkState();
/*      */     try
/*      */     {
/*  484 */       return this.cs.getDate(parameterName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  488 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Date getDate(String parameterName, Calendar calendar)
/*      */     throws SQLException
/*      */   {
/*  494 */     checkState();
/*      */     try
/*      */     {
/*  497 */       return this.cs.getDate(parameterName, calendar);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  501 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public void registerOutParameter(int parameterIndex, int sqlType)
/*      */     throws SQLException
/*      */   {
/*  507 */     checkState();
/*      */     try
/*      */     {
/*  510 */       this.cs.registerOutParameter(parameterIndex, sqlType);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  514 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException
/*      */   {
/*  520 */     checkState();
/*      */     try
/*      */     {
/*  523 */       this.cs.registerOutParameter(parameterIndex, sqlType, scale);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  527 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException
/*      */   {
/*  533 */     checkState();
/*      */     try
/*      */     {
/*  536 */       this.cs.registerOutParameter(parameterIndex, sqlType, typeName);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  540 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void registerOutParameter(String parameterName, int sqlType) throws SQLException
/*      */   {
/*  546 */     checkState();
/*      */     try
/*      */     {
/*  549 */       this.cs.registerOutParameter(parameterName, sqlType);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  553 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException
/*      */   {
/*  559 */     checkState();
/*      */     try
/*      */     {
/*  562 */       this.cs.registerOutParameter(parameterName, sqlType, scale);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  566 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException
/*      */   {
/*  572 */     checkState();
/*      */     try
/*      */     {
/*  575 */       this.cs.registerOutParameter(parameterName, sqlType, typeName);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  579 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean wasNull() throws SQLException
/*      */   {
/*  585 */     checkState();
/*      */     try
/*      */     {
/*  588 */       return this.cs.wasNull();
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  592 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public BigDecimal getBigDecimal(int parameterIndex, int scale)
/*      */     throws SQLException
/*      */   {
/*  601 */     checkState();
/*      */     try
/*      */     {
/*  604 */       return this.cs.getBigDecimal(parameterIndex, scale);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  608 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public BigDecimal getBigDecimal(int parameterIndex)
/*      */     throws SQLException
/*      */   {
/*  614 */     checkState();
/*      */     try
/*      */     {
/*  617 */       return this.cs.getBigDecimal(parameterIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  621 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public BigDecimal getBigDecimal(String parameterName)
/*      */     throws SQLException
/*      */   {
/*  627 */     checkState();
/*      */     try
/*      */     {
/*  630 */       return this.cs.getBigDecimal(parameterName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  634 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Timestamp getTimestamp(int parameterIndex)
/*      */     throws SQLException
/*      */   {
/*  640 */     checkState();
/*      */     try
/*      */     {
/*  643 */       return this.cs.getTimestamp(parameterIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  647 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Timestamp getTimestamp(int parameterIndex, Calendar calendar)
/*      */     throws SQLException
/*      */   {
/*  653 */     checkState();
/*      */     try
/*      */     {
/*  656 */       return this.cs.getTimestamp(parameterIndex, calendar);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  660 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Timestamp getTimestamp(String parameterName)
/*      */     throws SQLException
/*      */   {
/*  666 */     checkState();
/*      */     try
/*      */     {
/*  669 */       return this.cs.getTimestamp(parameterName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  673 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Timestamp getTimestamp(String parameterName, Calendar calendar)
/*      */     throws SQLException
/*      */   {
/*  679 */     checkState();
/*      */     try
/*      */     {
/*  682 */       return this.cs.getTimestamp(parameterName, calendar);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  686 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Blob getBlob(int parameterIndex)
/*      */     throws SQLException
/*      */   {
/*  692 */     checkState();
/*      */     try
/*      */     {
/*  695 */       return this.cs.getBlob(parameterIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  699 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Blob getBlob(String parameterName)
/*      */     throws SQLException
/*      */   {
/*  705 */     checkState();
/*      */     try
/*      */     {
/*  708 */       return this.cs.getBlob(parameterName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  712 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Clob getClob(int parameterIndex)
/*      */     throws SQLException
/*      */   {
/*  718 */     checkState();
/*      */     try
/*      */     {
/*  721 */       return this.cs.getClob(parameterIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  725 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Clob getClob(String parameterName)
/*      */     throws SQLException
/*      */   {
/*  731 */     checkState();
/*      */     try
/*      */     {
/*  734 */       return this.cs.getClob(parameterName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  738 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Array getArray(int parameterIndex)
/*      */     throws SQLException
/*      */   {
/*  744 */     checkState();
/*      */     try
/*      */     {
/*  747 */       return this.cs.getArray(parameterIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  751 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Array getArray(String parameterName)
/*      */     throws SQLException
/*      */   {
/*  757 */     checkState();
/*      */     try
/*      */     {
/*  760 */       return this.cs.getArray(parameterName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  764 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public void setBoolean(String parameterName, boolean value)
/*      */     throws SQLException
/*      */   {
/*  770 */     checkState();
/*      */     try
/*      */     {
/*  773 */       this.cs.setBoolean(parameterName, value);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  777 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setByte(String parameterName, byte value) throws SQLException
/*      */   {
/*  783 */     checkState();
/*      */     try
/*      */     {
/*  786 */       this.cs.setByte(parameterName, value);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  790 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setShort(String parameterName, short value) throws SQLException
/*      */   {
/*  796 */     checkState();
/*      */     try
/*      */     {
/*  799 */       this.cs.setShort(parameterName, value);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  803 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setInt(String parameterName, int value) throws SQLException
/*      */   {
/*  809 */     checkState();
/*      */     try
/*      */     {
/*  812 */       this.cs.setInt(parameterName, value);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  816 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setLong(String parameterName, long value) throws SQLException
/*      */   {
/*  822 */     checkState();
/*      */     try
/*      */     {
/*  825 */       this.cs.setLong(parameterName, value);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  829 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setFloat(String parameterName, float value) throws SQLException
/*      */   {
/*  835 */     checkState();
/*      */     try
/*      */     {
/*  838 */       this.cs.setFloat(parameterName, value);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  842 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setDouble(String parameterName, double value) throws SQLException
/*      */   {
/*  848 */     checkState();
/*      */     try
/*      */     {
/*  851 */       this.cs.setDouble(parameterName, value);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  855 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setURL(String parameterName, URL value) throws SQLException
/*      */   {
/*  861 */     checkState();
/*      */     try
/*      */     {
/*  864 */       this.cs.setURL(parameterName, value);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  868 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setTime(String parameterName, Time value) throws SQLException
/*      */   {
/*  874 */     checkState();
/*      */     try
/*      */     {
/*  877 */       this.cs.setTime(parameterName, value);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  881 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setTime(String parameterName, Time value, Calendar calendar) throws SQLException
/*      */   {
/*  887 */     checkState();
/*      */     try
/*      */     {
/*  890 */       this.cs.setTime(parameterName, value, calendar);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  894 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setNull(String parameterName, int value) throws SQLException
/*      */   {
/*  900 */     checkState();
/*      */     try
/*      */     {
/*  903 */       this.cs.setNull(parameterName, value);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  907 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setNull(String parameterName, int sqlType, String typeName) throws SQLException
/*      */   {
/*  913 */     checkState();
/*      */     try
/*      */     {
/*  916 */       this.cs.setNull(parameterName, sqlType, typeName);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  920 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setBigDecimal(String parameterName, BigDecimal value) throws SQLException
/*      */   {
/*  926 */     checkState();
/*      */     try
/*      */     {
/*  929 */       this.cs.setBigDecimal(parameterName, value);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  933 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setString(String parameterName, String value) throws SQLException
/*      */   {
/*  939 */     checkState();
/*      */     try
/*      */     {
/*  942 */       this.cs.setString(parameterName, value);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  946 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setBytes(String parameterName, byte[] value) throws SQLException
/*      */   {
/*  952 */     checkState();
/*      */     try
/*      */     {
/*  955 */       this.cs.setBytes(parameterName, value);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  959 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setDate(String parameterName, Date value) throws SQLException
/*      */   {
/*  965 */     checkState();
/*      */     try
/*      */     {
/*  968 */       this.cs.setDate(parameterName, value);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  972 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setDate(String parameterName, Date value, Calendar calendar) throws SQLException
/*      */   {
/*  978 */     checkState();
/*      */     try
/*      */     {
/*  981 */       this.cs.setDate(parameterName, value, calendar);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  985 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setTimestamp(String parameterName, Timestamp value) throws SQLException
/*      */   {
/*  991 */     checkState();
/*      */     try
/*      */     {
/*  994 */       this.cs.setTimestamp(parameterName, value);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  998 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setTimestamp(String parameterName, Timestamp value, Calendar calendar) throws SQLException
/*      */   {
/* 1004 */     checkState();
/*      */     try
/*      */     {
/* 1007 */       this.cs.setTimestamp(parameterName, value, calendar);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1011 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setAsciiStream(String parameterName, InputStream stream, int length) throws SQLException
/*      */   {
/* 1017 */     checkState();
/*      */     try
/*      */     {
/* 1020 */       this.cs.setAsciiStream(parameterName, stream, length);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1024 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setBinaryStream(String parameterName, InputStream stream, int length) throws SQLException
/*      */   {
/* 1030 */     checkState();
/*      */     try
/*      */     {
/* 1033 */       this.cs.setBinaryStream(parameterName, stream, length);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1037 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setObject(String parameterName, Object value, int sqlType, int scale) throws SQLException
/*      */   {
/* 1043 */     checkState();
/*      */     try
/*      */     {
/* 1046 */       this.cs.setObject(parameterName, value, sqlType, scale);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1050 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setObject(String parameterName, Object value, int sqlType) throws SQLException
/*      */   {
/* 1056 */     checkState();
/*      */     try
/*      */     {
/* 1059 */       this.cs.setObject(parameterName, value, sqlType);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1063 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setObject(String parameterName, Object value) throws SQLException
/*      */   {
/* 1069 */     checkState();
/*      */     try
/*      */     {
/* 1072 */       this.cs.setObject(parameterName, value);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1076 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException
/*      */   {
/* 1082 */     checkState();
/*      */     try
/*      */     {
/* 1085 */       this.cs.setCharacterStream(parameterName, reader, length);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1089 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected CallableStatement getWrappedObject() throws SQLException
/*      */   {
/* 1095 */     return this.cs;
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.WrappedCallableStatement
 * JD-Core Version:    0.6.0
 */