/*     */ package org.jboss.resource.adapter.jdbc;
/*     */ 
/*     */ import java.sql.CallableStatement;
/*     */ import java.sql.Connection;
/*     */ import java.sql.DatabaseMetaData;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.SQLWarning;
/*     */ import java.sql.Savepoint;
/*     */ import java.sql.Statement;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.NestedSQLException;
/*     */ 
/*     */ public abstract class WrappedConnection extends JBossWrapper
/*     */   implements Connection
/*     */ {
/*  49 */   private static final Logger log = Logger.getLogger(WrappedConnection.class);
/*     */   private BaseWrapperManagedConnection mc;
/*     */   private WrapperDataSource dataSource;
/*     */   private HashMap<WrappedStatement, Throwable> statements;
/*  57 */   private boolean closed = false;
/*     */   private int trackStatements;
/*     */ 
/*     */   public WrappedConnection(BaseWrapperManagedConnection mc)
/*     */   {
/*  63 */     this.mc = mc;
/*  64 */     if (mc != null)
/*  65 */       this.trackStatements = mc.getTrackStatements();
/*     */   }
/*     */ 
/*     */   void setManagedConnection(BaseWrapperManagedConnection mc)
/*     */   {
/*  70 */     this.mc = mc;
/*  71 */     if (mc != null)
/*  72 */       this.trackStatements = mc.getTrackStatements();
/*     */   }
/*     */ 
/*     */   public WrapperDataSource getDataSource()
/*     */   {
/*  77 */     return this.dataSource;
/*     */   }
/*     */ 
/*     */   protected void setDataSource(WrapperDataSource dataSource)
/*     */   {
/*  82 */     this.dataSource = dataSource;
/*     */   }
/*     */ 
/*     */   public void setReadOnly(boolean readOnly) throws SQLException
/*     */   {
/*  87 */     checkStatus();
/*  88 */     this.mc.setJdbcReadOnly(readOnly);
/*     */   }
/*     */ 
/*     */   public boolean isReadOnly() throws SQLException
/*     */   {
/*  93 */     checkStatus();
/*  94 */     return this.mc.isJdbcReadOnly();
/*     */   }
/*     */ 
/*     */   public void close() throws SQLException
/*     */   {
/*  99 */     this.closed = true;
/* 100 */     if (this.mc != null)
/*     */     {
/* 102 */       if (this.trackStatements != 0)
/*     */       {
/*     */         Iterator i;
/* 104 */         synchronized (this)
/*     */         {
/* 106 */           if (this.statements != null)
/*     */           {
/* 108 */             for (i = this.statements.entrySet().iterator(); i.hasNext(); )
/*     */             {
/* 110 */               Map.Entry entry = (Map.Entry)i.next();
/* 111 */               WrappedStatement ws = (WrappedStatement)entry.getKey();
/* 112 */               if (this.trackStatements == 1)
/*     */               {
/* 114 */                 Throwable stackTrace = (Throwable)entry.getValue();
/* 115 */                 log.warn("Closing a statement you left open, please do your own housekeeping", stackTrace);
/*     */               }
/*     */               try
/*     */               {
/* 119 */                 ws.internalClose();
/*     */               }
/*     */               catch (Throwable t)
/*     */               {
/* 123 */                 log.warn("Exception trying to close statement:", t);
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/* 129 */       this.mc.closeHandle(this);
/*     */     }
/* 131 */     this.mc = null;
/* 132 */     this.dataSource = null;
/*     */   }
/*     */ 
/*     */   public boolean isClosed() throws SQLException
/*     */   {
/* 137 */     return this.closed;
/*     */   }
/*     */ 
/*     */   protected abstract WrappedStatement wrapStatement(Statement paramStatement);
/*     */ 
/*     */   public Statement createStatement() throws SQLException {
/* 144 */     checkTransaction();
/*     */     try
/*     */     {
/* 147 */       return wrapStatement(this.mc.getConnection().createStatement());
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 151 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public Statement createStatement(int resultSetType, int resultSetConcurrency)
/*     */     throws SQLException
/*     */   {
/* 157 */     checkTransaction();
/*     */     try
/*     */     {
/* 160 */       return wrapStatement(this.mc.getConnection().createStatement(resultSetType, resultSetConcurrency));
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 164 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability)
/*     */     throws SQLException
/*     */   {
/* 172 */     checkTransaction();
/*     */     try
/*     */     {
/* 175 */       return wrapStatement(this.mc.getConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*     */     }
/* 180 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   protected abstract WrappedPreparedStatement wrapPreparedStatement(PreparedStatement paramPreparedStatement);
/*     */ 
/*     */   public PreparedStatement prepareStatement(String sql) throws SQLException
/*     */   {
/* 188 */     checkTransaction();
/*     */     try
/*     */     {
/* 191 */       return wrapPreparedStatement(this.mc.prepareStatement(sql, 1003, 1007));
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 195 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency)
/*     */     throws SQLException
/*     */   {
/* 202 */     checkTransaction();
/*     */     try
/*     */     {
/* 205 */       return wrapPreparedStatement(this.mc.prepareStatement(sql, resultSetType, resultSetConcurrency));
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 209 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability)
/*     */     throws SQLException
/*     */   {
/* 216 */     checkTransaction();
/*     */     try
/*     */     {
/* 219 */       return wrapPreparedStatement(this.mc.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*     */     }
/* 224 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys)
/*     */     throws SQLException
/*     */   {
/* 230 */     checkTransaction();
/*     */     try
/*     */     {
/* 233 */       return wrapPreparedStatement(this.mc.getConnection().prepareStatement(sql, autoGeneratedKeys));
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 237 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public PreparedStatement prepareStatement(String sql, int[] columnIndexes)
/*     */     throws SQLException
/*     */   {
/* 243 */     checkTransaction();
/*     */     try
/*     */     {
/* 246 */       return wrapPreparedStatement(this.mc.getConnection().prepareStatement(sql, columnIndexes));
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 250 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public PreparedStatement prepareStatement(String sql, String[] columnNames)
/*     */     throws SQLException
/*     */   {
/* 257 */     checkTransaction();
/*     */     try
/*     */     {
/* 260 */       return wrapPreparedStatement(this.mc.getConnection().prepareStatement(sql, columnNames));
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 264 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   protected abstract WrappedCallableStatement wrapCallableStatement(CallableStatement paramCallableStatement);
/*     */ 
/*     */   public CallableStatement prepareCall(String sql) throws SQLException
/*     */   {
/* 272 */     checkTransaction();
/*     */     try
/*     */     {
/* 275 */       return wrapCallableStatement(this.mc.prepareCall(sql, 1003, 1007));
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 279 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency)
/*     */     throws SQLException
/*     */   {
/* 285 */     checkTransaction();
/*     */     try
/*     */     {
/* 288 */       return wrapCallableStatement(this.mc.prepareCall(sql, resultSetType, resultSetConcurrency));
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 292 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability)
/*     */     throws SQLException
/*     */   {
/* 300 */     checkTransaction();
/*     */     try
/*     */     {
/* 303 */       return wrapCallableStatement(this.mc.getConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*     */     }
/* 308 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public String nativeSQL(String sql)
/*     */     throws SQLException
/*     */   {
/* 314 */     checkTransaction();
/*     */     try
/*     */     {
/* 317 */       return this.mc.getConnection().nativeSQL(sql);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 321 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public void setAutoCommit(boolean autocommit)
/*     */     throws SQLException
/*     */   {
/* 327 */     checkStatus();
/* 328 */     this.mc.setJdbcAutoCommit(autocommit);
/*     */   }
/*     */ 
/*     */   public boolean getAutoCommit() throws SQLException
/*     */   {
/* 333 */     checkStatus();
/* 334 */     return this.mc.isJdbcAutoCommit();
/*     */   }
/*     */ 
/*     */   public void commit() throws SQLException
/*     */   {
/* 339 */     checkTransaction();
/* 340 */     this.mc.jdbcCommit();
/*     */   }
/*     */ 
/*     */   public void rollback() throws SQLException
/*     */   {
/* 345 */     checkTransaction();
/* 346 */     this.mc.jdbcRollback();
/*     */   }
/*     */ 
/*     */   public void rollback(Savepoint savepoint) throws SQLException
/*     */   {
/* 351 */     checkTransaction();
/* 352 */     this.mc.jdbcRollback(savepoint);
/*     */   }
/*     */ 
/*     */   public DatabaseMetaData getMetaData() throws SQLException
/*     */   {
/* 357 */     checkTransaction();
/*     */     try
/*     */     {
/* 360 */       return this.mc.getConnection().getMetaData();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 364 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public void setCatalog(String catalog)
/*     */     throws SQLException
/*     */   {
/* 370 */     checkTransaction();
/*     */     try
/*     */     {
/* 373 */       this.mc.getConnection().setCatalog(catalog);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 377 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getCatalog() throws SQLException {
/* 382 */     checkTransaction();
/*     */     try
/*     */     {
/* 385 */       return this.mc.getConnection().getCatalog();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 389 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public void setTransactionIsolation(int isolationLevel)
/*     */     throws SQLException
/*     */   {
/* 395 */     checkStatus();
/* 396 */     this.mc.setJdbcTransactionIsolation(isolationLevel);
/*     */   }
/*     */ 
/*     */   public int getTransactionIsolation() throws SQLException
/*     */   {
/* 401 */     checkStatus();
/* 402 */     return this.mc.getJdbcTransactionIsolation();
/*     */   }
/*     */ 
/*     */   public SQLWarning getWarnings() throws SQLException
/*     */   {
/* 407 */     checkTransaction();
/*     */     try
/*     */     {
/* 410 */       return this.mc.getConnection().getWarnings();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 414 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public void clearWarnings()
/*     */     throws SQLException
/*     */   {
/* 420 */     checkTransaction();
/*     */     try
/*     */     {
/* 423 */       this.mc.getConnection().clearWarnings();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 427 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Map getTypeMap()
/*     */     throws SQLException
/*     */   {
/* 434 */     checkTransaction();
/*     */     try
/*     */     {
/* 437 */       return this.mc.getConnection().getTypeMap();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 441 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public void setTypeMap(Map typeMap)
/*     */     throws SQLException
/*     */   {
/* 448 */     checkTransaction();
/*     */     try
/*     */     {
/* 451 */       this.mc.getConnection().setTypeMap(typeMap);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 455 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setHoldability(int holdability) throws SQLException
/*     */   {
/* 461 */     checkTransaction();
/*     */     try
/*     */     {
/* 464 */       this.mc.getConnection().setHoldability(holdability);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 468 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getHoldability() throws SQLException
/*     */   {
/* 474 */     checkTransaction();
/*     */     try
/*     */     {
/* 477 */       return this.mc.getConnection().getHoldability();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 481 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public Savepoint setSavepoint()
/*     */     throws SQLException
/*     */   {
/* 487 */     checkTransaction();
/*     */     try
/*     */     {
/* 490 */       return this.mc.getConnection().setSavepoint();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 494 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public Savepoint setSavepoint(String name)
/*     */     throws SQLException
/*     */   {
/* 500 */     checkTransaction();
/*     */     try
/*     */     {
/* 503 */       return this.mc.getConnection().setSavepoint(name);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 507 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public void releaseSavepoint(Savepoint savepoint)
/*     */     throws SQLException
/*     */   {
/* 513 */     checkTransaction();
/*     */     try
/*     */     {
/* 516 */       this.mc.getConnection().releaseSavepoint(savepoint);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 520 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Connection getUnderlyingConnection() throws SQLException
/*     */   {
/* 526 */     checkTransaction();
/* 527 */     return this.mc.getConnection();
/*     */   }
/*     */ 
/*     */   protected Connection getWrappedObject() throws SQLException
/*     */   {
/* 532 */     return getUnderlyingConnection();
/*     */   }
/*     */ 
/*     */   protected void checkTransaction() throws SQLException
/*     */   {
/* 537 */     checkStatus();
/* 538 */     this.mc.checkTransaction();
/*     */   }
/*     */ 
/*     */   protected void checkStatus()
/*     */     throws SQLException
/*     */   {
/* 549 */     if (this.closed)
/* 550 */       throw new SQLException("Connection handle has been closed and is unusable");
/* 551 */     if (this.mc == null)
/* 552 */       throw new SQLException("Connection handle is not currently associated with a ManagedConnection");
/*     */   }
/*     */ 
/*     */   protected SQLException checkException(Throwable t)
/*     */     throws SQLException
/*     */   {
/* 566 */     Throwable result = null;
/*     */ 
/* 568 */     if (this.mc != null) {
/* 569 */       result = this.mc.connectionError(t);
/*     */     }
/* 571 */     if ((result instanceof SQLException))
/*     */     {
/* 573 */       throw ((SQLException)result);
/*     */     }
/*     */ 
/* 577 */     throw new NestedSQLException("Error", result);
/*     */   }
/*     */ 
/*     */   int getTrackStatements()
/*     */   {
/* 584 */     return this.trackStatements;
/*     */   }
/*     */ 
/*     */   void registerStatement(WrappedStatement ws)
/*     */   {
/* 589 */     if (this.trackStatements == 0) {
/* 590 */       return;
/*     */     }
/* 592 */     synchronized (this)
/*     */     {
/* 594 */       if (this.statements == null) {
/* 595 */         this.statements = new HashMap();
/*     */       }
/* 597 */       if (this.trackStatements == 1)
/* 598 */         this.statements.put(ws, new Throwable("STACKTRACE"));
/*     */       else
/* 600 */         this.statements.put(ws, null);
/*     */     }
/*     */   }
/*     */ 
/*     */   void unregisterStatement(WrappedStatement ws)
/*     */   {
/* 606 */     if (this.trackStatements == 0)
/* 607 */       return;
/* 608 */     synchronized (this)
/*     */     {
/* 610 */       if (this.statements != null)
/* 611 */         this.statements.remove(ws);
/*     */     }
/*     */   }
/*     */ 
/*     */   void checkConfiguredQueryTimeout(WrappedStatement ws) throws SQLException
/*     */   {
/* 617 */     if ((this.mc == null) || (this.dataSource == null)) {
/* 618 */       return;
/*     */     }
/* 620 */     int timeout = 0;
/*     */ 
/* 623 */     if (this.mc.isTransactionQueryTimeout()) {
/* 624 */       timeout = this.dataSource.getTimeLeftBeforeTransactionTimeout();
/*     */     }
/*     */ 
/* 627 */     if (timeout <= 0) {
/* 628 */       timeout = this.mc.getQueryTimeout();
/*     */     }
/* 630 */     if (timeout > 0)
/* 631 */       ws.setQueryTimeout(timeout);
/*     */   }
/*     */ 
/*     */   Logger getLogger()
/*     */   {
/* 636 */     return log;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.WrappedConnection
 * JD-Core Version:    0.6.0
 */