/*     */ package org.jboss.resource.adapter.jdbc;
/*     */ 
/*     */ import java.io.PrintWriter;
/*     */ import java.io.Serializable;
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import javax.naming.Reference;
/*     */ import javax.resource.Referenceable;
/*     */ import javax.resource.ResourceException;
/*     */ import javax.resource.spi.ConnectionManager;
/*     */ import javax.resource.spi.ConnectionRequestInfo;
/*     */ import javax.sql.DataSource;
/*     */ import javax.transaction.RollbackException;
/*     */ import org.jboss.tm.TransactionTimeoutConfiguration;
/*     */ import org.jboss.util.NestedSQLException;
/*     */ 
/*     */ public class WrapperDataSource extends JBossWrapper
/*     */   implements Referenceable, DataSource, Serializable
/*     */ {
/*     */   static final long serialVersionUID = 3570285419164793501L;
/*     */   private final BaseWrapperManagedConnectionFactory mcf;
/*     */   private final ConnectionManager cm;
/*     */   private Reference reference;
/*     */ 
/*     */   protected WrapperDataSource(BaseWrapperManagedConnectionFactory mcf, ConnectionManager cm)
/*     */   {
/*  58 */     this.mcf = mcf;
/*  59 */     this.cm = cm;
/*     */   }
/*     */ 
/*     */   public PrintWriter getLogWriter()
/*     */     throws SQLException
/*     */   {
/*  65 */     return null;
/*     */   }
/*     */ 
/*     */   public void setLogWriter(PrintWriter param1)
/*     */     throws SQLException
/*     */   {
/*     */   }
/*     */ 
/*     */   public int getLoginTimeout()
/*     */     throws SQLException
/*     */   {
/*  76 */     return 0;
/*     */   }
/*     */ 
/*     */   public void setLoginTimeout(int param1)
/*     */     throws SQLException
/*     */   {
/*     */   }
/*     */ 
/*     */   public Connection getConnection() throws SQLException
/*     */   {
/*     */     try
/*     */     {
/*  88 */       WrappedConnection wc = (WrappedConnection)this.cm.allocateConnection(this.mcf, null);
/*  89 */       wc.setDataSource(this);
/*  90 */       return wc;
/*     */     }
/*     */     catch (ResourceException re) {
/*     */     }
/*  94 */     throw new NestedSQLException(re);
/*     */   }
/*     */ 
/*     */   public Connection getConnection(String user, String password)
/*     */     throws SQLException
/*     */   {
/* 100 */     ConnectionRequestInfo cri = new WrappedConnectionRequestInfo(user, password);
/*     */     try
/*     */     {
/* 103 */       WrappedConnection wc = (WrappedConnection)this.cm.allocateConnection(this.mcf, cri);
/* 104 */       wc.setDataSource(this);
/* 105 */       return wc;
/*     */     }
/*     */     catch (ResourceException re) {
/*     */     }
/* 109 */     throw new NestedSQLException(re);
/*     */   }
/*     */ 
/*     */   public void setReference(Reference reference)
/*     */   {
/* 115 */     this.reference = reference;
/*     */   }
/*     */ 
/*     */   public Reference getReference()
/*     */   {
/* 120 */     return this.reference;
/*     */   }
/*     */ 
/*     */   protected int getTimeLeftBeforeTransactionTimeout() throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 127 */       if ((this.cm instanceof TransactionTimeoutConfiguration))
/*     */       {
/* 129 */         long timeout = ((TransactionTimeoutConfiguration)this.cm).getTimeLeftBeforeTransactionTimeout(true);
/*     */ 
/* 131 */         if (timeout == -1L) {
/* 132 */           return -1;
/*     */         }
/* 134 */         long result = timeout / 1000L;
/* 135 */         if (result % 1000L != 0L)
/* 136 */           result += 1L;
/* 137 */         return (int)result;
/*     */       }
/*     */ 
/* 140 */       return -1;
/*     */     }
/*     */     catch (RollbackException e) {
/*     */     }
/* 144 */     throw new NestedSQLException(e);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.WrapperDataSource
 * JD-Core Version:    0.6.0
 */