/*    */ package org.jboss.resource.adapter.jdbc.jdk6;
/*    */ 
/*    */ import java.sql.ResultSet;
/*    */ import java.sql.SQLException;
/*    */ import java.sql.Statement;
/*    */ import org.jboss.resource.adapter.jdbc.WrappedResultSet;
/*    */ import org.jboss.resource.adapter.jdbc.WrappedStatement;
/*    */ 
/*    */ public class WrappedStatementJDK6 extends WrappedStatement
/*    */ {
/*    */   public WrappedStatementJDK6(WrappedConnectionJDK6 lc, Statement s)
/*    */   {
/* 41 */     super(lc, s);
/*    */   }
/*    */ 
/*    */   protected WrappedResultSet wrapResultSet(ResultSet resultSet)
/*    */   {
/* 46 */     return new WrappedResultSetJDK6(this, resultSet);
/*    */   }
/*    */ 
/*    */   public boolean isClosed() throws SQLException
/*    */   {
/*    */     try
/*    */     {
/* 53 */       Statement wrapped = getWrappedObject();
/* 54 */       if (wrapped == null)
/* 55 */         return true;
/* 56 */       return wrapped.isClosed();
/*    */     }
/*    */     catch (Throwable t) {
/*    */     }
/* 60 */     throw checkException(t);
/*    */   }
/*    */ 
/*    */   public boolean isPoolable()
/*    */     throws SQLException
/*    */   {
/* 66 */     Statement statement = getUnderlyingStatement();
/*    */     try
/*    */     {
/* 69 */       return statement.isPoolable();
/*    */     }
/*    */     catch (Throwable t) {
/*    */     }
/* 73 */     throw checkException(t);
/*    */   }
/*    */ 
/*    */   public void setPoolable(boolean poolable)
/*    */     throws SQLException
/*    */   {
/* 79 */     Statement statement = getUnderlyingStatement();
/*    */     try
/*    */     {
/* 82 */       statement.setPoolable(poolable);
/*    */     }
/*    */     catch (Throwable t)
/*    */     {
/* 86 */       throw checkException(t);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.jdk6.WrappedStatementJDK6
 * JD-Core Version:    0.6.0
 */