/*     */ package org.jboss.resource.adapter.jdbc.remote;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.sql.ResultSetMetaData;
/*     */ import java.sql.SQLException;
/*     */ import org.jboss.resource.adapter.jdbc.JBossWrapper;
/*     */ 
/*     */ public class SerializableResultSetMetaData extends JBossWrapper
/*     */   implements ResultSetMetaData, Serializable
/*     */ {
/*     */   static final long serialVersionUID = -6663485432752348789L;
/*     */   private ColumnData[] columnData;
/*     */ 
/*     */   SerializableResultSetMetaData(ResultSetMetaData metaData)
/*     */     throws SQLException
/*     */   {
/*  55 */     int count = metaData.getColumnCount();
/*  56 */     this.columnData = new ColumnData[count + 1];
/*  57 */     for (int c = 1; c <= count; c++)
/*     */     {
/*  59 */       ColumnData data = new ColumnData(null);
/*  60 */       this.columnData[c] = data;
/*  61 */       data.label = metaData.getColumnLabel(c);
/*  62 */       data.name = metaData.getColumnName(c);
/*  63 */       data.type = metaData.getColumnType(c);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getColumnCount()
/*     */     throws SQLException
/*     */   {
/*  71 */     return this.columnData.length - 1;
/*     */   }
/*     */ 
/*     */   public boolean isAutoIncrement(int column) throws SQLException
/*     */   {
/*  76 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isCaseSensitive(int column) throws SQLException
/*     */   {
/*  81 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isSearchable(int column) throws SQLException
/*     */   {
/*  86 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isCurrency(int column) throws SQLException
/*     */   {
/*  91 */     return false;
/*     */   }
/*     */ 
/*     */   public int isNullable(int column) throws SQLException
/*     */   {
/*  96 */     return 0;
/*     */   }
/*     */ 
/*     */   public boolean isSigned(int column) throws SQLException
/*     */   {
/* 101 */     return false;
/*     */   }
/*     */ 
/*     */   public int getColumnDisplaySize(int column) throws SQLException
/*     */   {
/* 106 */     return 0;
/*     */   }
/*     */ 
/*     */   public String getColumnLabel(int column) throws SQLException
/*     */   {
/* 111 */     return this.columnData[column].label;
/*     */   }
/*     */ 
/*     */   public String getColumnName(int column) throws SQLException
/*     */   {
/* 116 */     return this.columnData[column].name;
/*     */   }
/*     */ 
/*     */   public String getSchemaName(int column) throws SQLException
/*     */   {
/* 121 */     return null;
/*     */   }
/*     */ 
/*     */   public int getPrecision(int column) throws SQLException
/*     */   {
/* 126 */     return 0;
/*     */   }
/*     */ 
/*     */   public int getScale(int column) throws SQLException
/*     */   {
/* 131 */     return 0;
/*     */   }
/*     */ 
/*     */   public String getTableName(int column) throws SQLException
/*     */   {
/* 136 */     return "";
/*     */   }
/*     */ 
/*     */   public String getCatalogName(int column) throws SQLException
/*     */   {
/* 141 */     return "";
/*     */   }
/*     */ 
/*     */   public int getColumnType(int column) throws SQLException
/*     */   {
/* 146 */     return this.columnData[column].type;
/*     */   }
/*     */ 
/*     */   public String getColumnTypeName(int column) throws SQLException
/*     */   {
/* 151 */     return this.columnData[column].typeName;
/*     */   }
/*     */ 
/*     */   public boolean isReadOnly(int column) throws SQLException
/*     */   {
/* 156 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isWritable(int column) throws SQLException
/*     */   {
/* 161 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isDefinitelyWritable(int column) throws SQLException
/*     */   {
/* 166 */     return false;
/*     */   }
/*     */ 
/*     */   public String getColumnClassName(int column) throws SQLException
/*     */   {
/* 171 */     return this.columnData[column].className;
/*     */   }
/*     */ 
/*     */   private static class ColumnData
/*     */     implements Serializable
/*     */   {
/*     */     static final long serialVersionUID = 5060626133767712300L;
/*     */     String className;
/*     */     String label;
/*     */     String name;
/*     */     int type;
/*     */     String typeName;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.remote.SerializableResultSetMetaData
 * JD-Core Version:    0.6.0
 */