/*    */ package org.jboss.resource.adapter.jdbc.vendor;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import java.sql.SQLException;
/*    */ import org.jboss.resource.adapter.jdbc.ExceptionSorter;
/*    */ 
/*    */ public class OracleExceptionSorter
/*    */   implements ExceptionSorter, Serializable
/*    */ {
/*    */   private static final long serialVersionUID = 573723525408205079L;
/*    */ 
/*    */   public boolean isExceptionFatal(SQLException e)
/*    */   {
/* 50 */     int error_code = Math.abs(e.getErrorCode());
/*    */ 
/* 52 */     if ((error_code == 28) || (error_code == 600) || (error_code == 1012) || (error_code == 1014) || (error_code == 1033) || (error_code == 1034) || (error_code == 1035) || (error_code == 1089) || (error_code == 1090) || (error_code == 1092) || (error_code == 1094) || (error_code == 2396) || (error_code == 3106) || (error_code == 3111) || (error_code == 3113) || (error_code == 3114) || ((error_code >= 12100) && (error_code <= 12299)))
/*    */     {
/* 70 */       return true;
/*    */     }
/*    */ 
/* 73 */     String error_text = e.getMessage().toUpperCase();
/*    */ 
/* 83 */     return ((error_code < 20000) || (error_code >= 21000)) && ((error_text.indexOf("SOCKET") > -1) || (error_text.indexOf("CONNECTION HAS ALREADY BEEN CLOSED") > -1) || (error_text.indexOf("BROKEN PIPE") > -1));
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.vendor.OracleExceptionSorter
 * JD-Core Version:    0.6.0
 */