/*    */ package org.jboss.resource.adapter.jdbc.vendor;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import java.lang.reflect.Method;
/*    */ import java.sql.Connection;
/*    */ import java.sql.SQLException;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.resource.adapter.jdbc.ValidConnectionChecker;
/*    */ import org.jboss.util.NestedRuntimeException;
/*    */ 
/*    */ public class OracleValidConnectionChecker
/*    */   implements ValidConnectionChecker, Serializable
/*    */ {
/*    */   private static final long serialVersionUID = -2227528634302168877L;
/* 44 */   private static final Logger log = Logger.getLogger(OracleValidConnectionChecker.class);
/*    */   private Method ping;
/* 49 */   private static Object[] params = { new Integer(5000) };
/*    */ 
/*    */   public OracleValidConnectionChecker()
/*    */   {
/*    */     try
/*    */     {
/* 55 */       Class oracleConnection = Thread.currentThread().getContextClassLoader().loadClass("oracle.jdbc.driver.OracleConnection");
/* 56 */       this.ping = oracleConnection.getMethod("pingDatabase", new Class[] { Integer.TYPE });
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 60 */       throw new NestedRuntimeException("Unable to resolve pingDatabase method:", e);
/*    */     }
/*    */   }
/*    */ 
/*    */   public SQLException isValidConnection(Connection c)
/*    */   {
/*    */     try
/*    */     {
/* 68 */       Integer status = (Integer)this.ping.invoke(c, params);
/*    */ 
/* 71 */       if (status.intValue() < 0) {
/* 72 */         return new SQLException("pingDatabase failed status=" + status);
/*    */       }
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 77 */       log.warn("Unexpected error in pingDatabase", e);
/*    */     }
/*    */ 
/* 81 */     return null;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.vendor.OracleValidConnectionChecker
 * JD-Core Version:    0.6.0
 */