/*     */ package org.jboss.resource.adapter.jdbc.xa;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Properties;
/*     */ import javax.resource.ResourceException;
/*     */ import javax.resource.spi.LocalTransaction;
/*     */ import javax.sql.ConnectionEvent;
/*     */ import javax.sql.ConnectionEventListener;
/*     */ import javax.sql.XAConnection;
/*     */ import javax.transaction.xa.XAException;
/*     */ import javax.transaction.xa.XAResource;
/*     */ import javax.transaction.xa.Xid;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.resource.JBossResourceException;
/*     */ import org.jboss.resource.adapter.jdbc.BaseWrapperManagedConnection;
/*     */ 
/*     */ public class XAManagedConnection extends BaseWrapperManagedConnection
/*     */   implements XAResource, LocalTransaction
/*     */ {
/*     */   protected final XAConnection xaConnection;
/*     */   protected final XAResource xaResource;
/*     */   protected Xid currentXid;
/*     */ 
/*     */   public XAManagedConnection(XAManagedConnectionFactory mcf, XAConnection xaConnection, Properties props, int transactionIsolation, int psCacheSize)
/*     */     throws SQLException
/*     */   {
/*  56 */     super(mcf, xaConnection.getConnection(), props, transactionIsolation, psCacheSize);
/*  57 */     this.xaConnection = xaConnection;
/*  58 */     xaConnection.addConnectionEventListener(new ConnectionEventListener()
/*     */     {
/*     */       public void connectionClosed(ConnectionEvent ce)
/*     */       {
/*     */       }
/*     */ 
/*     */       public void connectionErrorOccurred(ConnectionEvent ce)
/*     */       {
/*  67 */         SQLException ex = ce.getSQLException();
/*  68 */         XAManagedConnection.this.broadcastConnectionError(ex);
/*     */       }
/*     */     });
/*  71 */     this.xaResource = xaConnection.getXAResource();
/*     */   }
/*     */ 
/*     */   public void begin() throws ResourceException
/*     */   {
/*  76 */     synchronized (this.stateLock)
/*     */     {
/*  78 */       if (!this.inManagedTransaction)
/*     */       {
/*     */         try
/*     */         {
/*  82 */           if (this.underlyingAutoCommit)
/*     */           {
/*  84 */             this.underlyingAutoCommit = false;
/*  85 */             this.con.setAutoCommit(false);
/*     */           }
/*  87 */           checkState();
/*  88 */           this.inManagedTransaction = true;
/*     */         }
/*     */         catch (SQLException e)
/*     */         {
/*  92 */           checkException(e);
/*     */         }
/*     */       }
/*     */       else
/*  96 */         throw new JBossResourceException("Trying to begin a nested local tx");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void commit() throws ResourceException
/*     */   {
/* 102 */     synchronized (this.stateLock)
/*     */     {
/* 104 */       if (this.inManagedTransaction)
/* 105 */         this.inManagedTransaction = false;
/*     */     }
/*     */     try
/*     */     {
/* 109 */       this.con.commit();
/*     */     }
/*     */     catch (SQLException e)
/*     */     {
/* 113 */       checkException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void rollback()
/*     */     throws ResourceException
/*     */   {
/* 120 */     synchronized (this.stateLock)
/*     */     {
/* 122 */       if (this.inManagedTransaction)
/* 123 */         this.inManagedTransaction = false;
/*     */     }
/*     */     try
/*     */     {
/* 127 */       this.con.rollback();
/*     */     }
/*     */     catch (SQLException e)
/*     */     {
/*     */       try
/*     */       {
/* 133 */         checkException(e);
/*     */       }
/*     */       catch (Exception e2)
/*     */       {
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void broadcastConnectionError(SQLException e)
/*     */   {
/* 143 */     super.broadcastConnectionError(e);
/*     */   }
/*     */ 
/*     */   public LocalTransaction getLocalTransaction() throws ResourceException
/*     */   {
/* 148 */     return this;
/*     */   }
/*     */ 
/*     */   public XAResource getXAResource() throws ResourceException
/*     */   {
/* 153 */     return this;
/*     */   }
/*     */ 
/*     */   public void destroy() throws ResourceException
/*     */   {
/*     */     try
/*     */     {
/* 160 */       super.destroy();
/*     */     }
/*     */     finally
/*     */     {
/*     */       try
/*     */       {
/* 166 */         this.xaConnection.close();
/*     */       }
/*     */       catch (SQLException e)
/*     */       {
/* 170 */         checkException(e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void start(Xid xid, int flags) throws XAException
/*     */   {
/*     */     try
/*     */     {
/* 179 */       checkState();
/*     */     }
/*     */     catch (SQLException e)
/*     */     {
/* 183 */       getLog().warn("Error setting state ", e);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 188 */       this.xaResource.start(xid, flags);
/*     */     }
/*     */     catch (XAException e)
/*     */     {
/* 194 */       if (isFailedXA(e.errorCode))
/*     */       {
/* 196 */         broadcastConnectionError(e);
/*     */       }
/*     */ 
/* 199 */       throw e;
/*     */     }
/*     */ 
/* 202 */     synchronized (this.stateLock)
/*     */     {
/* 204 */       this.currentXid = xid;
/* 205 */       this.inManagedTransaction = true;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void end(Xid xid, int flags)
/*     */     throws XAException
/*     */   {
/*     */     try
/*     */     {
/* 214 */       this.xaResource.end(xid, flags);
/*     */     }
/*     */     catch (XAException e)
/*     */     {
/* 218 */       broadcastConnectionError(e);
/* 219 */       throw e;
/*     */     }
/*     */ 
/* 225 */     synchronized (this.stateLock)
/*     */     {
/* 227 */       if ((this.currentXid != null) && (this.currentXid.equals(xid)))
/*     */       {
/* 229 */         this.inManagedTransaction = false;
/* 230 */         this.currentXid = null;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public int prepare(Xid xid) throws XAException
/*     */   {
/* 237 */     return this.xaResource.prepare(xid);
/*     */   }
/*     */ 
/*     */   public void commit(Xid xid, boolean onePhase) throws XAException
/*     */   {
/* 242 */     this.xaResource.commit(xid, onePhase);
/*     */   }
/*     */ 
/*     */   public void rollback(Xid xid) throws XAException
/*     */   {
/* 247 */     this.xaResource.rollback(xid);
/*     */   }
/*     */ 
/*     */   public void forget(Xid xid) throws XAException
/*     */   {
/* 252 */     this.xaResource.forget(xid);
/*     */   }
/*     */ 
/*     */   public Xid[] recover(int flag) throws XAException
/*     */   {
/* 257 */     return this.xaResource.recover(flag);
/*     */   }
/*     */ 
/*     */   public boolean isSameRM(XAResource other) throws XAException
/*     */   {
/* 262 */     Boolean overrideValue = ((XAManagedConnectionFactory)this.mcf).getIsSameRMOverrideValue();
/* 263 */     if (overrideValue != null)
/*     */     {
/* 265 */       return overrideValue.booleanValue();
/*     */     }
/*     */ 
/* 269 */     return (other instanceof XAManagedConnection) ? this.xaResource.isSameRM(((XAManagedConnection)other).xaResource) : this.xaResource.isSameRM(other);
/*     */   }
/*     */ 
/*     */   public int getTransactionTimeout()
/*     */     throws XAException
/*     */   {
/* 276 */     return this.xaResource.getTransactionTimeout();
/*     */   }
/*     */ 
/*     */   public boolean setTransactionTimeout(int seconds) throws XAException
/*     */   {
/* 281 */     return this.xaResource.setTransactionTimeout(seconds);
/*     */   }
/*     */ 
/*     */   private boolean isFailedXA(int errorCode)
/*     */   {
/* 287 */     return (errorCode == -3) || (errorCode == -7);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.xa.XAManagedConnection
 * JD-Core Version:    0.6.0
 */