/*     */ package org.jboss.resource.adapter.jms;
/*     */ 
/*     */ import javax.jms.BytesMessage;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.MapMessage;
/*     */ import javax.jms.Message;
/*     */ import javax.jms.MessageConsumer;
/*     */ import javax.jms.MessageListener;
/*     */ import javax.jms.ObjectMessage;
/*     */ import javax.jms.StreamMessage;
/*     */ import javax.jms.TextMessage;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class JmsMessageConsumer
/*     */   implements MessageConsumer
/*     */ {
/*  44 */   private static final Logger log = Logger.getLogger(JmsMessageConsumer.class);
/*     */   MessageConsumer consumer;
/*     */   JmsSession session;
/*  53 */   private boolean trace = log.isTraceEnabled();
/*     */ 
/*     */   public JmsMessageConsumer(MessageConsumer consumer, JmsSession session)
/*     */   {
/*  63 */     this.consumer = consumer;
/*  64 */     this.session = session;
/*     */ 
/*  66 */     if (this.trace)
/*  67 */       log.trace("new JmsMessageConsumer " + this + " consumer=" + consumer + " session=" + session);
/*     */   }
/*     */ 
/*     */   public void close() throws JMSException
/*     */   {
/*  72 */     if (this.trace)
/*  73 */       log.trace("close " + this);
/*     */     try
/*     */     {
/*  76 */       closeConsumer();
/*     */     }
/*     */     finally
/*     */     {
/*  80 */       this.session.removeConsumer(this);
/*     */     }
/*     */   }
/*     */ 
/*     */   public MessageListener getMessageListener() throws JMSException
/*     */   {
/*  86 */     this.session.checkStrict();
/*  87 */     return this.consumer.getMessageListener();
/*     */   }
/*     */ 
/*     */   public String getMessageSelector() throws JMSException
/*     */   {
/*  92 */     return this.consumer.getMessageSelector();
/*     */   }
/*     */ 
/*     */   public Message receive() throws JMSException
/*     */   {
/*  97 */     if (this.trace)
/*  98 */       log.trace("receive " + this);
/*  99 */     Message message = this.consumer.receive();
/* 100 */     if (this.trace)
/* 101 */       log.trace("received " + this + " result=" + message);
/* 102 */     if (message == null) {
/* 103 */       return null;
/*     */     }
/* 105 */     return wrapMessage(message);
/*     */   }
/*     */ 
/*     */   public Message receive(long timeout) throws JMSException
/*     */   {
/* 110 */     if (this.trace)
/* 111 */       log.trace("receive " + this + " timeout=" + timeout);
/* 112 */     Message message = this.consumer.receive(timeout);
/* 113 */     if (this.trace)
/* 114 */       log.trace("received " + this + " result=" + message);
/* 115 */     if (message == null) {
/* 116 */       return null;
/*     */     }
/* 118 */     return wrapMessage(message);
/*     */   }
/*     */ 
/*     */   public Message receiveNoWait() throws JMSException
/*     */   {
/* 123 */     if (this.trace)
/* 124 */       log.trace("receiveNoWait " + this);
/* 125 */     Message message = this.consumer.receiveNoWait();
/* 126 */     if (this.trace)
/* 127 */       log.trace("received " + this + " result=" + message);
/* 128 */     if (message == null) {
/* 129 */       return null;
/*     */     }
/* 131 */     return wrapMessage(message);
/*     */   }
/*     */ 
/*     */   public void setMessageListener(MessageListener listener) throws JMSException
/*     */   {
/* 136 */     this.session.checkStrict();
/* 137 */     if (listener == null)
/* 138 */       this.consumer.setMessageListener(null);
/*     */     else
/* 140 */       this.consumer.setMessageListener(wrapMessageListener(listener));
/*     */   }
/*     */ 
/*     */   void closeConsumer() throws JMSException
/*     */   {
/* 145 */     this.consumer.close();
/*     */   }
/*     */ 
/*     */   Message wrapMessage(Message message)
/*     */   {
/* 150 */     if ((message instanceof BytesMessage))
/* 151 */       return new JmsBytesMessage((BytesMessage)message, this.session);
/* 152 */     if ((message instanceof MapMessage))
/* 153 */       return new JmsMapMessage((MapMessage)message, this.session);
/* 154 */     if ((message instanceof ObjectMessage))
/* 155 */       return new JmsObjectMessage((ObjectMessage)message, this.session);
/* 156 */     if ((message instanceof StreamMessage))
/* 157 */       return new JmsStreamMessage((StreamMessage)message, this.session);
/* 158 */     if ((message instanceof TextMessage))
/* 159 */       return new JmsTextMessage((TextMessage)message, this.session);
/* 160 */     return new JmsMessage(message, this.session);
/*     */   }
/*     */ 
/*     */   MessageListener wrapMessageListener(MessageListener listener)
/*     */   {
/* 165 */     return new JmsMessageListener(listener, this);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jms.JmsMessageConsumer
 * JD-Core Version:    0.6.0
 */