/*     */ package org.jboss.resource.connectionmanager;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedList;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import java.util.WeakHashMap;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.resource.ResourceException;
/*     */ import javax.resource.spi.ConnectionRequestInfo;
/*     */ import javax.transaction.Synchronization;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.ejb.EnterpriseContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.jboss.tm.TxUtils;
/*     */ import org.jboss.tm.usertx.client.ServerVMClientUserTransaction;
/*     */ import org.jboss.tm.usertx.client.ServerVMClientUserTransaction.UserTransactionStartedListener;
/*     */ import org.jboss.util.Strings;
/*     */ 
/*     */ public class CachedConnectionManager extends ServiceMBeanSupport
/*     */   implements ServerVMClientUserTransaction.UserTransactionStartedListener, CachedConnectionManagerMBean
/*     */ {
/*     */   private boolean specCompliant;
/*     */   protected boolean trace;
/*     */   private boolean debug;
/*     */   protected boolean error;
/*     */   private ObjectName transactionManagerServiceName;
/*     */   private TransactionManager tm;
/*  86 */   private final ThreadLocal currentObjects = new ThreadLocal();
/*     */ 
/*  93 */   private final Map objectToConnectionManagerMap = new HashMap();
/*     */ 
/*  98 */   private Map connectionStackTraces = new WeakHashMap();
/*     */ 
/*     */   public CachedConnectionManager()
/*     */   {
/* 109 */     this.trace = this.log.isTraceEnabled();
/*     */   }
/*     */ 
/*     */   public boolean isSpecCompliant()
/*     */   {
/* 114 */     return this.specCompliant;
/*     */   }
/*     */ 
/*     */   public void setSpecCompliant(boolean specCompliant)
/*     */   {
/* 119 */     if (specCompliant)
/* 120 */       this.log.warn("THE SpecCompliant ATTRIBUTE IS MISNAMED SEE http://jira.jboss.com/jira/browse/JBAS-1662");
/* 121 */     this.specCompliant = specCompliant;
/*     */   }
/*     */ 
/*     */   public boolean isDebug()
/*     */   {
/* 126 */     return this.debug;
/*     */   }
/*     */ 
/*     */   public void setDebug(boolean value)
/*     */   {
/* 131 */     this.debug = value;
/*     */   }
/*     */ 
/*     */   public boolean isError()
/*     */   {
/* 136 */     return this.error;
/*     */   }
/*     */ 
/*     */   public void setError(boolean value)
/*     */   {
/* 141 */     this.error = value;
/*     */   }
/*     */ 
/*     */   public ObjectName getTransactionManagerServiceName()
/*     */   {
/* 146 */     return this.transactionManagerServiceName;
/*     */   }
/*     */ 
/*     */   public void setTransactionManagerServiceName(ObjectName transactionManagerServiceName)
/*     */   {
/* 151 */     this.transactionManagerServiceName = transactionManagerServiceName;
/*     */   }
/*     */ 
/*     */   public CachedConnectionManager getInstance()
/*     */   {
/* 156 */     return this;
/*     */   }
/*     */ 
/*     */   public int getInUseConnections()
/*     */   {
/* 161 */     synchronized (this.connectionStackTraces)
/*     */     {
/* 163 */       return this.connectionStackTraces.size();
/*     */     }
/*     */   }
/*     */ 
/*     */   public Map listInUseConnections()
/*     */   {
/* 169 */     synchronized (this.connectionStackTraces)
/*     */     {
/* 171 */       HashMap result = new HashMap();
/* 172 */       for (Iterator i = this.connectionStackTraces.entrySet().iterator(); i.hasNext(); )
/*     */       {
/* 174 */         Map.Entry entry = (Map.Entry)i.next();
/* 175 */         Throwable stackTrace = (Throwable)entry.getValue();
/* 176 */         ByteArrayOutputStream baos = new ByteArrayOutputStream();
/* 177 */         PrintStream ps = new PrintStream(baos);
/* 178 */         stackTrace.printStackTrace(ps);
/* 179 */         result.put(entry.getKey().toString(), baos.toString());
/*     */       }
/* 181 */       return result;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/* 188 */     this.tm = ((TransactionManager)getServer().getAttribute(this.transactionManagerServiceName, "TransactionManager"));
/*     */ 
/* 190 */     TransactionSynchronizer.setTransactionManager(this.tm);
/* 191 */     ServerVMClientUserTransaction.getSingleton().registerTxStartedListener(this);
/* 192 */     EnterpriseContext.setUserTransactionStartedListener(this);
/*     */   }
/*     */ 
/*     */   protected void stopService() throws Exception
/*     */   {
/* 197 */     ServerVMClientUserTransaction.getSingleton().unregisterTxStartedListener(this);
/* 198 */     EnterpriseContext.setUserTransactionStartedListener(null);
/*     */   }
/*     */ 
/*     */   public void pushMetaAwareObject(Object rawKey, Set unsharableResources)
/*     */     throws ResourceException
/*     */   {
/* 214 */     LinkedList stack = (LinkedList)this.currentObjects.get();
/* 215 */     if (stack == null)
/*     */     {
/* 217 */       if (this.trace)
/* 218 */         this.log.trace("new stack for key: " + Strings.defaultToString(rawKey));
/* 219 */       stack = new LinkedList();
/* 220 */       this.currentObjects.set(stack);
/*     */     }
/* 224 */     else if (this.trace) {
/* 225 */       this.log.trace("old stack for key: " + Strings.defaultToString(rawKey));
/*     */     }
/*     */ 
/* 232 */     KeyConnectionAssociation key = new KeyConnectionAssociation(rawKey);
/* 233 */     if ((this.specCompliant) && (!stack.contains(key)))
/*     */     {
/* 235 */       reconnect(key, unsharableResources);
/*     */     }
/* 237 */     stack.addLast(key);
/*     */   }
/*     */ 
/*     */   public void popMetaAwareObject(Set unsharableResources)
/*     */     throws ResourceException
/*     */   {
/* 249 */     LinkedList stack = (LinkedList)this.currentObjects.get();
/* 250 */     KeyConnectionAssociation oldKey = (KeyConnectionAssociation)stack.removeLast();
/* 251 */     if (this.trace)
/* 252 */       this.log.trace("popped object: " + Strings.defaultToString(oldKey));
/* 253 */     if (this.specCompliant)
/*     */     {
/* 255 */       if (!stack.contains(oldKey))
/*     */       {
/* 257 */         disconnect(oldKey, unsharableResources);
/*     */       }
/*     */     }
/* 260 */     else if (this.debug)
/*     */     {
/* 262 */       if ((closeAll(oldKey.getCMToConnectionsMap())) && (this.error))
/* 263 */         throw new ResourceException("Some connections were not closed, see the log for the allocation stacktraces");
/*     */     }
/*     */   }
/*     */ 
/*     */   KeyConnectionAssociation peekMetaAwareObject()
/*     */   {
/* 273 */     LinkedList stack = (LinkedList)this.currentObjects.get();
/* 274 */     if (stack == null)
/* 275 */       return null;
/* 276 */     if (!stack.isEmpty()) {
/* 277 */       return (KeyConnectionAssociation)stack.getLast();
/*     */     }
/* 279 */     return null;
/*     */   }
/*     */ 
/*     */   void registerConnection(ConnectionCacheListener cm, ConnectionListener cl, Object connection, ConnectionRequestInfo cri)
/*     */   {
/* 286 */     if (this.debug)
/*     */     {
/* 288 */       synchronized (this.connectionStackTraces)
/*     */       {
/* 290 */         this.connectionStackTraces.put(connection, new Throwable("STACKTRACE"));
/*     */       }
/*     */     }
/*     */ 
/* 294 */     KeyConnectionAssociation key = peekMetaAwareObject();
/* 295 */     if (this.trace)
/* 296 */       this.log.trace("registering connection from " + cm + ", connection : " + connection + ", key: " + key);
/* 297 */     if (key == null) {
/* 298 */       return;
/*     */     }
/* 300 */     ConnectionRecord cr = new ConnectionRecord(cl, connection, cri);
/* 301 */     Map cmToConnectionsMap = key.getCMToConnectionsMap();
/* 302 */     Collection conns = (Collection)cmToConnectionsMap.get(cm);
/* 303 */     if (conns == null)
/*     */     {
/* 305 */       conns = new ArrayList();
/* 306 */       cmToConnectionsMap.put(cm, conns);
/*     */     }
/* 308 */     conns.add(cr);
/*     */   }
/*     */ 
/*     */   void unregisterConnection(ConnectionCacheListener cm, Object c)
/*     */   {
/* 313 */     if (this.debug)
/*     */     {
/* 315 */       CloseConnectionSynchronization cas = getCloseConnectionSynchronization(false);
/* 316 */       if (cas != null)
/* 317 */         cas.remove(c);
/* 318 */       synchronized (this.connectionStackTraces)
/*     */       {
/* 320 */         this.connectionStackTraces.remove(c);
/*     */       }
/*     */     }
/*     */ 
/* 324 */     KeyConnectionAssociation key = peekMetaAwareObject();
/* 325 */     if (this.trace)
/* 326 */       this.log.trace("unregistering connection from " + cm + ", object: " + c + ", key: " + key);
/* 327 */     if (key == null) {
/* 328 */       return;
/*     */     }
/* 330 */     Map cmToConnectionsMap = key.getCMToConnectionsMap();
/* 331 */     Collection conns = (Collection)cmToConnectionsMap.get(cm);
/* 332 */     if (conns == null)
/* 333 */       return;
/* 334 */     for (Iterator i = conns.iterator(); i.hasNext(); )
/*     */     {
/* 336 */       if (((ConnectionRecord)i.next()).connection != c)
/*     */         continue;
/* 338 */       i.remove();
/* 339 */       return;
/*     */     }
/*     */ 
/* 342 */     throw new IllegalStateException("Trying to return an unknown connection2! " + c);
/*     */   }
/*     */ 
/*     */   public void userTransactionStarted()
/*     */     throws SystemException
/*     */   {
/* 349 */     KeyConnectionAssociation key = peekMetaAwareObject();
/* 350 */     if (this.trace)
/* 351 */       this.log.trace("user tx started, key: " + key);
/* 352 */     if (key == null) {
/* 353 */       return;
/*     */     }
/* 355 */     Map cmToConnectionsMap = key.getCMToConnectionsMap();
/* 356 */     for (Iterator i = cmToConnectionsMap.keySet().iterator(); i.hasNext(); )
/*     */     {
/* 358 */       ConnectionCacheListener cm = (ConnectionCacheListener)i.next();
/* 359 */       Collection conns = (Collection)cmToConnectionsMap.get(cm);
/* 360 */       cm.transactionStarted(conns);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void reconnect(KeyConnectionAssociation key, Set unsharableResources)
/*     */     throws ResourceException
/*     */   {
/* 376 */     Map cmToConnectionsMap = null;
/* 377 */     synchronized (this.objectToConnectionManagerMap)
/*     */     {
/* 379 */       cmToConnectionsMap = (Map)this.objectToConnectionManagerMap.get(key);
/* 380 */       if (cmToConnectionsMap == null)
/* 381 */         return;
/*     */     }
/* 383 */     key.setCMToConnectionsMap(cmToConnectionsMap);
/* 384 */     for (Iterator i = cmToConnectionsMap.keySet().iterator(); i.hasNext(); )
/*     */     {
/* 386 */       ConnectionCacheListener cm = (ConnectionCacheListener)i.next();
/* 387 */       Collection conns = (Collection)cmToConnectionsMap.get(cm);
/* 388 */       cm.reconnect(conns, unsharableResources);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void disconnect(KeyConnectionAssociation key, Set unsharableResources)
/*     */     throws ResourceException
/*     */   {
/* 395 */     Map cmToConnectionsMap = key.getCMToConnectionsMap();
/*     */     Iterator i;
/* 396 */     if (!cmToConnectionsMap.isEmpty())
/*     */     {
/* 398 */       synchronized (this.objectToConnectionManagerMap)
/*     */       {
/* 400 */         this.objectToConnectionManagerMap.put(key, cmToConnectionsMap);
/*     */       }
/* 402 */       for (i = cmToConnectionsMap.keySet().iterator(); i.hasNext(); )
/*     */       {
/* 404 */         ConnectionCacheListener cm = (ConnectionCacheListener)i.next();
/* 405 */         Collection conns = (Collection)cmToConnectionsMap.get(cm);
/* 406 */         cm.disconnect(conns, unsharableResources);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private boolean closeAll(Map cmToConnectionsMap)
/*     */   {
/* 413 */     if (!this.debug) {
/* 414 */       return false;
/*     */     }
/* 416 */     boolean unclosed = false;
/*     */ 
/* 418 */     Collection connections = cmToConnectionsMap.values();
/*     */     Iterator i;
/* 419 */     if (connections.size() != 0)
/*     */     {
/* 421 */       for (i = connections.iterator(); i.hasNext(); )
/*     */       {
/* 423 */         Collection conns = (Collection)i.next();
/* 424 */         for (j = conns.iterator(); j.hasNext(); )
/*     */         {
/* 426 */           Object c = ((ConnectionRecord)j.next()).connection;
/* 427 */           CloseConnectionSynchronization cas = getCloseConnectionSynchronization(true);
/* 428 */           if (cas == null)
/*     */           {
/* 430 */             unclosed = true;
/* 431 */             closeConnection(c);
/*     */           }
/*     */           else {
/* 434 */             cas.add(c);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     Iterator j;
/* 439 */     return unclosed;
/*     */   }
/*     */ 
/*     */   void unregisterConnectionCacheListener(ConnectionCacheListener cm)
/*     */   {
/* 453 */     if (this.trace)
/* 454 */       this.log.trace("unregisterConnectionCacheListener: " + cm);
/*     */     Iterator i;
/* 455 */     synchronized (this.objectToConnectionManagerMap)
/*     */     {
/* 457 */       for (i = this.objectToConnectionManagerMap.values().iterator(); i.hasNext(); )
/*     */       {
/* 459 */         Map cmToConnectionsMap = (Map)i.next();
/* 460 */         if (cmToConnectionsMap != null)
/* 461 */           cmToConnectionsMap.remove(cm);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void closeConnection(Object c)
/*     */   {
/*     */     try
/*     */     {
/*     */       Throwable e;
/* 518 */       synchronized (this.connectionStackTraces)
/*     */       {
/* 520 */         e = (Throwable)this.connectionStackTraces.remove(c);
/*     */       }
/* 522 */       Method m = c.getClass().getMethod("close", new Class[0]);
/*     */       try
/*     */       {
/* 525 */         if (e != null)
/* 526 */           this.log.info("Closing a connection for you.  Please close them yourself: " + c, e);
/*     */         else
/* 528 */           this.log.info("Closing a connection for you.  Please close them yourself: " + c);
/* 529 */         m.invoke(c, new Object[0]);
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 533 */         this.log.info("Throwable trying to close a connection for you, please close it yourself", t);
/*     */       }
/*     */     }
/*     */     catch (NoSuchMethodException nsme)
/*     */     {
/* 538 */       this.log.info("Could not find a close method on alleged connection objects.  Please close your own connections.");
/*     */     }
/*     */   }
/*     */ 
/*     */   private CloseConnectionSynchronization getCloseConnectionSynchronization(boolean createIfNotFound)
/*     */   {
/*     */     try
/*     */     {
/* 546 */       Transaction tx = this.tm.getTransaction();
/* 547 */       if (tx != null)
/*     */       {
/* 549 */         TransactionSynchronizer.lock(tx);
/*     */         try
/*     */         {
/* 552 */           CloseConnectionSynchronization cas = (CloseConnectionSynchronization)TransactionSynchronizer.getCCMSynchronization(tx);
/* 553 */           if ((cas == null) && (createIfNotFound) && (TxUtils.isActive(tx)))
/*     */           {
/* 555 */             cas = new CloseConnectionSynchronization();
/* 556 */             TransactionSynchronizer.registerCCMSynchronization(tx, cas);
/*     */           }
/* 558 */           CloseConnectionSynchronization localCloseConnectionSynchronization1 = cas;
/*     */           return localCloseConnectionSynchronization1; } finally { TransactionSynchronizer.unlock(tx);
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 568 */       this.log.debug("Unable to synchronize with transaction", t);
/*     */     }
/* 570 */     return null;
/*     */   }
/*     */ 
/*     */   private class CloseConnectionSynchronization implements Synchronization
/*     */   {
/* 575 */     HashSet connections = new HashSet();
/* 576 */     boolean closing = false;
/*     */ 
/*     */     public CloseConnectionSynchronization()
/*     */     {
/*     */     }
/*     */ 
/*     */     public synchronized void add(Object c)
/*     */     {
/* 584 */       if (this.closing)
/* 585 */         return;
/* 586 */       this.connections.add(c);
/*     */     }
/*     */ 
/*     */     public synchronized void remove(Object c)
/*     */     {
/* 591 */       if (this.closing)
/* 592 */         return;
/* 593 */       this.connections.remove(c);
/*     */     }
/*     */ 
/*     */     public void beforeCompletion()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void afterCompletion(int status)
/*     */     {
/* 602 */       synchronized (this)
/*     */       {
/* 604 */         this.closing = true;
/*     */       }
/* 606 */       for (Iterator i = this.connections.iterator(); i.hasNext(); )
/* 607 */         CachedConnectionManager.this.closeConnection(i.next());
/* 608 */       this.connections.clear();
/*     */     }
/*     */   }
/*     */ 
/*     */   private static final class KeyConnectionAssociation
/*     */   {
/*     */     private final Object o;
/*     */     private Map cmToConnectionsMap;
/*     */ 
/*     */     KeyConnectionAssociation(Object o)
/*     */     {
/* 480 */       this.o = o;
/*     */     }
/*     */ 
/*     */     public boolean equals(Object other)
/*     */     {
/* 485 */       return ((other instanceof KeyConnectionAssociation)) && (this.o == ((KeyConnectionAssociation)other).o);
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 490 */       return Strings.defaultToString(this.o);
/*     */     }
/*     */ 
/*     */     public int hashCode()
/*     */     {
/* 495 */       return System.identityHashCode(this.o);
/*     */     }
/*     */ 
/*     */     public void setCMToConnectionsMap(Map cmToConnectionsMap)
/*     */     {
/* 500 */       this.cmToConnectionsMap = cmToConnectionsMap;
/*     */     }
/*     */ 
/*     */     public Map getCMToConnectionsMap()
/*     */     {
/* 505 */       if (this.cmToConnectionsMap == null)
/*     */       {
/* 507 */         this.cmToConnectionsMap = new HashMap();
/*     */       }
/* 509 */       return this.cmToConnectionsMap;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.connectionmanager.CachedConnectionManager
 * JD-Core Version:    0.6.0
 */