/*     */ package org.jboss.resource.connectionmanager;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class IdleRemover
/*     */ {
/*  42 */   private final Logger log = Logger.getLogger(getClass());
/*     */ 
/*  44 */   private final Collection pools = new ArrayList();
/*     */ 
/*  46 */   private long interval = 9223372036854775807L;
/*     */ 
/*  48 */   private long next = 9223372036854775807L;
/*     */ 
/*  50 */   private static final IdleRemover remover = new IdleRemover();
/*     */ 
/*     */   public static void registerPool(IdleConnectionRemovalSupport mcp, long interval)
/*     */   {
/*  54 */     remover.internalRegisterPool(mcp, interval);
/*     */   }
/*     */ 
/*     */   public static void unregisterPool(IdleConnectionRemovalSupport mcp)
/*     */   {
/*  59 */     remover.internalUnregisterPool(mcp);
/*     */   }
/*     */ 
/*     */   public static void waitForBackgroundThread()
/*     */   {
/*  67 */     synchronized (remover.pools)
/*     */     {
/*  69 */       return;
/*     */     }
/*     */   }
/*     */ 
/*     */   private IdleRemover()
/*     */   {
/*  75 */     AccessController.doPrivileged(new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/*  79 */         Runnable runnable = new IdleRemover.IdleRemoverRunnable(IdleRemover.this, null);
/*  80 */         Thread removerThread = new Thread(runnable, "IdleRemover");
/*  81 */         removerThread.setDaemon(true);
/*  82 */         removerThread.start();
/*  83 */         return null;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   private void internalRegisterPool(IdleConnectionRemovalSupport mcp, long interval) {
/*  90 */     this.log.debug("internalRegisterPool: registering pool with interval " + interval + " old interval: " + this.interval);
/*  91 */     synchronized (this.pools)
/*     */     {
/*  93 */       this.pools.add(mcp);
/*  94 */       if ((interval > 1L) && (interval / 2L < this.interval))
/*     */       {
/*  96 */         this.interval = (interval / 2L);
/*  97 */         long maybeNext = System.currentTimeMillis() + this.interval;
/*  98 */         if ((this.next > maybeNext) && (maybeNext > 0L))
/*     */         {
/* 100 */           this.next = maybeNext;
/* 101 */           this.log.debug("internalRegisterPool: about to notify thread: old next: " + this.next + ", new next: " + maybeNext);
/* 102 */           this.pools.notify();
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void internalUnregisterPool(IdleConnectionRemovalSupport mcp)
/*     */   {
/* 110 */     synchronized (this.pools)
/*     */     {
/* 112 */       this.pools.remove(mcp);
/* 113 */       if (this.pools.size() == 0)
/*     */       {
/* 115 */         this.log.debug("internalUnregisterPool: setting interval to Long.MAX_VALUE");
/* 116 */         this.interval = 9223372036854775807L;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void setupContextClassLoader()
/*     */   {
/* 129 */     ClassLoader cl = IdleRemover.class.getClassLoader();
/* 130 */     if (cl == null) {
/* 131 */       return;
/*     */     }
/* 133 */     SecurityManager sm = System.getSecurityManager();
/* 134 */     if (sm == null) {
/* 135 */       Thread.currentThread().setContextClassLoader(cl);
/*     */     }
/* 137 */     AccessController.doPrivileged(new PrivilegedAction(cl)
/*     */     {
/*     */       public Object run()
/*     */       {
/* 141 */         Thread.currentThread().setContextClassLoader(this.val$cl);
/* 142 */         return null;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   private class IdleRemoverRunnable implements Runnable
/*     */   {
/*     */     private IdleRemoverRunnable() {
/*     */     }
/*     */ 
/*     */     public void run() {
/* 154 */       IdleRemover.this.setupContextClassLoader();
/*     */ 
/* 156 */       synchronized (IdleRemover.this.pools)
/*     */       {
/*     */         try
/*     */         {
/*     */           while (true)
/*     */           {
/* 162 */             IdleRemover.this.pools.wait(IdleRemover.this.interval);
/* 163 */             IdleRemover.this.log.debug("run: IdleRemover notifying pools, interval: " + IdleRemover.this.interval);
/* 164 */             for (Iterator i = IdleRemover.this.pools.iterator(); i.hasNext(); )
/* 165 */               ((InternalManagedConnectionPool)i.next()).removeIdleConnections();
/* 166 */             IdleRemover.access$502(IdleRemover.this, System.currentTimeMillis() + IdleRemover.this.interval);
/* 167 */             if (IdleRemover.this.next < 0L)
/* 168 */               IdleRemover.access$502(IdleRemover.this, 9223372036854775807L);
/*     */           }
/*     */         }
/*     */         catch (InterruptedException ie)
/*     */         {
/* 173 */           IdleRemover.this.log.info("run: IdleRemover has been interrupted, returning");
/* 174 */           return;
/*     */         }
/*     */         catch (RuntimeException e) {
/*     */           while (true)
/* 178 */             IdleRemover.this.log.warn("run: IdleRemover ignored unexpected runtime exception", e);
/*     */         }
/*     */         catch (Error e)
/*     */         {
/* 182 */           IdleRemover.this.log.warn("run: IdleRemover ignored unexpected error", e);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.connectionmanager.IdleRemover
 * JD-Core Version:    0.6.0
 */