/*     */ package org.jboss.resource.connectionmanager.xa;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Arrays;
/*     */ import javax.transaction.xa.Xid;
/*     */ 
/*     */ public class JcaXid
/*     */   implements Serializable, Xid
/*     */ {
/*     */   private static final long serialVersionUID = 8226195409384804425L;
/*     */   private int formatId;
/*     */   private byte[] globalTransactionId;
/*     */   private byte[] branchQualifier;
/*     */   private transient String cachedToString;
/*     */   private transient int cachedHashCode;
/*     */   private boolean pad;
/*     */ 
/*     */   public JcaXid(Xid xid)
/*     */   {
/*  61 */     this(false, xid);
/*     */   }
/*     */ 
/*     */   public JcaXid(boolean pad, Xid xid)
/*     */   {
/*  67 */     this.pad = pad;
/*     */ 
/*  69 */     this.branchQualifier = (pad ? new byte[64] : new byte[xid.getBranchQualifier().length]);
/*  70 */     System.arraycopy(xid.getBranchQualifier(), 0, this.branchQualifier, 0, xid.getBranchQualifier().length);
/*  71 */     this.globalTransactionId = xid.getGlobalTransactionId();
/*  72 */     this.formatId = xid.getFormatId();
/*     */   }
/*     */ 
/*     */   public byte[] getBranchQualifier()
/*     */   {
/*  78 */     return this.branchQualifier;
/*     */   }
/*     */ 
/*     */   public int getFormatId()
/*     */   {
/*  83 */     return this.formatId;
/*     */   }
/*     */ 
/*     */   public byte[] getGlobalTransactionId()
/*     */   {
/*  88 */     return this.globalTransactionId;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object object)
/*     */   {
/*  93 */     if ((object == null) || (!(object instanceof Xid))) {
/*  94 */       return false;
/*     */     }
/*  96 */     Xid other = (Xid)object;
/*  97 */     return (this.formatId == other.getFormatId()) && (Arrays.equals(this.globalTransactionId, other.getGlobalTransactionId())) && (Arrays.equals(this.branchQualifier, other.getBranchQualifier()));
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 107 */     if (this.cachedHashCode == 0)
/*     */     {
/* 109 */       this.cachedHashCode = this.formatId;
/* 110 */       for (int i = 0; i < this.globalTransactionId.length; i++)
/* 111 */         this.cachedHashCode += this.globalTransactionId[i];
/*     */     }
/* 113 */     return this.cachedHashCode;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 118 */     if (this.cachedToString == null)
/*     */     {
/* 120 */       StringBuffer buffer = new StringBuffer();
/* 121 */       buffer.append("JcaXid[FormatId=").append(getFormatId());
/* 122 */       buffer.append(" GlobalId=").append(new String(getGlobalTransactionId()).trim());
/* 123 */       byte[] branchQualifer = getBranchQualifier();
/* 124 */       buffer.append(" BranchQual=");
/* 125 */       if (branchQualifer == null)
/* 126 */         buffer.append("null");
/*     */       else
/* 128 */         buffer.append(new String(getBranchQualifier()).trim());
/* 129 */       buffer.append(']');
/* 130 */       this.cachedToString = buffer.toString();
/*     */     }
/* 132 */     return this.cachedToString;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.connectionmanager.xa.JcaXid
 * JD-Core Version:    0.6.0
 */