/*     */ package org.jboss.resource.deployers.builder;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.mx.util.ObjectNameFactory;
/*     */ import org.jboss.resource.metadata.ConnectorMetaData;
/*     */ import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
/*     */ import org.jboss.resource.metadata.repository.DefaultJCAMetaDataRepository;
/*     */ import org.jboss.system.metadata.ServiceAttributeMetaData;
/*     */ import org.jboss.system.metadata.ServiceConstructorMetaData;
/*     */ import org.jboss.system.metadata.ServiceDependencyMetaData;
/*     */ 
/*     */ public class ManagedConnectionFactoryBuilder extends AbstractBuilder
/*     */ {
/*     */   private static final String MCF = "org.jboss.resource.connectionmanager.ManagedConnectionFactoryDeployment";
/*     */   private static final String RAR_JMX = "jboss.jca:service=RARDeployment,name='";
/*     */   private static final String MCF_JMX = "jboss.jca:service=ManagedConnectionFactory,name=";
/*     */   private DefaultJCAMetaDataRepository repository;
/*     */ 
/*     */   public DefaultJCAMetaDataRepository getMetaDataRepository()
/*     */   {
/*  54 */     return this.repository;
/*     */   }
/*     */ 
/*     */   public void setMetaDataRepository(DefaultJCAMetaDataRepository repository) {
/*  58 */     this.repository = repository;
/*     */   }
/*     */ 
/*     */   public ObjectName buildObjectName(ManagedConnectionFactoryDeploymentMetaData md)
/*     */   {
/*  64 */     return ObjectNameFactory.create("jboss.jca:service=ManagedConnectionFactory,name=" + md.getJndiName());
/*     */   }
/*     */ 
/*     */   public List<ServiceAttributeMetaData> buildAttributes(ManagedConnectionFactoryDeploymentMetaData deployment)
/*     */   {
/*  70 */     List attributes = new ArrayList();
/*  71 */     ServiceAttributeMetaData attribute = buildDependencyAttribute("OldRarDeployment", "jboss.jca:service=RARDeployment,name='" + deployment.getRarName() + "'");
/*  72 */     attributes.add(attribute);
/*  73 */     return attributes;
/*     */   }
/*     */ 
/*     */   public ServiceConstructorMetaData buildConstructor(ManagedConnectionFactoryDeploymentMetaData mcfmd)
/*     */   {
/*  79 */     ServiceConstructorMetaData constructor = new ServiceConstructorMetaData();
/*     */ 
/*  81 */     ConnectorMetaData md = this.repository.getConnectorMetaData(mcfmd.getRarName());
/*  82 */     if (md == null)
/*  83 */       throw new IllegalStateException("No ConnectorMetaData found for mdf rarName: " + mcfmd.getRarName());
/*  84 */     constructor.setParameters(new Object[] { md, mcfmd });
/*  85 */     constructor.setSignature(new String[] { md.getClass().getName(), ManagedConnectionFactoryDeploymentMetaData.class.getName() });
/*  86 */     return constructor;
/*     */   }
/*     */ 
/*     */   public List<ServiceDependencyMetaData> buildDependencies(ManagedConnectionFactoryDeploymentMetaData md)
/*     */   {
/*  92 */     List dependsNames = md.getDependsNames();
/*  93 */     List dependencies = new ArrayList();
/*     */ 
/*  95 */     for (String string : dependsNames)
/*     */     {
/*  97 */       ServiceDependencyMetaData depends = buildDependency(string);
/*  98 */       dependencies.add(depends);
/*     */     }
/*     */ 
/* 101 */     return dependencies;
/*     */   }
/*     */ 
/*     */   public String getCode(ManagedConnectionFactoryDeploymentMetaData md)
/*     */   {
/* 108 */     return "org.jboss.resource.connectionmanager.ManagedConnectionFactoryDeployment";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.deployers.builder.ManagedConnectionFactoryBuilder
 * JD-Core Version:    0.6.0
 */