/*     */ package org.jboss.resource.deployers.builder;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.mx.util.ObjectNameFactory;
/*     */ import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
/*     */ import org.jboss.resource.metadata.mcf.SecurityDeploymentType;
/*     */ import org.jboss.resource.metadata.mcf.SecurityMetaData;
/*     */ import org.jboss.system.metadata.ServiceAttributeMetaData;
/*     */ 
/*     */ public class ManagedConnectionPoolBuilder extends AbstractBuilder
/*     */ {
/*     */   private static final String POOL = "org.jboss.resource.connectionmanager.JBossManagedConnectionPool";
/*  45 */   private static final Map<SecurityDeploymentType, String> securityTypeMap = new HashMap();
/*     */   private static final String MCF_JMX = "jboss.jca:service=ManagedConnectionFactory,name=";
/*     */ 
/*     */   public ObjectName buildObjectName(ManagedConnectionFactoryDeploymentMetaData md)
/*     */   {
/*  59 */     return ObjectNameFactory.create("jboss.jca:service=ManagedConnectionPool,name=" + md.getJndiName());
/*     */   }
/*     */ 
/*     */   public String getCode(ManagedConnectionFactoryDeploymentMetaData md)
/*     */   {
/*  65 */     return "org.jboss.resource.connectionmanager.JBossManagedConnectionPool";
/*     */   }
/*     */ 
/*     */   public List<ServiceAttributeMetaData> buildAttributes(ManagedConnectionFactoryDeploymentMetaData md)
/*     */   {
/*  71 */     List poolAttributes = new ArrayList();
/*  72 */     ServiceAttributeMetaData poolAttribute = null;
/*     */ 
/*  74 */     poolAttribute = buildSimpleAttribute("PoolJndiName", md.getJndiName());
/*  75 */     poolAttributes.add(poolAttribute);
/*     */ 
/*  77 */     poolAttribute = buildSimpleAttribute("MinSize", String.valueOf(md.getMinSize()));
/*  78 */     poolAttributes.add(poolAttribute);
/*     */ 
/*  80 */     poolAttribute = buildSimpleAttribute("MaxSize", String.valueOf(md.getMaxSize()));
/*  81 */     poolAttributes.add(poolAttribute);
/*     */ 
/*  83 */     poolAttribute = buildSimpleAttribute("BlockingTimeoutMillis", String.valueOf(md.getBlockingTimeoutMilliSeconds()));
/*  84 */     poolAttributes.add(poolAttribute);
/*     */ 
/*  86 */     poolAttribute = buildSimpleAttribute("IdleTimeoutMinutes", String.valueOf(md.getIdleTimeoutMinutes()));
/*  87 */     poolAttributes.add(poolAttribute);
/*     */ 
/*  89 */     poolAttribute = buildSimpleAttribute("BackGroundValidation", String.valueOf(md.isBackgroundValidation()));
/*  90 */     poolAttributes.add(poolAttribute);
/*     */ 
/*  92 */     poolAttribute = buildSimpleAttribute("BackGroundValidationMinutes", String.valueOf(md.getBackgroundValidationMinutes()));
/*  93 */     poolAttributes.add(poolAttribute);
/*     */ 
/*  95 */     poolAttribute = buildSimpleAttribute("PreFill", String.valueOf(md.getPrefill()));
/*  96 */     poolAttributes.add(poolAttribute);
/*     */ 
/*  98 */     poolAttribute = buildSimpleAttribute("StrictMin", String.valueOf(md.getUseStrictMin()));
/*  99 */     poolAttributes.add(poolAttribute);
/*     */ 
/* 101 */     poolAttribute = buildSimpleAttribute("StatisticsFormatter", md.getStatisticsFormatter());
/* 102 */     poolAttributes.add(poolAttribute);
/*     */ 
/* 105 */     if (md.getSecurityMetaData() == null)
/*     */     {
/* 107 */       poolAttribute = buildSimpleAttribute("Criteria", "ByNothing");
/*     */     }
/*     */     else
/*     */     {
/* 111 */       poolAttribute = buildSimpleAttribute("Criteria", String.valueOf(getCriteria(md.getSecurityMetaData().getSecurityDeploymentType())));
/*     */     }
/*     */ 
/* 114 */     poolAttributes.add(poolAttribute);
/*     */ 
/* 116 */     poolAttribute = buildDependencyAttribute("ManagedConnectionFactoryName", "jboss.jca:service=ManagedConnectionFactory,name=" + md.getJndiName());
/* 117 */     poolAttributes.add(poolAttribute);
/*     */ 
/* 119 */     return poolAttributes;
/*     */   }
/*     */ 
/*     */   private String getCriteria(SecurityDeploymentType type)
/*     */   {
/* 125 */     return (String)securityTypeMap.get(type);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  50 */     securityTypeMap.put(SecurityDeploymentType.NONE, "ByNothing");
/*  51 */     securityTypeMap.put(SecurityDeploymentType.APPLICATION, "ByApplication");
/*  52 */     securityTypeMap.put(SecurityDeploymentType.DOMAIN, "ByContainer");
/*  53 */     securityTypeMap.put(SecurityDeploymentType.DOMAIN_AND_APPLICATION, "ByContainerAndApplication");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.deployers.builder.ManagedConnectionPoolBuilder
 * JD-Core Version:    0.6.0
 */