/*     */ package org.jboss.resource.deployers.management;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Type;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.managed.api.Fields;
/*     */ import org.jboss.managed.plugins.DefaultFieldsImpl;
/*     */ import org.jboss.managed.plugins.ManagedObjectImpl;
/*     */ import org.jboss.managed.plugins.ManagedPropertyImpl;
/*     */ import org.jboss.metatype.api.types.MetaType;
/*     */ import org.jboss.metatype.api.types.MetaTypeFactory;
/*     */ import org.jboss.metatype.api.types.SimpleMetaType;
/*     */ import org.jboss.profileservice.management.plugins.BasicDeploymentTemplateInfo;
/*     */ import org.jboss.resource.metadata.mcf.DBMSMetaData;
/*     */ import org.jboss.resource.metadata.mcf.LocalDataSourceDeploymentMetaData;
/*     */ import org.jboss.resource.metadata.mcf.NoTxConnectionFactoryDeploymentMetaData;
/*     */ import org.jboss.resource.metadata.mcf.NoTxDataSourceDeploymentMetaData;
/*     */ import org.jboss.resource.metadata.mcf.TxConnectionFactoryDeploymentMetaData;
/*     */ import org.jboss.resource.metadata.mcf.XADataSourceDeploymentMetaData;
/*     */ 
/*     */ public class DsDataSourceTemplateInfo extends BasicDeploymentTemplateInfo
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*  52 */   private static final MetaTypeFactory METATYPE_FACTORY = MetaTypeFactory.getInstance();
/*     */   private Map<String, String> propertyNameMappings;
/*  54 */   private String dsType = "local-tx-datasource";
/*     */   private transient Type mapType;
/*     */   private transient Type mapOfMapsType;
/*     */ 
/*     */   public DsDataSourceTemplateInfo(String name, String description, String datasourceType)
/*     */   {
/*  60 */     super(name, description);
/*  61 */     this.dsType = datasourceType;
/*     */   }
/*     */ 
/*     */   public Map<String, String> getPropertyNameMappings()
/*     */   {
/*  66 */     return this.propertyNameMappings;
/*     */   }
/*     */ 
/*     */   public void setPropertyNameMappings(Map<String, String> propertyNameMappings) {
/*  70 */     this.propertyNameMappings = propertyNameMappings;
/*     */   }
/*     */ 
/*     */   public String getConnectionFactoryType()
/*     */   {
/*  76 */     return this.dsType;
/*     */   }
/*     */ 
/*     */   public void setConnectionFactoryType(String dsType)
/*     */   {
/*  81 */     this.dsType = dsType;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/* 112 */     if ("local-tx-datasource".equals(this.dsType))
/* 113 */       createLocalTxDsTemplate();
/* 114 */     else if ("xa-datasource".equals(this.dsType))
/* 115 */       createXaDsTemplate();
/* 116 */     else if ("tx-connection-factory".equals(this.dsType))
/* 117 */       createTxCfTemplate();
/* 118 */     else if ("no-tx-datasource".equals(this.dsType))
/* 119 */       createNoTxDsTemplate();
/* 120 */     else if ("no-tx-connection-factory".equals(this.dsType))
/* 121 */       createNoTxCfTemplate();
/*     */     else
/* 123 */       throw new IllegalStateException("Unsupported dsType: " + this.dsType);
/*     */   }
/*     */ 
/*     */   private void createXaDsTemplate()
/*     */   {
/* 128 */     ManagedObjectImpl mo = new ManagedObjectImpl(XADataSourceDeploymentMetaData.class.getName());
/* 129 */     addDsProperties(mo);
/* 130 */     addManagedProperty("xa-datasource-class", "The xa datasource class name", true, SimpleMetaType.STRING, mo);
/* 131 */     addManagedProperty("xa-datasource-properties", "The xa datasource properties", false, METATYPE_FACTORY.resolve(getMapType()), mo);
/* 132 */     addManagedProperty("url-property", "The URL property", true, SimpleMetaType.STRING, mo);
/* 133 */     addManagedProperty("xa-resource-timeout", "The XA resource timeout", true, SimpleMetaType.INTEGER, new Integer(0), mo);
/*     */   }
/*     */ 
/*     */   private void createLocalTxDsTemplate()
/*     */   {
/* 138 */     ManagedObjectImpl mo = new ManagedObjectImpl(LocalDataSourceDeploymentMetaData.class.getName());
/* 139 */     addNonXADsProperties(mo);
/*     */   }
/*     */ 
/*     */   private void createNoTxDsTemplate()
/*     */   {
/* 144 */     ManagedObjectImpl mo = new ManagedObjectImpl(NoTxDataSourceDeploymentMetaData.class.getName());
/* 145 */     addNonXADsProperties(mo);
/*     */   }
/*     */ 
/*     */   private void createTxCfTemplate()
/*     */   {
/* 150 */     ManagedObjectImpl mo = new ManagedObjectImpl(TxConnectionFactoryDeploymentMetaData.class.getName());
/* 151 */     addCommonProperties(mo);
/* 152 */     addManagedProperty("xa-resource-timeout", "The XA resource timeout", true, SimpleMetaType.INTEGER, new Integer(0), mo);
/* 153 */     addManagedProperty("xa-transaction", "", true, SimpleMetaType.BOOLEAN, mo);
/*     */   }
/*     */ 
/*     */   private void createNoTxCfTemplate()
/*     */   {
/* 158 */     ManagedObjectImpl mo = new ManagedObjectImpl(NoTxConnectionFactoryDeploymentMetaData.class.getName());
/* 159 */     addCommonProperties(mo);
/*     */   }
/*     */ 
/*     */   private void addNonXADsProperties(ManagedObjectImpl mo)
/*     */   {
/* 164 */     addDsProperties(mo);
/* 165 */     addManagedProperty("driver-class", "The jdbc driver class name", true, SimpleMetaType.STRING, mo);
/* 166 */     addManagedProperty("connection-url", "The jdbc url of the DataSource", true, SimpleMetaType.STRING, mo);
/* 167 */     addManagedProperty("connection-properties", "The jdbc driver connection properties", false, METATYPE_FACTORY.resolve(List.class), mo);
/*     */   }
/*     */ 
/*     */   private void addDsProperties(ManagedObjectImpl mo)
/*     */   {
/* 172 */     addCommonProperties(mo);
/* 173 */     addManagedProperty("transaction-isolation", "The transaction isolation level", false, SimpleMetaType.STRING, mo);
/* 174 */     addManagedProperty("user-name", "The username for the connection-url", false, SimpleMetaType.STRING, mo);
/* 175 */     addManagedProperty("password", "The password for the connection-url", false, SimpleMetaType.STRING, mo);
/* 176 */     addManagedProperty("new-connection-sql", "", false, SimpleMetaType.STRING, mo);
/* 177 */     addManagedProperty("check-valid-connection-sql", "", false, SimpleMetaType.STRING, mo);
/* 178 */     addManagedProperty("valid-connection-checker-class-name", "", false, SimpleMetaType.STRING, mo);
/* 179 */     addManagedProperty("exception-sorter-class-name", "", false, SimpleMetaType.STRING, mo);
/* 180 */     addManagedProperty("stale-connection-checker-class-name", "", false, SimpleMetaType.STRING, mo);
/* 181 */     addManagedProperty("track-statements", "", false, SimpleMetaType.STRING, mo);
/* 182 */     addManagedProperty("prepared-statement-cache-size", "", false, SimpleMetaType.INTEGER, new Integer(0), mo);
/* 183 */     addManagedProperty("share-prepared-statements", "", false, SimpleMetaType.BOOLEAN, Boolean.FALSE, mo);
/* 184 */     addManagedProperty("set-tx-query-timeout", "", false, SimpleMetaType.BOOLEAN, Boolean.FALSE, mo);
/* 185 */     addManagedProperty("query-timeout", "", false, SimpleMetaType.INTEGER, new Integer(0), mo);
/* 186 */     addManagedProperty("url-delimiter", "", false, SimpleMetaType.STRING, mo);
/* 187 */     addManagedProperty("url-selector-strategy-class-name", "", false, SimpleMetaType.STRING, mo);
/*     */   }
/*     */ 
/*     */   private void addCommonProperties(ManagedObjectImpl mo)
/*     */   {
/* 193 */     addManagedProperty("jndi-name", "The jndi name to bind the DataSource under", true, SimpleMetaType.STRING, mo);
/* 194 */     addManagedProperty("rar-name", "The resource adapter archive name", true, SimpleMetaType.STRING, mo);
/* 195 */     addManagedProperty("use-java-context", "Whether to bind the connection factory under 'java:' context", true, SimpleMetaType.BOOLEAN, Boolean.TRUE, mo);
/* 196 */     addManagedProperty("connection-definition", "The connection factory class name", true, SimpleMetaType.STRING, mo);
/* 197 */     addManagedProperty("jmx-invoker-name", "The name of the JMX invoker", true, SimpleMetaType.STRING, mo);
/* 198 */     addManagedProperty("min-pool-size", "The min size of the pool", true, SimpleMetaType.INTEGER, new Integer(0), mo);
/* 199 */     addManagedProperty("max-pool-size", "The max size of the pool", true, SimpleMetaType.INTEGER, new Integer(10), mo);
/* 200 */     addManagedProperty("blocking-timeout-millis", "The time to wait for a connection to become available before giving up", true, SimpleMetaType.LONG, new Long(30000L), mo);
/* 201 */     addManagedProperty("idle-timeout-minutes", "The idle timeout in minutes", true, SimpleMetaType.INTEGER, new Integer(30), mo);
/* 202 */     addManagedProperty("prefill", "Whether to prefill the pool", true, SimpleMetaType.BOOLEAN, mo);
/* 203 */     addManagedProperty("background-validation", "Whether to use backgroup validation", true, SimpleMetaType.BOOLEAN, Boolean.FALSE, mo);
/* 204 */     addManagedProperty("background-validation-minutes", "", false, SimpleMetaType.INTEGER, new Integer(0), mo);
/* 205 */     addManagedProperty("validate-on-match", "", true, SimpleMetaType.BOOLEAN, Boolean.TRUE, mo);
/* 206 */     addManagedProperty("use-strict-min", "", true, SimpleMetaType.BOOLEAN, mo);
/* 207 */     addManagedProperty("noTxSeparatePools", "", true, SimpleMetaType.BOOLEAN, mo);
/* 208 */     addManagedProperty("statistics-formatter", "", true, SimpleMetaType.STRING, mo);
/* 209 */     addManagedProperty("isSameRM-override-value", "", true, SimpleMetaType.BOOLEAN, mo);
/* 210 */     addManagedProperty("track-connection-by-tx", "", true, SimpleMetaType.BOOLEAN, mo);
/* 211 */     addManagedProperty("config-property", "The connection factory config properties", false, METATYPE_FACTORY.resolve(getMapOfMapsType()), mo);
/* 212 */     addManagedProperty("security-domain", "The security-domain used to validate connections", false, SimpleMetaType.STRING, mo);
/* 213 */     addManagedProperty("depends", "", false, METATYPE_FACTORY.resolve(List.class), mo);
/* 214 */     addManagedProperty("metadata", "", false, METATYPE_FACTORY.resolve(DBMSMetaData.class), mo);
/* 215 */     addManagedProperty("type-mapping", "", true, SimpleMetaType.STRING, mo);
/* 216 */     addManagedProperty("local-transaction", "", true, SimpleMetaType.BOOLEAN, mo);
/*     */   }
/*     */ 
/*     */   private void addManagedProperty(String fieldName, String fieldDescr, boolean mandatory, MetaType metaType, ManagedObjectImpl mo)
/*     */   {
/* 225 */     addManagedProperty(fieldName, fieldDescr, mandatory, metaType, null, mo);
/*     */   }
/*     */ 
/*     */   private void addManagedProperty(String fieldName, String fieldDescr, boolean mandatory, MetaType metaType, Serializable value, ManagedObjectImpl mo)
/*     */   {
/* 235 */     DefaultFieldsImpl fields = new DefaultFieldsImpl();
/* 236 */     setFieldName(fieldName, fields);
/* 237 */     fields.setDescription(fieldDescr);
/* 238 */     fields.setMandatory(mandatory);
/* 239 */     fields.setMetaType(metaType);
/* 240 */     ManagedPropertyImpl mp = new ManagedPropertyImpl(mo, fields);
/* 241 */     super.addProperty(mp);
/* 242 */     if (value != null)
/* 243 */       mp.setValue(value);
/*     */   }
/*     */ 
/*     */   protected void setFieldName(String name, Fields f)
/*     */   {
/* 248 */     f.setField("name", name);
/* 249 */     if (this.propertyNameMappings != null)
/*     */     {
/* 251 */       String mappedName = (String)this.propertyNameMappings.get(name);
/* 252 */       if (mappedName != null)
/* 253 */         f.setField("mappedName", mappedName);
/*     */     }
/*     */   }
/*     */ 
/*     */   private Type getMapOfMapsType()
/*     */   {
/* 259 */     if (this.mapOfMapsType == null)
/*     */     {
/*     */       try
/*     */       {
/* 263 */         this.mapOfMapsType = getClass().getMethod("mapOfMaps", new Class[0]).getGenericReturnType();
/*     */       }
/*     */       catch (NoSuchMethodException e)
/*     */       {
/* 267 */         throw new IllegalStateException("Failed to find compoditeValueMap method.");
/*     */       }
/*     */     }
/* 270 */     return this.mapOfMapsType;
/*     */   }
/*     */ 
/*     */   private Type getMapType()
/*     */   {
/* 275 */     if (this.mapType == null)
/*     */     {
/*     */       try
/*     */       {
/* 279 */         this.mapType = getClass().getMethod("compositeValueMap", new Class[0]).getGenericReturnType();
/*     */       }
/*     */       catch (NoSuchMethodException e)
/*     */       {
/* 283 */         throw new IllegalStateException("Failed to find compoditeValueMap method.");
/*     */       }
/*     */     }
/* 286 */     return this.mapType;
/*     */   }
/*     */ 
/*     */   public Map<String, String> compositeValueMap()
/*     */   {
/* 291 */     return null;
/*     */   }
/*     */ 
/*     */   public Map<String, Map<String, String>> mapOfMaps()
/*     */   {
/* 296 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.deployers.management.DsDataSourceTemplateInfo
 * JD-Core Version:    0.6.0
 */