/*     */ package org.jboss.resource.deployers.management;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Type;
/*     */ import java.lang.reflect.UndeclaredThrowableException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.info.spi.PropertyInfo;
/*     */ import org.jboss.managed.api.ManagedProperty;
/*     */ import org.jboss.managed.plugins.factory.AbstractManagedObjectFactory;
/*     */ import org.jboss.metatype.api.values.MetaValue;
/*     */ import org.jboss.metatype.api.values.MetaValueFactory;
/*     */ import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
/*     */ import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryPropertyMetaData;
/*     */ import org.jboss.resource.metadata.mcf.XAConnectionPropertyMetaData;
/*     */ import org.jboss.resource.metadata.mcf.XADataSourceDeploymentMetaData;
/*     */ 
/*     */ public class XADataSourceDeploymentMetaDataBuilder extends AbstractManagedObjectFactory
/*     */ {
/*     */   private final Type mapType;
/*     */   private final Type mapOfMapsType;
/*     */   private MetaValueFactory metaValueFactory;
/*     */ 
/*     */   public XADataSourceDeploymentMetaDataBuilder()
/*     */   {
/*  55 */     this.metaValueFactory = MetaValueFactory.getInstance();
/*     */     try
/*     */     {
/*  59 */       this.mapType = getClass().getMethod("compositeValueMap", new Class[0]).getGenericReturnType();
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/*  63 */       throw new IllegalStateException("Failed to find compoditeValueMap method.");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/*  68 */       this.mapOfMapsType = getClass().getMethod("mapOfMaps", new Class[0]).getGenericReturnType();
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/*  72 */       throw new IllegalStateException("Failed to find mapOfMaps method.");
/*     */     }
/*     */   }
/*     */ 
/*     */   public MetaValue getValue(BeanInfo beanInfo, ManagedProperty property, Serializable object)
/*     */   {
/*  78 */     if ("xa-datasource-properties".equals(property.getName()))
/*     */     {
/*  80 */       MetaValue metaValue = null;
/*  81 */       XADataSourceDeploymentMetaData ds = (XADataSourceDeploymentMetaData)object;
/*  82 */       List list = ds.getXADataSourceProperties();
/*  83 */       if (list != null)
/*     */       {
/*  85 */         Map map = new HashMap();
/*  86 */         for (XAConnectionPropertyMetaData prop : list)
/*     */         {
/*  88 */           map.put(prop.getName(), prop.getValue());
/*     */         }
/*  90 */         metaValue = this.metaValueFactory.create(map, this.mapType);
/*     */       }
/*  92 */       return metaValue;
/*     */     }
/*     */ 
/*  95 */     if ("config-property".equals(property.getName()))
/*     */     {
/*  97 */       MetaValue metaValue = null;
/*  98 */       ManagedConnectionFactoryDeploymentMetaData mcf = (ManagedConnectionFactoryDeploymentMetaData)object;
/*  99 */       List list = mcf.getManagedConnectionFactoryProperties();
/* 100 */       if (list != null)
/*     */       {
/* 102 */         Map map = new HashMap();
/* 103 */         for (ManagedConnectionFactoryPropertyMetaData prop : list)
/*     */         {
/* 105 */           Map value = new HashMap();
/* 106 */           value.put("name", prop.getName());
/* 107 */           value.put("type", prop.getType());
/* 108 */           value.put("value", prop.getValue());
/* 109 */           map.put(value.get("name"), value);
/*     */         }
/* 111 */         metaValue = this.metaValueFactory.create(map, this.mapOfMapsType);
/*     */       }
/* 113 */       return metaValue;
/*     */     }
/*     */ 
/* 116 */     return super.getValue(beanInfo, property, object);
/*     */   }
/*     */ 
/*     */   public void setValue(BeanInfo beanInfo, ManagedProperty property, Serializable object, MetaValue value)
/*     */   {
/* 121 */     if ("xa-datasource-properties".equals(property.getName()))
/*     */     {
/* 123 */       String propName = getPropertyName(property);
/* 124 */       PropertyInfo propertyInfo = beanInfo.getProperty(propName);
/* 125 */       Map map = (Map)this.metaValueFactory.unwrap(value, this.mapType);
/*     */ 
/* 127 */       List list = null;
/* 128 */       if (map != null)
/*     */       {
/* 130 */         list = new ArrayList();
/* 131 */         for (String name : map.keySet())
/*     */         {
/* 133 */           XAConnectionPropertyMetaData xaProp = new XAConnectionPropertyMetaData();
/* 134 */           xaProp.setName(name);
/* 135 */           xaProp.setValue((String)map.get(name));
/* 136 */           list.add(xaProp);
/*     */         }
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 142 */         propertyInfo.set(object, list);
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 146 */         throw new UndeclaredThrowableException(t);
/*     */       }
/*     */     }
/* 149 */     else if ("config-property".equals(property.getName()))
/*     */     {
/* 151 */       String propName = getPropertyName(property);
/* 152 */       PropertyInfo propertyInfo = beanInfo.getProperty(propName);
/* 153 */       Map map = (Map)this.metaValueFactory.unwrap(value, this.mapOfMapsType);
/*     */ 
/* 155 */       List list = null;
/* 156 */       if (map != null)
/*     */       {
/* 158 */         list = new ArrayList();
/* 159 */         for (Map entry : map.values())
/*     */         {
/* 161 */           ManagedConnectionFactoryPropertyMetaData prop = new ManagedConnectionFactoryPropertyMetaData();
/* 162 */           prop.setName((String)entry.get("name"));
/* 163 */           prop.setValue((String)entry.get("value"));
/* 164 */           prop.setType((String)entry.get("type"));
/* 165 */           list.add(prop);
/*     */         }
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 171 */         propertyInfo.set(object, list);
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 175 */         throw new UndeclaredThrowableException(t);
/*     */       }
/*     */     }
/*     */     else {
/* 179 */       super.setValue(beanInfo, property, object, value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Map<String, String> compositeValueMap() {
/* 184 */     return null;
/*     */   }
/*     */ 
/*     */   public Map<String, Map<String, String>> mapOfMaps()
/*     */   {
/* 189 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.deployers.management.XADataSourceDeploymentMetaDataBuilder
 * JD-Core Version:    0.6.0
 */