/*    */ package org.jboss.resource.deployment;
/*    */ 
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.resource.metadata.ConfigPropertyMetaData;
/*    */ import org.jboss.resource.metadata.JBossRAMetaData;
/*    */ import org.jboss.xb.binding.ObjectModelFactory;
/*    */ import org.jboss.xb.binding.UnmarshallingContext;
/*    */ import org.xml.sax.Attributes;
/*    */ 
/*    */ public class JBossRAObjectModelFactory
/*    */   implements ObjectModelFactory
/*    */ {
/*    */   private boolean trace;
/* 42 */   private Logger log = Logger.getLogger(JBossRAObjectModelFactory.class);
/*    */ 
/*    */   public Object completeRoot(Object root, UnmarshallingContext arg1, String arg2, String arg3)
/*    */   {
/* 46 */     return root;
/*    */   }
/*    */ 
/*    */   public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes atts)
/*    */   {
/* 52 */     if ((localName == null) || (!localName.equals("jboss-ra")))
/*    */     {
/* 54 */       throw new IllegalArgumentException("Error invalid root element for jboss-ra.xml" + localName);
/*    */     }
/*    */ 
/* 58 */     JBossRAMetaData ramd = new JBossRAMetaData();
/* 59 */     return ramd;
/*    */   }
/*    */ 
/*    */   public Object newChild(JBossRAMetaData ramd, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*    */   {
/* 65 */     if (localName.equals("ra-config-property"))
/*    */     {
/* 67 */       ConfigPropertyMetaData cpmd = new ConfigPropertyMetaData();
/* 68 */       ramd.addProperty(cpmd);
/* 69 */       return cpmd;
/*    */     }
/*    */ 
/* 74 */     return null;
/*    */   }
/*    */ 
/*    */   public void setValue(ConfigPropertyMetaData cpmd, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*    */   {
/* 82 */     if (this.trace) {
/* 83 */       this.log.trace("config property setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/*    */     }
/* 85 */     else if (localName.equals("ra-config-property-name"))
/* 86 */       cpmd.setName(value);
/* 87 */     else if (localName.equals("ra-config-property-type"))
/* 88 */       cpmd.setType(value);
/* 89 */     else if (localName.equals("ra-config-property-value"))
/* 90 */       cpmd.setValue(value);
/*    */     else
/* 92 */       throw new IllegalArgumentException("Unknown config property setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.deployment.JBossRAObjectModelFactory
 * JD-Core Version:    0.6.0
 */