/*     */ package org.jboss.resource.metadata;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
/*     */ import java.net.URL;
/*     */ import java.util.Collection;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Locale;
/*     */ 
/*     */ public class ConnectorMetaData extends ConfigPropertyMetaDataContainer
/*     */ {
/*     */   private static final long serialVersionUID = -3049391010669865389L;
/*     */   private URL url;
/*  46 */   private String version = "1.0";
/*     */   private String vendorName;
/*     */   private String eisType;
/*     */   private String raVersion;
/*     */   private String raClass;
/*     */   private boolean reauthenticationSupport;
/*  64 */   private LicenseMetaData lmd = new LicenseMetaData();
/*     */ 
/*  67 */   private ConcurrentReaderHashMap descriptions = new ConcurrentReaderHashMap();
/*     */ 
/*  70 */   private HashSet connectionDefinitions = new HashSet();
/*     */ 
/*  73 */   private TransactionSupportMetaData tsmd = new TransactionSupportMetaData();
/*     */ 
/*  76 */   private AuthenticationMechanismMetaData ammd = new AuthenticationMechanismMetaData();
/*     */ 
/*  79 */   private HashSet listeners = new HashSet();
/*     */ 
/*  82 */   private HashSet adminObjects = new HashSet();
/*     */ 
/*  85 */   private HashSet securityPermissions = new HashSet();
/*     */ 
/*     */   public ConnectorMetaData()
/*     */   {
/*  89 */     DescriptionGroupMetaData dmd = new DescriptionGroupMetaData();
/*  90 */     this.descriptions.put(dmd.getLanguage(), dmd);
/*     */   }
/*     */ 
/*     */   public URL getURL()
/*     */   {
/* 100 */     return this.url;
/*     */   }
/*     */ 
/*     */   public void setURL(URL url)
/*     */   {
/* 110 */     this.url = url;
/*     */   }
/*     */ 
/*     */   public String getVersion()
/*     */   {
/* 120 */     return this.version;
/*     */   }
/*     */ 
/*     */   public void setVersion(String version)
/*     */   {
/* 130 */     this.version = version;
/*     */   }
/*     */ 
/*     */   public String getVendorName()
/*     */   {
/* 140 */     return this.vendorName;
/*     */   }
/*     */ 
/*     */   public void setVendorName(String vendorName)
/*     */   {
/* 150 */     this.vendorName = vendorName;
/*     */   }
/*     */ 
/*     */   public String getEISType()
/*     */   {
/* 160 */     return this.eisType;
/*     */   }
/*     */ 
/*     */   public void setEISType(String eisType)
/*     */   {
/* 170 */     this.eisType = eisType;
/*     */   }
/*     */ 
/*     */   public String getRAVersion()
/*     */   {
/* 180 */     return this.raVersion;
/*     */   }
/*     */ 
/*     */   public void setRAVersion(String version)
/*     */   {
/* 190 */     this.raVersion = version;
/*     */   }
/*     */ 
/*     */   public String getRAClass()
/*     */   {
/* 200 */     return this.raClass;
/*     */   }
/*     */ 
/*     */   public void setRAClass(String raClass)
/*     */   {
/* 210 */     this.raClass = raClass;
/*     */   }
/*     */ 
/*     */   public boolean getReauthenticationSupport()
/*     */   {
/* 220 */     return this.reauthenticationSupport;
/*     */   }
/*     */ 
/*     */   public void setReauthenticationSupport(boolean reauthenticationSupport)
/*     */   {
/* 230 */     this.reauthenticationSupport = reauthenticationSupport;
/*     */   }
/*     */ 
/*     */   public LicenseMetaData getLicense()
/*     */   {
/* 240 */     return this.lmd;
/*     */   }
/*     */ 
/*     */   public DescriptionGroupMetaData getDescription()
/*     */   {
/* 250 */     DescriptionGroupMetaData dgmd = (DescriptionGroupMetaData)this.descriptions.get(Locale.getDefault().getLanguage());
/*     */ 
/* 252 */     if (dgmd == null)
/*     */     {
/* 254 */       Iterator i = this.descriptions.values().iterator(); if (i.hasNext())
/*     */       {
/* 256 */         dgmd = (DescriptionGroupMetaData)i.next();
/*     */       }
/*     */     }
/*     */ 
/* 260 */     return dgmd;
/*     */   }
/*     */ 
/*     */   public DescriptionGroupMetaData getDescription(String lang)
/*     */   {
/* 271 */     return (DescriptionGroupMetaData)this.descriptions.get(lang);
/*     */   }
/*     */ 
/*     */   public void addDescription(DescriptionGroupMetaData dmd)
/*     */   {
/* 281 */     this.descriptions.put(dmd.getLanguage(), dmd);
/*     */   }
/*     */ 
/*     */   public TransactionSupportMetaData getTransactionSupport()
/*     */   {
/* 291 */     return this.tsmd;
/*     */   }
/*     */ 
/*     */   public void setTransactionSupport(TransactionSupportMetaData tsmd)
/*     */   {
/* 301 */     this.tsmd = tsmd;
/*     */   }
/*     */ 
/*     */   public AuthenticationMechanismMetaData getAuthenticationMechanism()
/*     */   {
/* 310 */     return this.ammd;
/*     */   }
/*     */ 
/*     */   public void setAuthenticationMechansim(AuthenticationMechanismMetaData ammd)
/*     */   {
/* 320 */     this.ammd = ammd;
/*     */   }
/*     */ 
/*     */   public void addConnectionDefinition(ConnectionDefinitionMetaData cdmd)
/*     */   {
/* 330 */     this.connectionDefinitions.add(cdmd);
/*     */   }
/*     */ 
/*     */   public ConnectionDefinitionMetaData getConnectionDefinition(String connectionDefinition)
/*     */   {
/* 341 */     for (Iterator i = this.connectionDefinitions.iterator(); i.hasNext(); )
/*     */     {
/* 343 */       ConnectionDefinitionMetaData cdmd = (ConnectionDefinitionMetaData)i.next();
/* 344 */       if (cdmd.getConnectionFactoryInterfaceClass().equals(connectionDefinition))
/* 345 */         return cdmd;
/*     */     }
/* 347 */     return null;
/*     */   }
/*     */ 
/*     */   public void addMessageListener(MessageListenerMetaData mlmd)
/*     */   {
/* 357 */     this.listeners.add(mlmd);
/*     */   }
/*     */ 
/*     */   public MessageListenerMetaData getMessageListener(String messagingType)
/*     */   {
/* 368 */     for (Iterator i = this.listeners.iterator(); i.hasNext(); )
/*     */     {
/* 370 */       MessageListenerMetaData mlmd = (MessageListenerMetaData)i.next();
/* 371 */       if (mlmd.getType().equals(messagingType))
/* 372 */         return mlmd;
/*     */     }
/* 374 */     return null;
/*     */   }
/*     */ 
/*     */   public void addAdminObject(AdminObjectMetaData aomd)
/*     */   {
/* 384 */     this.adminObjects.add(aomd);
/*     */   }
/*     */ 
/*     */   public AdminObjectMetaData getAdminObject(String interfaceName)
/*     */   {
/* 395 */     for (Iterator i = this.adminObjects.iterator(); i.hasNext(); )
/*     */     {
/* 397 */       AdminObjectMetaData aomd = (AdminObjectMetaData)i.next();
/* 398 */       if (aomd.getAdminObjectInterfaceClass().equals(interfaceName))
/* 399 */         return aomd;
/*     */     }
/* 401 */     return null;
/*     */   }
/*     */ 
/*     */   public Collection getAdminObjects()
/*     */   {
/* 406 */     return this.adminObjects;
/*     */   }
/*     */ 
/*     */   public void addSecurityPermission(SecurityPermissionMetaData spmd)
/*     */   {
/* 416 */     this.securityPermissions.add(spmd);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 421 */     StringBuffer buffer = new StringBuffer();
/* 422 */     buffer.append("ConnectorMetaData").append('@');
/* 423 */     buffer.append(Integer.toHexString(System.identityHashCode(this)));
/* 424 */     buffer.append("[version=").append(this.version);
/* 425 */     buffer.append(" vendorName=").append(this.vendorName);
/* 426 */     buffer.append(" eisType=").append(this.eisType);
/* 427 */     buffer.append(" resourceAdapterVersion=").append(this.raVersion);
/* 428 */     buffer.append(" resourceAdapterClass=").append(this.raClass);
/* 429 */     buffer.append(" license=").append(this.lmd);
/* 430 */     buffer.append(" properties=").append(getProperties());
/* 431 */     buffer.append(" descriptions=").append(this.descriptions.values());
/* 432 */     buffer.append(" connectionDefinitions=").append(this.connectionDefinitions);
/* 433 */     buffer.append(" transactionSupport=").append(this.tsmd);
/* 434 */     buffer.append(" authenticationMechanism=").append(this.ammd);
/* 435 */     buffer.append(" reauthenticationSupport=").append(this.reauthenticationSupport);
/* 436 */     buffer.append(" messageListeners=").append(this.listeners);
/* 437 */     buffer.append(" adminobjects=").append(this.adminObjects);
/* 438 */     buffer.append(" securityPermissions=").append(this.securityPermissions);
/* 439 */     buffer.append(']');
/* 440 */     return buffer.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.metadata.ConnectorMetaData
 * JD-Core Version:    0.6.0
 */