/*     */ package org.jboss.resource.metadata.mcf;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import org.jboss.managed.api.annotation.ManagementProperty;
/*     */ import org.jboss.resource.deployers.management.ConnectionFactoryProperty;
/*     */ 
/*     */ public class DataSourceDeploymentMetaData extends ManagedConnectionFactoryDeploymentMetaData
/*     */   implements JDBCProviderSupport
/*     */ {
/*     */   private static final long serialVersionUID = 1440129014410015366L;
/*     */   private static final String CONNECTION_DEFINITION = "javax.sql.DataSource";
/*     */   private static final String RAR_NAME = "jboss-local-jdbc.rar";
/*     */ 
/*     */   @XmlElement(name="transaction-isolation")
/*     */   private String transactionIsolation;
/*     */ 
/*     */   @XmlElement(name="user-name")
/*     */   private String userName;
/*     */ 
/*     */   @XmlElement(name="password")
/*     */   private String passWord;
/*     */ 
/*     */   @XmlElement(name="new-connection-sql")
/*     */   private String newConnectionSQL;
/*     */ 
/*     */   @XmlElement(name="check-valid-connection-sql")
/*     */   private String checkValidConnectionSQL;
/*     */ 
/*     */   @XmlElement(name="valid-connection-checker-class-name")
/*     */   private String validConnectionCheckerClassName;
/*     */ 
/*     */   @XmlElement(name="exception-sorter-class-name")
/*     */   private String exceptionSorterClassName;
/*     */ 
/*     */   @XmlElement(name="stale-connection-checker-class-name")
/*     */   private String staleConnectionCheckerClassName;
/*     */ 
/*     */   @XmlElement(name="track-statements")
/*     */   private String trackStatements;
/*     */ 
/*     */   @XmlElement(name="prepared-statement-cache-size")
/*  74 */   private int preparedStatementCacheSize = 0;
/*     */ 
/*     */   @XmlElement(name="share-prepared-statements")
/*     */   private boolean sharePreparedStatements;
/*     */ 
/*     */   @XmlElement(name="set-tx-query-timeout")
/*     */   private boolean useQueryTimeout;
/*     */ 
/*     */   @XmlElement(name="query-timeout")
/*     */   private int queryTimeout;
/*     */ 
/*     */   @XmlElement(name="url-delimiter")
/*     */   private String urlDelimiter;
/*     */ 
/*     */   @XmlElement(name="url-selector-strategy-class-name")
/*     */   private String urlSelectorStrategyClassName;
/*     */ 
/*  94 */   public DataSourceDeploymentMetaData() { setConnectionDefinition("javax.sql.DataSource");
/*  95 */     setRarName("jboss-local-jdbc.rar");
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="transaction-isolation", description="The DataSource transaction isolation level")
/*     */   public String getTransactionIsolation()
/*     */   {
/* 103 */     return this.transactionIsolation;
/*     */   }
/*     */ 
/*     */   public void setTransactionIsolation(String transactionIsolation)
/*     */   {
/* 108 */     this.transactionIsolation = transactionIsolation;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="password", description="The DataSource password")
/*     */   public String getPassWord() {
/* 114 */     return this.passWord;
/*     */   }
/*     */ 
/*     */   public void setPassWord(String passWord)
/*     */   {
/* 119 */     this.passWord = passWord;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="user-name", description="The DataSource username")
/*     */   public String getUserName() {
/* 125 */     return this.userName;
/*     */   }
/*     */ 
/*     */   public void setUserName(String userName)
/*     */   {
/* 130 */     this.userName = userName;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="check-valid-connection-sql", description="The SQL statement to validate a connection")
/*     */   public String getCheckValidConnectionSQL()
/*     */   {
/* 138 */     return this.checkValidConnectionSQL;
/*     */   }
/*     */ 
/*     */   public void setCheckValidConnectionSQL(String checkValidConnectionSQL)
/*     */   {
/* 143 */     this.checkValidConnectionSQL = checkValidConnectionSQL;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="exception-sorter-class-name", description="The exception sorter class name")
/*     */   public String getExceptionSorterClassName()
/*     */   {
/* 150 */     return this.exceptionSorterClassName;
/*     */   }
/*     */ 
/*     */   public void setExceptionSorterClassName(String exceptionSorterClassName)
/*     */   {
/* 155 */     this.exceptionSorterClassName = exceptionSorterClassName;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="new-connection-sql", description="The new connection SQL")
/*     */   public String getNewConnectionSQL() {
/* 161 */     return this.newConnectionSQL;
/*     */   }
/*     */ 
/*     */   public void setNewConnectionSQL(String newConnectionSQL)
/*     */   {
/* 166 */     this.newConnectionSQL = newConnectionSQL;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="valid-connection-checker-class-name", description="The DataSource connection checker class name")
/*     */   public String getValidConnectionCheckerClassName() {
/* 172 */     return this.validConnectionCheckerClassName;
/*     */   }
/*     */ 
/*     */   public void setValidConnectionCheckerClassName(String validConnectionCheckerClassName)
/*     */   {
/* 177 */     this.validConnectionCheckerClassName = validConnectionCheckerClassName;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="stale-connection-checker-class-name", description="The DataSource stale connection checker class name")
/*     */   public String getStaleConnectionCheckerClassName() {
/* 183 */     return this.staleConnectionCheckerClassName;
/*     */   }
/*     */ 
/*     */   public void setStaleConnectionCheckerClassName(String staleConnectionCheckerClassName)
/*     */   {
/* 188 */     this.staleConnectionCheckerClassName = staleConnectionCheckerClassName;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="url-delimiter", description="The DataSource url delimiter")
/*     */   public String getURLDelimiter() {
/* 194 */     return this.urlDelimiter;
/*     */   }
/*     */ 
/*     */   public void setURLDelimiter(String urlDelimiter)
/*     */   {
/* 199 */     this.urlDelimiter = urlDelimiter;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="url-selector-strategy-class-name", description="The DataSource url selector strategy class name")
/*     */   public String getURLSelectorStrategyClassName() {
/* 205 */     return this.urlSelectorStrategyClassName;
/*     */   }
/*     */ 
/*     */   public void setURLSelectorStrategyClassName(String urlSelectorStrategyClassName)
/*     */   {
/* 210 */     this.urlSelectorStrategyClassName = urlSelectorStrategyClassName;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="prepared-statement-cache-size", description="The DataSource prepared statement cache size")
/*     */   public int getPreparedStatementCacheSize()
/*     */   {
/* 217 */     return this.preparedStatementCacheSize;
/*     */   }
/*     */ 
/*     */   public void setPreparedStatementCacheSize(int preparedStatementCacheSize)
/*     */   {
/* 222 */     this.preparedStatementCacheSize = preparedStatementCacheSize;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="query-timeout", description="The query timeout")
/*     */   public int getQueryTimeout() {
/* 228 */     return this.queryTimeout;
/*     */   }
/*     */ 
/*     */   public void setQueryTimeout(int queryTimeout)
/*     */   {
/* 233 */     this.queryTimeout = queryTimeout;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="share-prepared-statements", description="Should prepared statements be shared")
/*     */   public boolean isSharePreparedStatements() {
/* 239 */     return this.sharePreparedStatements;
/*     */   }
/*     */ 
/*     */   public void setSharePreparedStatements(boolean sharePreparedStatements)
/*     */   {
/* 244 */     this.sharePreparedStatements = sharePreparedStatements;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="track-statements", description="The track statements method")
/*     */   public String getTrackStatements() {
/* 250 */     return this.trackStatements;
/*     */   }
/*     */ 
/*     */   public void setTrackStatements(String trackStatements)
/*     */   {
/* 255 */     this.trackStatements = trackStatements;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="set-tx-query-timeout", description="Should query timeout be enabled")
/*     */   public boolean isUseQueryTimeout() {
/* 261 */     return this.useQueryTimeout;
/*     */   }
/*     */ 
/*     */   public void setUseQueryTimeout(boolean useQueryTimeout)
/*     */   {
/* 266 */     this.useQueryTimeout = useQueryTimeout;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="config-property", description="The connection factory property info", managed=true, propertyFactory=ConnectionFactoryProperty.class)
/*     */   public List<ManagedConnectionFactoryPropertyMetaData> getManagedConnectionFactoryProperties()
/*     */   {
/* 273 */     List properties = new ArrayList();
/* 274 */     ManagedConnectionFactoryPropertyMetaData property = null;
/*     */ 
/* 276 */     if (getUserName() != null)
/*     */     {
/* 278 */       property = new ManagedConnectionFactoryPropertyMetaData();
/* 279 */       property.setName("UserName");
/* 280 */       property.setValue(getUserName());
/* 281 */       properties.add(property);
/*     */     }
/*     */ 
/* 284 */     if (getPassWord() != null)
/*     */     {
/* 286 */       property = new ManagedConnectionFactoryPropertyMetaData();
/* 287 */       property.setName("Password");
/* 288 */       property.setValue(getPassWord());
/* 289 */       properties.add(property);
/*     */     }
/*     */ 
/* 293 */     if (getTransactionIsolation() != null)
/*     */     {
/* 295 */       property = new ManagedConnectionFactoryPropertyMetaData();
/* 296 */       property.setName("TransactionIsolation");
/* 297 */       property.setValue(getTransactionIsolation());
/* 298 */       properties.add(property);
/*     */     }
/*     */ 
/* 302 */     if (getNewConnectionSQL() != null)
/*     */     {
/* 304 */       property = new ManagedConnectionFactoryPropertyMetaData();
/* 305 */       property.setName("NewConnectionSQL");
/* 306 */       property.setValue(getNewConnectionSQL());
/* 307 */       properties.add(property);
/*     */     }
/*     */ 
/* 311 */     if (getCheckValidConnectionSQL() != null)
/*     */     {
/* 313 */       property = new ManagedConnectionFactoryPropertyMetaData();
/* 314 */       property.setName("CheckValidConnectionSQL");
/* 315 */       property.setValue(getCheckValidConnectionSQL());
/* 316 */       properties.add(property);
/*     */     }
/*     */ 
/* 320 */     if (getValidConnectionCheckerClassName() != null)
/*     */     {
/* 322 */       property = new ManagedConnectionFactoryPropertyMetaData();
/* 323 */       property.setName("ValidConnectionCheckerClassName");
/* 324 */       property.setValue(getValidConnectionCheckerClassName());
/* 325 */       properties.add(property);
/*     */     }
/*     */ 
/* 329 */     if (getExceptionSorterClassName() != null)
/*     */     {
/* 331 */       property = new ManagedConnectionFactoryPropertyMetaData();
/* 332 */       property.setName("ExceptionSorterClassName");
/* 333 */       property.setValue(getExceptionSorterClassName());
/* 334 */       properties.add(property);
/*     */     }
/*     */ 
/* 337 */     if (getStaleConnectionCheckerClassName() != null)
/*     */     {
/* 339 */       property = new ManagedConnectionFactoryPropertyMetaData();
/* 340 */       property.setName("StaleConnectionCheckerClassName");
/* 341 */       property.setValue(getStaleConnectionCheckerClassName());
/* 342 */       properties.add(property);
/*     */     }
/*     */ 
/* 345 */     if (getURLSelectorStrategyClassName() != null)
/*     */     {
/* 347 */       property = new ManagedConnectionFactoryPropertyMetaData();
/* 348 */       property.setName("StaleConnectionCheckerClassName");
/* 349 */       property.setValue(getStaleConnectionCheckerClassName());
/* 350 */       properties.add(property);
/*     */     }
/*     */ 
/* 353 */     if (getURLDelimiter() != null)
/*     */     {
/* 355 */       property = new ManagedConnectionFactoryPropertyMetaData();
/* 356 */       property.setName("URLDelimiter");
/* 357 */       property.setValue(getURLDelimiter());
/* 358 */       properties.add(property);
/*     */     }
/*     */ 
/* 361 */     property = new ManagedConnectionFactoryPropertyMetaData();
/* 362 */     property.setName("PreparedStatementCacheSize");
/* 363 */     property.setType("int");
/* 364 */     property.setValue(String.valueOf(getPreparedStatementCacheSize()));
/* 365 */     properties.add(property);
/*     */ 
/* 367 */     property = new ManagedConnectionFactoryPropertyMetaData();
/* 368 */     property.setName("SharePreparedStatements");
/* 369 */     property.setType("boolean");
/* 370 */     property.setValue(String.valueOf(isSharePreparedStatements()));
/* 371 */     properties.add(property);
/*     */ 
/* 373 */     property = new ManagedConnectionFactoryPropertyMetaData();
/* 374 */     property.setName("QueryTimeout");
/* 375 */     property.setType("int");
/* 376 */     property.setValue(String.valueOf(getQueryTimeout()));
/* 377 */     properties.add(property);
/*     */ 
/* 379 */     property = new ManagedConnectionFactoryPropertyMetaData();
/* 380 */     property.setName("TransactionQueryTimeout");
/* 381 */     property.setType("boolean");
/* 382 */     property.setValue(String.valueOf(isUseQueryTimeout()));
/* 383 */     properties.add(property);
/*     */ 
/* 385 */     property = new ManagedConnectionFactoryPropertyMetaData();
/* 386 */     property.setName("ValidateOnMatch");
/* 387 */     property.setType("boolean");
/* 388 */     property.setValue(String.valueOf(isValidateOnMatch()));
/* 389 */     properties.add(property);
/*     */ 
/* 391 */     if (getTrackStatements() != null)
/*     */     {
/* 393 */       property = new ManagedConnectionFactoryPropertyMetaData();
/* 394 */       property.setName("TrackStatements");
/* 395 */       property.setType("java.lang.String");
/* 396 */       property.setValue(String.valueOf(getTrackStatements()));
/* 397 */       properties.add(property);
/*     */     }
/*     */ 
/* 400 */     return properties;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.metadata.mcf.DataSourceDeploymentMetaData
 * JD-Core Version:    0.6.0
 */