/*     */ package org.jboss.resource.metadata.mcf;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.List;
/*     */ import javax.xml.bind.annotation.XmlAccessType;
/*     */ import javax.xml.bind.annotation.XmlAccessorType;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlElements;
/*     */ import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
/*     */ import org.jboss.managed.api.annotation.ManagementObject;
/*     */ import org.jboss.managed.api.annotation.ManagementProperty;
/*     */ import org.jboss.system.metadata.ServiceMetaData;
/*     */ 
/*     */ @XmlAccessorType(XmlAccessType.NONE)
/*     */ @ManagementObject
/*     */ public class ManagedConnectionFactoryDeploymentGroup
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -7650097438654698297L;
/*     */   private URL fileUrl;
/*     */ 
/*     */   @XmlElements({@XmlElement(name="local-tx-datasource", type=LocalDataSourceDeploymentMetaData.class), @XmlElement(name="no-tx-datasource", type=NoTxDataSourceDeploymentMetaData.class), @XmlElement(name="xa-datasource", type=XADataSourceDeploymentMetaData.class), @XmlElement(name="no-tx-connection-factory", type=NoTxConnectionFactoryDeploymentMetaData.class), @XmlElement(name="tx-connection-factory", type=TxConnectionFactoryDeploymentMetaData.class)})
/*  60 */   private List<ManagedConnectionFactoryDeploymentMetaData> deployments = new ArrayList();
/*     */ 
/*     */   @XmlElement(name="mbean")
/*     */   @XmlJavaTypeAdapter(ServiceMetaDataAdapter.class)
/*  68 */   private List<ServiceMetaData> services = new ArrayList();
/*     */ 
/*     */   public void addManagedConnectionFactoryDeployment(ManagedConnectionFactoryDeploymentMetaData deployment)
/*     */   {
/*  74 */     this.deployments.add(deployment);
/*     */   }
/*     */ 
/*     */   @ManagementProperty(description="The connection factories", managed=true)
/*     */   public List<ManagedConnectionFactoryDeploymentMetaData> getDeployments() {
/*  80 */     return Collections.unmodifiableList(this.deployments);
/*     */   }
/*     */ 
/*     */   @ManagementProperty(description="The ds.xml url", ignored=true)
/*     */   public URL getUrl()
/*     */   {
/*  91 */     return this.fileUrl;
/*     */   }
/*     */ 
/*     */   public void setUrl(URL fileUrl)
/*     */   {
/* 101 */     this.fileUrl = fileUrl;
/*     */   }
/*     */ 
/*     */   public void setDeployments(List<ManagedConnectionFactoryDeploymentMetaData> deployments)
/*     */   {
/* 111 */     this.deployments = deployments;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(description="The extra mbeans from the ds.xml", managed=true)
/*     */   public List<ServiceMetaData> getServices()
/*     */   {
/* 122 */     return this.services;
/*     */   }
/*     */ 
/*     */   public void setServices(List<ServiceMetaData> services)
/*     */   {
/* 132 */     this.services = services;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentGroup
 * JD-Core Version:    0.6.0
 */