/*     */ package org.jboss.resource.metadata.mcf;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.xml.bind.annotation.XmlAccessType;
/*     */ import javax.xml.bind.annotation.XmlAccessorType;
/*     */ import javax.xml.bind.annotation.XmlElement;
/*     */ import javax.xml.bind.annotation.XmlType;
/*     */ import org.jboss.managed.api.annotation.ManagementComponent;
/*     */ import org.jboss.managed.api.annotation.ManagementObject;
/*     */ import org.jboss.managed.api.annotation.ManagementProperty;
/*     */ import org.jboss.resource.deployers.management.ConnectionFactoryProperty;
/*     */ import org.jboss.resource.deployers.management.XAConnectionFactoryProperty;
/*     */ 
/*     */ @XmlType(name="xa-datasource")
/*     */ @XmlAccessorType(XmlAccessType.FIELD)
/*     */ @ManagementObject(componentType=@ManagementComponent(type="DataSource", subtype="XA"))
/*     */ public class XADataSourceDeploymentMetaData extends DataSourceDeploymentMetaData
/*     */ {
/*     */   private static final long serialVersionUID = -6919645811610960978L;
/*     */   private static final String RAR_NAME = "jboss-xa-jdbc.rar";
/*     */ 
/*     */   @XmlElement(name="xa-datasource-class")
/*     */   private String xaDataSourceClass;
/*     */ 
/*     */   @XmlElement(name="xa-datasource-property")
/*  38 */   private List<XAConnectionPropertyMetaData> xaDataSourceProperties = new ArrayList();
/*     */ 
/*     */   @XmlElement(name="url-property")
/*     */   private String urlProperty;
/*     */ 
/*     */   @XmlElement(name="xa-resource-timeout")
/*     */   private int xaResourceTimeout;
/*     */ 
/*  49 */   public XADataSourceDeploymentMetaData() { setRarName("jboss-xa-jdbc.rar");
/*  50 */     setTransactionSupportMetaData(ManagedConnectionFactoryTransactionSupportMetaData.XA); }
/*     */ 
/*     */   @ManagementProperty(name="xa-datasource-class", description="The XADataSource class")
/*     */   public String getXaDataSourceClass()
/*     */   {
/*  56 */     return this.xaDataSourceClass;
/*     */   }
/*     */ 
/*     */   public void setXaDataSourceClass(String xaDataSourceClass)
/*     */   {
/*  61 */     this.xaDataSourceClass = xaDataSourceClass;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="url-property", description="The url-property")
/*     */   public String getURLProperty() {
/*  67 */     return this.urlProperty;
/*     */   }
/*     */ 
/*     */   public void setURLProperty(String urlProperty)
/*     */   {
/*  72 */     this.urlProperty = urlProperty;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="xa-resource-timeout", description="The XAResource timeout")
/*     */   public int getXaResourceTimeout() {
/*  78 */     return this.xaResourceTimeout;
/*     */   }
/*     */ 
/*     */   public void setXaResourceTimeout(int xaResourceTimeout)
/*     */   {
/*  83 */     this.xaResourceTimeout = xaResourceTimeout;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="xa-datasource-properties", description="The DataSource properties", managed=true, propertyFactory=XAConnectionFactoryProperty.class)
/*     */   public List<XAConnectionPropertyMetaData> getXADataSourceProperties() {
/*  89 */     return this.xaDataSourceProperties;
/*     */   }
/*     */ 
/*     */   public void setXADataSourceProperties(List<XAConnectionPropertyMetaData> xaDataSourceProperties)
/*     */   {
/*  94 */     this.xaDataSourceProperties = xaDataSourceProperties;
/*     */   }
/*     */ 
/*     */   @ManagementProperty(name="config-property", description="The connection factory property info", managed=true, propertyFactory=ConnectionFactoryProperty.class)
/*     */   public List<ManagedConnectionFactoryPropertyMetaData> getManagedConnectionFactoryProperties()
/*     */   {
/* 101 */     List properties = super.getManagedConnectionFactoryProperties();
/* 102 */     ManagedConnectionFactoryPropertyMetaData property = null;
/*     */ 
/* 104 */     if (getXaDataSourceClass() != null)
/*     */     {
/* 106 */       property = new ManagedConnectionFactoryPropertyMetaData();
/* 107 */       property.setName("XADataSourceClass");
/* 108 */       property.setValue(getXaDataSourceClass());
/* 109 */       properties.add(property);
/*     */     }
/*     */ 
/* 112 */     List dsProps = getXADataSourceProperties();
/*     */ 
/* 114 */     StringBuffer dsBuff = new StringBuffer();
/*     */ 
/* 116 */     if (dsProps != null)
/*     */     {
/* 118 */       for (XAConnectionPropertyMetaData data : dsProps)
/*     */       {
/* 120 */         dsBuff.append(data.getName() + "=" + data.getValue() + "\n");
/*     */       }
/*     */     }
/*     */ 
/* 124 */     property = new ManagedConnectionFactoryPropertyMetaData();
/* 125 */     property.setName("XADataSourceProperties");
/* 126 */     property.setValue(dsBuff.toString());
/* 127 */     properties.add(property);
/*     */ 
/* 129 */     if (getURLProperty() != null)
/*     */     {
/* 131 */       property = new ManagedConnectionFactoryPropertyMetaData();
/* 132 */       property.setName("URLProperty");
/* 133 */       property.setValue(getURLProperty());
/*     */     }
/*     */ 
/* 136 */     return properties;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.metadata.mcf.XADataSourceDeploymentMetaData
 * JD-Core Version:    0.6.0
 */