/*     */ package org.jboss.resource.security;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.math.BigInteger;
/*     */ import java.security.InvalidKeyException;
/*     */ import java.security.NoSuchAlgorithmException;
/*     */ import java.security.Principal;
/*     */ import java.security.acl.Group;
/*     */ import java.util.Map;
/*     */ import javax.crypto.BadPaddingException;
/*     */ import javax.crypto.Cipher;
/*     */ import javax.crypto.IllegalBlockSizeException;
/*     */ import javax.crypto.NoSuchPaddingException;
/*     */ import javax.crypto.spec.SecretKeySpec;
/*     */ import javax.resource.spi.security.PasswordCredential;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.login.LoginException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.SimplePrincipal;
/*     */ 
/*     */ public class SecureIdentityLoginModule extends AbstractPasswordCredentialLoginModule
/*     */ {
/*  70 */   private static final Logger log = Logger.getLogger(SecureIdentityLoginModule.class);
/*     */   private String username;
/*     */   private String password;
/*     */ 
/*     */   public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)
/*     */   {
/*  77 */     super.initialize(subject, handler, sharedState, options);
/*     */ 
/*  79 */     this.username = ((String)options.get("username"));
/*  80 */     if (this.username == null)
/*     */     {
/*  83 */       this.username = ((String)options.get("userName"));
/*  84 */       if (this.username == null)
/*     */       {
/*  86 */         throw new IllegalArgumentException("The user name is a required option");
/*     */       }
/*     */     }
/*  89 */     this.password = ((String)options.get("password"));
/*  90 */     if (this.password == null)
/*     */     {
/*  92 */       throw new IllegalArgumentException("The password is a required option");
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean login() throws LoginException
/*     */   {
/*  98 */     log.trace("login called");
/*  99 */     if (super.login() == true) {
/* 100 */       return true;
/*     */     }
/* 102 */     this.loginOk = true;
/* 103 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean commit() throws LoginException
/*     */   {
/* 108 */     Principal principal = new SimplePrincipal(this.username);
/* 109 */     SubjectActions.addPrincipals(this.subject, principal);
/* 110 */     this.sharedState.put("javax.security.auth.login.name", this.username);
/*     */     try
/*     */     {
/* 114 */       char[] decodedPassword = decode(this.password);
/* 115 */       PasswordCredential cred = new PasswordCredential(this.username, decodedPassword);
/* 116 */       cred.setManagedConnectionFactory(getMcf());
/* 117 */       SubjectActions.addCredentials(this.subject, cred);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 121 */       log.debug("Failed to decode password", e);
/* 122 */       throw new LoginException("Failed to decode password: " + e.getMessage());
/*     */     }
/* 124 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean abort()
/*     */   {
/* 129 */     this.username = null;
/* 130 */     this.password = null;
/* 131 */     return true;
/*     */   }
/*     */ 
/*     */   protected Principal getIdentity()
/*     */   {
/* 136 */     log.trace("getIdentity called, username=" + this.username);
/* 137 */     Principal principal = new SimplePrincipal(this.username);
/* 138 */     return principal;
/*     */   }
/*     */ 
/*     */   protected Group[] getRoleSets() throws LoginException
/*     */   {
/* 143 */     Group[] empty = new Group[0];
/* 144 */     return empty;
/*     */   }
/*     */ 
/*     */   private static String encode(String secret)
/*     */     throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException
/*     */   {
/* 151 */     byte[] kbytes = "jaas is the way".getBytes();
/* 152 */     SecretKeySpec key = new SecretKeySpec(kbytes, "Blowfish");
/*     */ 
/* 154 */     Cipher cipher = Cipher.getInstance("Blowfish");
/* 155 */     cipher.init(1, key);
/* 156 */     byte[] encoding = cipher.doFinal(secret.getBytes());
/* 157 */     BigInteger n = new BigInteger(encoding);
/* 158 */     return n.toString(16);
/*     */   }
/*     */ 
/*     */   private static char[] decode(String secret)
/*     */     throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException
/*     */   {
/* 165 */     byte[] kbytes = "jaas is the way".getBytes();
/* 166 */     SecretKeySpec key = new SecretKeySpec(kbytes, "Blowfish");
/*     */ 
/* 168 */     BigInteger n = new BigInteger(secret, 16);
/* 169 */     byte[] encoding = n.toByteArray();
/*     */ 
/* 171 */     Cipher cipher = Cipher.getInstance("Blowfish");
/* 172 */     cipher.init(2, key);
/* 173 */     byte[] decode = cipher.doFinal(encoding);
/* 174 */     return new String(decode).toCharArray();
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */     throws Exception
/*     */   {
/* 184 */     String encode = encode(args[0]);
/* 185 */     System.out.println("Encoded password: " + encode);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.security.SecureIdentityLoginModule
 * JD-Core Version:    0.6.0
 */