/*     */ package org.jboss.resource.work;
/*     */ 
/*     */ import javax.resource.spi.work.ExecutionContext;
/*     */ import javax.resource.spi.work.Work;
/*     */ import javax.resource.spi.work.WorkCompletedException;
/*     */ import javax.resource.spi.work.WorkEvent;
/*     */ import javax.resource.spi.work.WorkException;
/*     */ import javax.resource.spi.work.WorkListener;
/*     */ import javax.resource.spi.work.WorkRejectedException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ import org.jboss.util.NestedRuntimeException;
/*     */ import org.jboss.util.threadpool.BasicTaskWrapper;
/*     */ import org.jboss.util.threadpool.StartTimeoutException;
/*     */ import org.jboss.util.threadpool.Task;
/*     */ 
/*     */ public class WorkWrapper extends BasicTaskWrapper
/*     */   implements Task
/*     */ {
/*  49 */   private static final Logger log = Logger.getLogger(WorkWrapper.class);
/*     */ 
/*  52 */   private boolean trace = log.isTraceEnabled();
/*     */   private Work work;
/*     */   private ExecutionContext executionContext;
/*     */   private WorkListener workListener;
/*     */   private long startTimeout;
/*     */   private JBossWorkManager workManager;
/*     */   private int waitType;
/*     */   private long blockedTime;
/*     */   private WorkException exception;
/*     */ 
/*     */   public WorkWrapper(JBossWorkManager workManager, Work work, int waitType, long startTimeout, ExecutionContext executionContext, WorkListener workListener)
/*     */   {
/*  92 */     if (work == null)
/*  93 */       throw new IllegalArgumentException("Null work");
/*  94 */     if (executionContext == null)
/*  95 */       throw new IllegalArgumentException("Null execution context");
/*  96 */     if (startTimeout < 0L) {
/*  97 */       throw new IllegalArgumentException("Illegal start timeout: " + startTimeout);
/*     */     }
/*  99 */     this.workManager = workManager;
/* 100 */     this.work = work;
/* 101 */     this.waitType = waitType;
/* 102 */     this.startTimeout = startTimeout;
/* 103 */     this.executionContext = executionContext;
/* 104 */     this.workListener = workListener;
/*     */ 
/* 106 */     setTask(this);
/*     */   }
/*     */ 
/*     */   public JBossWorkManager getWorkManager()
/*     */   {
/* 116 */     return this.workManager;
/*     */   }
/*     */ 
/*     */   public Work getWork()
/*     */   {
/* 126 */     return this.work;
/*     */   }
/*     */ 
/*     */   public WorkListener getWorkListener()
/*     */   {
/* 136 */     return this.workListener;
/*     */   }
/*     */ 
/*     */   public ExecutionContext getExecutionContext()
/*     */   {
/* 146 */     return this.executionContext;
/*     */   }
/*     */ 
/*     */   public long getBlockedElapsed()
/*     */   {
/* 156 */     return this.blockedTime;
/*     */   }
/*     */ 
/*     */   public WorkException getWorkException()
/*     */   {
/* 166 */     return this.exception;
/*     */   }
/*     */ 
/*     */   public int getWaitType()
/*     */   {
/* 171 */     return this.waitType;
/*     */   }
/*     */ 
/*     */   public int getPriority()
/*     */   {
/* 176 */     return 5;
/*     */   }
/*     */ 
/*     */   public long getStartTimeout()
/*     */   {
/* 181 */     return this.startTimeout;
/*     */   }
/*     */ 
/*     */   public long getCompletionTimeout()
/*     */   {
/* 186 */     return this.executionContext.getTransactionTimeout();
/*     */   }
/*     */ 
/*     */   public void execute()
/*     */   {
/* 191 */     if (this.trace)
/* 192 */       log.trace("Executing work " + this);
/*     */     try
/*     */     {
/* 195 */       this.workManager.startWork(this);
/*     */     }
/*     */     catch (WorkException e)
/*     */     {
/* 199 */       taskRejected(new NestedRuntimeException(e));
/* 200 */       return;
/*     */     }
/*     */     try
/*     */     {
/* 204 */       this.work.run();
/*     */     }
/*     */     finally
/*     */     {
/* 208 */       this.workManager.endWork(this);
/*     */     }
/* 210 */     if (this.trace)
/* 211 */       log.trace("Executed work " + this);
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 216 */     if (this.trace) {
/* 217 */       log.trace("Stopping work " + this);
/*     */     }
/* 219 */     this.work.release();
/*     */   }
/*     */ 
/*     */   public void accepted(long time)
/*     */   {
/* 224 */     this.blockedTime = time;
/*     */ 
/* 226 */     if (this.trace) {
/* 227 */       log.trace("Accepted work " + this);
/*     */     }
/* 229 */     if (this.workListener != null)
/*     */     {
/* 231 */       WorkEvent event = new WorkEvent(this.workManager, 1, this.work, null);
/* 232 */       this.workListener.workAccepted(event);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void rejected(long time, Throwable throwable)
/*     */   {
/* 238 */     this.blockedTime = time;
/*     */ 
/* 240 */     if (this.trace)
/*     */     {
/* 242 */       if (throwable != null)
/* 243 */         log.trace("Rejecting work " + this, throwable);
/*     */       else {
/* 245 */         log.trace("Rejecting work " + this);
/*     */       }
/*     */     }
/* 248 */     if (throwable != null)
/*     */     {
/* 250 */       this.exception = new WorkRejectedException(throwable);
/* 251 */       if ((throwable instanceof StartTimeoutException)) {
/* 252 */         this.exception.setErrorCode("1");
/*     */       }
/*     */     }
/* 255 */     this.workManager.cancelWork(this);
/*     */ 
/* 257 */     if (this.workListener != null)
/*     */     {
/* 259 */       WorkEvent event = new WorkEvent(this.workManager, 1, this.work, this.exception);
/* 260 */       this.workListener.workRejected(event);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void started(long time)
/*     */   {
/* 266 */     if (this.waitType != 0) {
/* 267 */       this.blockedTime = time;
/*     */     }
/* 269 */     if (this.workListener != null)
/*     */     {
/* 271 */       WorkEvent event = new WorkEvent(this.workManager, 3, this.work, null);
/* 272 */       this.workListener.workStarted(event);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void completed(long time, Throwable throwable)
/*     */   {
/* 278 */     if (this.waitType == 2) {
/* 279 */       this.blockedTime = time;
/*     */     }
/* 281 */     if (throwable != null) {
/* 282 */       this.exception = new WorkCompletedException(throwable);
/*     */     }
/* 284 */     if (this.trace) {
/* 285 */       log.trace("Completed work " + this);
/*     */     }
/* 287 */     if (this.workListener != null)
/*     */     {
/* 289 */       WorkEvent event = new WorkEvent(this.workManager, 4, this.work, this.exception);
/* 290 */       this.workListener.workCompleted(event);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 296 */     JBossStringBuilder buffer = new JBossStringBuilder(100);
/* 297 */     buffer.append("WorkWrapper@").append(Integer.toHexString(System.identityHashCode(this)));
/* 298 */     buffer.append("[workManger=").append(this.workManager);
/* 299 */     buffer.append(" work=").append(this.work);
/* 300 */     buffer.append(" state=").append(getStateString());
/* 301 */     if ((this.executionContext != null) && (this.executionContext.getXid() != null))
/*     */     {
/* 303 */       buffer.append(" xid=").append(this.executionContext.getXid());
/* 304 */       buffer.append(" txTimeout=").append(this.executionContext.getTransactionTimeout());
/*     */     }
/* 306 */     buffer.append(" waitType=");
/* 307 */     switch (this.waitType)
/*     */     {
/*     */     case 0:
/* 311 */       buffer.append("WAIT_NONE");
/* 312 */       break;
/*     */     case 1:
/* 316 */       buffer.append("WAIT_FOR_START");
/* 317 */       break;
/*     */     case 2:
/* 321 */       buffer.append("WAIT_FOR_COMPLETE");
/* 322 */       break;
/*     */     default:
/* 325 */       buffer.append("???");
/*     */     }
/* 327 */     if (this.startTimeout != 9223372036854775807L)
/* 328 */       buffer.append(" startTimeout=").append(this.startTimeout);
/* 329 */     long completionTimeout = getCompletionTimeout();
/* 330 */     if (completionTimeout != -1L)
/* 331 */       buffer.append(" completionTimeout=").append(completionTimeout);
/* 332 */     if (this.blockedTime != 0L)
/* 333 */       buffer.append(" blockTime=").append(this.blockedTime);
/* 334 */     buffer.append(" elapsedTime=").append(getElapsedTime());
/* 335 */     if (this.workListener != null)
/* 336 */       buffer.append(" workListener=").append(this.workListener);
/* 337 */     if (this.exception != null)
/* 338 */       buffer.append(" exception=").append(this.exception);
/* 339 */     buffer.append("]");
/* 340 */     return buffer.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.work.WorkWrapper
 * JD-Core Version:    0.6.0
 */