/*     */ package org.jboss.security;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.HashMap;
/*     */ import javax.ejb.EJBContext;
/*     */ 
/*     */ public abstract class AbstractSecurityProxy
/*     */   implements SecurityProxy
/*     */ {
/*     */   private HashMap methodMap;
/*     */   private Method setContextMethod;
/*     */   private Method setBeanMethod;
/*     */   protected Object delegate;
/*  58 */   protected boolean strict = false;
/*     */ 
/*     */   AbstractSecurityProxy(Object delegate)
/*     */   {
/*  62 */     this.delegate = delegate;
/*  63 */     this.methodMap = new HashMap();
/*     */   }
/*     */ 
/*     */   protected abstract void invokeHomeOnDelegate(Method paramMethod, Object[] paramArrayOfObject, Object paramObject)
/*     */     throws Exception;
/*     */ 
/*     */   protected abstract void invokeOnDelegate(Method paramMethod, Object[] paramArrayOfObject, Object paramObject)
/*     */     throws Exception;
/*     */ 
/*     */   public void init(Class beanHome, Class beanRemote, Object securityMgr)
/*     */     throws InstantiationException
/*     */   {
/* 106 */     init(beanHome, beanRemote, null, null, securityMgr);
/*     */   }
/*     */ 
/*     */   public void init(Class beanHome, Class beanRemote, Class beanLocalHome, Class beanLocal, Object securityMgr)
/*     */     throws InstantiationException
/*     */   {
/* 130 */     mapHomeMethods(beanHome);
/*     */ 
/* 132 */     mapHomeMethods(beanLocalHome);
/*     */ 
/* 134 */     mapRemoteMethods(beanRemote);
/*     */ 
/* 136 */     mapRemoteMethods(beanLocal);
/*     */     try
/*     */     {
/* 140 */       Class[] parameterTypes = { EJBContext.class };
/* 141 */       this.setContextMethod = this.delegate.getClass().getMethod("setEJBContext", parameterTypes);
/*     */     }
/*     */     catch (Exception ignore)
/*     */     {
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 150 */       Class[] parameterTypes = { Object.class };
/* 151 */       this.setBeanMethod = this.delegate.getClass().getMethod("setBean", parameterTypes);
/*     */     }
/*     */     catch (Exception ignore)
/*     */     {
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 160 */       Class[] parameterTypes = new Class[0];
/* 161 */       Object[] args = new Object[0];
/* 162 */       Method isStrict = this.delegate.getClass().getMethod("isStrict", parameterTypes);
/* 163 */       Boolean flag = (Boolean)isStrict.invoke(this.delegate, args);
/* 164 */       this.strict = flag.booleanValue();
/*     */     }
/*     */     catch (Exception ignore)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setEJBContext(EJBContext ctx)
/*     */   {
/* 178 */     if (this.setContextMethod != null)
/*     */     {
/* 180 */       Object[] args = { ctx };
/*     */       try
/*     */       {
/* 183 */         this.setContextMethod.invoke(this.delegate, args);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 187 */         e.printStackTrace();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void invokeHome(Method m, Object[] args)
/*     */     throws Exception
/*     */   {
/* 201 */     Method delegateMethod = (Method)this.methodMap.get(m);
/* 202 */     if (delegateMethod != null)
/* 203 */       invokeHomeOnDelegate(delegateMethod, args, this.delegate);
/*     */   }
/*     */ 
/*     */   public void invoke(Method m, Object[] args, Object bean)
/*     */     throws Exception
/*     */   {
/* 216 */     Method delegateMethod = (Method)this.methodMap.get(m);
/* 217 */     if (delegateMethod != null)
/*     */     {
/* 219 */       if (this.setBeanMethod != null)
/*     */       {
/* 221 */         Object[] bargs = { bean };
/*     */         try
/*     */         {
/* 224 */           this.setBeanMethod.invoke(this.delegate, bargs);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 228 */           e.printStackTrace();
/* 229 */           throw new SecurityException("Failed to set bean on proxy" + e.getMessage());
/*     */         }
/*     */       }
/* 232 */       invokeOnDelegate(delegateMethod, args, this.delegate);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void mapHomeMethods(Class beanHome)
/*     */   {
/* 244 */     if (beanHome == null) {
/* 245 */       return;
/*     */     }
/* 247 */     Class delegateClass = this.delegate.getClass();
/* 248 */     Method[] methods = beanHome.getMethods();
/* 249 */     for (int m = 0; m < methods.length; m++)
/*     */     {
/* 252 */       Method hm = methods[m];
/* 253 */       Class[] parameterTypes = hm.getParameterTypes();
/* 254 */       String name = hm.getName();
/* 255 */       name = "ejb" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
/*     */       try
/*     */       {
/* 258 */         Method match = delegateClass.getMethod(name, parameterTypes);
/* 259 */         this.methodMap.put(hm, match);
/*     */       }
/*     */       catch (NoSuchMethodException e)
/*     */       {
/* 264 */         name = hm.getName();
/*     */         try
/*     */         {
/* 267 */           Method match = delegateClass.getMethod(name, parameterTypes);
/* 268 */           this.methodMap.put(hm, match);
/*     */         }
/*     */         catch (NoSuchMethodException e2)
/*     */         {
/* 272 */           if (!this.strict)
/*     */             continue;
/* 274 */           String msg = "Missing home method:" + hm + " in delegate";
/* 275 */           throw new SecurityException(msg);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void mapRemoteMethods(Class beanRemote)
/*     */   {
/* 288 */     if (beanRemote == null) {
/* 289 */       return;
/*     */     }
/* 291 */     Class delegateClass = this.delegate.getClass();
/* 292 */     Method[] methods = beanRemote.getMethods();
/* 293 */     for (int m = 0; m < methods.length; m++)
/*     */     {
/* 295 */       Method rm = methods[m];
/* 296 */       Class[] parameterTypes = rm.getParameterTypes();
/* 297 */       String name = rm.getName();
/*     */       try
/*     */       {
/* 300 */         Method match = delegateClass.getMethod(name, parameterTypes);
/* 301 */         this.methodMap.put(rm, match);
/*     */       }
/*     */       catch (NoSuchMethodException e)
/*     */       {
/* 305 */         if (!this.strict)
/*     */           continue;
/* 307 */         String msg = "Missing method:" + rm + " in delegate";
/* 308 */         throw new SecurityException(msg);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.AbstractSecurityProxy
 * JD-Core Version:    0.6.0
 */