/*     */ package org.jboss.security;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.AllPermission;
/*     */ import java.security.CodeSource;
/*     */ import java.security.KeyStore;
/*     */ import java.security.PermissionCollection;
/*     */ import java.security.Permissions;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.login.AppConfigurationEntry;
/*     */ 
/*     */ public class AppPolicy
/*     */ {
/*  41 */   public static final PermissionCollection NO_PERMISSIONS = new Permissions();
/*     */   private static PermissionCollection ALL_PERMISSIONS;
/*     */   private static AppPolicy defaultAppPolicy;
/*     */   private String appName;
/*     */   private KeyStore keyStore;
/*     */   private AuthorizationInfo permissionInfo;
/*     */   private AuthenticationInfo loginInfo;
/*     */ 
/*     */   public KeyStore getKeyStore()
/*     */   {
/*  76 */     return this.keyStore;
/*     */   }
/*     */ 
/*     */   public void setKeyStore(KeyStore keyStore) {
/*  80 */     this.keyStore = keyStore;
/*     */   }
/*     */ 
/*     */   public static void setDefaultAppPolicy(AppPolicy policy)
/*     */   {
/*  85 */     if (policy == null)
/*  86 */       throw new IllegalArgumentException("The policy argument cannot be null");
/*  87 */     defaultAppPolicy = policy;
/*     */   }
/*     */ 
/*     */   public static AppPolicy getDefaultAppPolicy() {
/*  91 */     return defaultAppPolicy;
/*     */   }
/*     */ 
/*     */   public AppPolicy(String appName)
/*     */   {
/*  96 */     this.appName = appName;
/*     */   }
/*     */ 
/*     */   public AuthenticationInfo getLoginInfo()
/*     */   {
/* 101 */     AccessController.checkPermission(AuthenticationInfo.GET_CONFIG_ENTRY_PERM);
/* 102 */     return this.loginInfo;
/*     */   }
/*     */ 
/*     */   public void setLoginInfo(AuthenticationInfo loginInfo) {
/* 106 */     AccessController.checkPermission(AuthenticationInfo.SET_CONFIG_ENTRY_PERM);
/* 107 */     this.loginInfo = loginInfo;
/*     */   }
/*     */ 
/*     */   public AuthorizationInfo getPermissionInfo() {
/* 111 */     return this.permissionInfo;
/*     */   }
/*     */ 
/*     */   public void setPermissionInfo(AuthorizationInfo permissionInfo) {
/* 115 */     this.permissionInfo = permissionInfo;
/*     */   }
/*     */ 
/*     */   public AppConfigurationEntry[] getAppConfigurationEntry()
/*     */   {
/* 120 */     AppConfigurationEntry[] appConfig = null;
/* 121 */     if (this.loginInfo != null)
/* 122 */       appConfig = this.loginInfo.getAppConfigurationEntry();
/* 123 */     if ((appConfig == null) && (this != defaultAppPolicy))
/* 124 */       appConfig = defaultAppPolicy.getAppConfigurationEntry();
/* 125 */     AppConfigurationEntry[] copy = null;
/* 126 */     if (appConfig != null)
/*     */     {
/* 128 */       copy = new AppConfigurationEntry[appConfig.length];
/* 129 */       for (int c = 0; c < copy.length; c++)
/*     */       {
/* 131 */         AppConfigurationEntry e0 = appConfig[c];
/* 132 */         AppConfigurationEntry e1 = new AppConfigurationEntry(e0.getLoginModuleName(), e0.getControlFlag(), e0.getOptions());
/*     */ 
/* 137 */         copy[c] = e1;
/*     */       }
/*     */     }
/* 140 */     return copy;
/*     */   }
/*     */ 
/*     */   public PermissionCollection getPermissions(Subject subject, CodeSource codesource) {
/* 144 */     PermissionCollection perms = NO_PERMISSIONS;
/* 145 */     AuthorizationInfo info = getPermissionInfo();
/* 146 */     if (info == null)
/* 147 */       info = defaultAppPolicy.getPermissionInfo();
/* 148 */     if (info != null)
/*     */     {
/* 150 */       perms = info.getPermissions(subject, codesource);
/*     */     }
/*     */ 
/* 153 */     return perms;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 158 */     StringBuffer buffer = new StringBuffer(this.appName);
/* 159 */     buffer.append('\n');
/* 160 */     buffer.append("AuthenticationInfo:\n");
/* 161 */     if (this.loginInfo != null)
/* 162 */       buffer.append(this.loginInfo);
/* 163 */     buffer.append("AuthorizationInfo:\n");
/* 164 */     if (this.permissionInfo != null)
/* 165 */       buffer.append(this.permissionInfo);
/* 166 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  54 */     AllPermission all = new AllPermission();
/*  55 */     ALL_PERMISSIONS = all.newPermissionCollection();
/*  56 */     ALL_PERMISSIONS.add(all);
/*     */ 
/*  58 */     defaultAppPolicy = new AppPolicy("other");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.AppPolicy
 * JD-Core Version:    0.6.0
 */