/*     */ package org.jboss.security;
/*     */ 
/*     */ import java.security.CodeSource;
/*     */ import java.security.Permission;
/*     */ import java.security.PermissionCollection;
/*     */ import java.security.Permissions;
/*     */ import java.security.Principal;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import javax.security.auth.Subject;
/*     */ 
/*     */ public class AuthorizationInfo
/*     */ {
/*  41 */   private static Set emptySet = new HashSet();
/*  42 */   private ArrayList policyMap = new ArrayList();
/*     */   private PolicyEntry[] policyEntries;
/*     */ 
/*     */   public PermissionCollection getPermissions(Subject subject, CodeSource codesource)
/*     */   {
/* 165 */     PermissionCollection perms = new Permissions();
/* 166 */     Set subjectPrincipals = emptySet;
/* 167 */     if (subject != null)
/* 168 */       subjectPrincipals = subject.getPrincipals();
/* 169 */     for (int n = 0; n < this.policyMap.size(); n++)
/*     */     {
/* 171 */       PolicyEntry entry = (PolicyEntry)this.policyMap.get(n);
/* 172 */       if (entry.implies(codesource, subjectPrincipals) == true)
/* 173 */         entry.getPermissions(perms);
/*     */     }
/* 175 */     return perms;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 180 */     StringBuffer buffer = new StringBuffer("permissions:");
/* 181 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public void grant(CodeSource cs, ArrayList permissions)
/*     */   {
/* 186 */     grant(cs, permissions, null);
/*     */   }
/*     */ 
/*     */   public void grant(CodeSource cs, ArrayList permissions, Principal[] principals) {
/* 190 */     PolicyEntry entry = new PolicyEntry(cs, principals, permissions);
/* 191 */     this.policyMap.add(entry);
/*     */   }
/*     */ 
/*     */   static class PolicyEntry
/*     */   {
/*     */     private CodeSource cs;
/*     */     private Principal[] principals;
/*     */     private ArrayList permissions;
/*     */ 
/*     */     PolicyEntry(CodeSource cs, Principal[] principals, ArrayList permissions)
/*     */     {
/*  57 */       this.cs = cs;
/*  58 */       this.principals = principals;
/*  59 */       this.permissions = permissions;
/*     */     }
/*     */ 
/*     */     public void getPermissions(PermissionCollection perms)
/*     */     {
/*  64 */       int length = this.permissions == null ? 0 : this.permissions.size();
/*  65 */       for (int n = 0; n < length; n++)
/*     */       {
/*  67 */         Permission permission = (Permission)this.permissions.get(n);
/*  68 */         perms.add(permission);
/*     */       }
/*     */     }
/*     */ 
/*     */     public boolean implies(CodeSource codesrc, Set subjectPrincipals)
/*     */     {
/*  74 */       boolean implies = false;
/*     */ 
/*  76 */       if (this.cs == codesrc)
/*     */       {
/*  78 */         implies = true;
/*     */       }
/*  80 */       else if ((this.cs != null) && (codesrc != null) && (this.cs.implies(codesrc)))
/*     */       {
/*  82 */         implies = true;
/*     */       }
/*     */ 
/*  86 */       if (implies == true)
/*     */       {
/*  88 */         if (this.principals != null)
/*     */         {
/*  90 */           for (int p = 0; p < this.principals.length; p++)
/*     */           {
/*  92 */             if (subjectPrincipals.contains(this.principals[p]))
/*     */               continue;
/*  94 */             implies = false;
/*  95 */             break;
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 101 */       return implies;
/*     */     }
/*     */ 
/*     */     public boolean equals(Object obj) {
/* 105 */       PolicyEntry key = (PolicyEntry)obj;
/* 106 */       boolean equals = this.cs == key.cs;
/* 107 */       if (!equals)
/*     */       {
/* 109 */         if ((this.cs != null) && (key.cs != null))
/* 110 */           equals = this.cs.equals(key.cs);
/* 111 */         if (equals == true)
/*     */         {
/* 113 */           if ((this.principals != null) && (key.principals != null) && (this.principals.length == key.principals.length))
/*     */           {
/* 115 */             for (int p = 0; p < this.principals.length; p++)
/*     */             {
/* 117 */               if (this.principals[p].equals(key.principals[p]))
/*     */                 continue;
/* 119 */               equals = false;
/* 120 */               break;
/*     */             }
/*     */ 
/*     */           }
/* 124 */           else if ((this.principals != null) || (key.principals != null))
/*     */           {
/* 126 */             equals = false;
/*     */           }
/*     */         }
/*     */       }
/* 130 */       return equals;
/*     */     }
/*     */ 
/*     */     public int hashCode() {
/* 134 */       int hashCode = 0;
/* 135 */       if (this.cs != null)
/* 136 */         hashCode = this.cs.hashCode();
/* 137 */       int length = this.principals == null ? 0 : this.principals.length;
/* 138 */       for (int p = 0; p < length; p++)
/*     */       {
/* 140 */         hashCode += this.principals[p].hashCode();
/*     */       }
/* 142 */       return hashCode;
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 147 */       StringBuffer buffer = new StringBuffer();
/* 148 */       buffer.append("cs=");
/* 149 */       buffer.append(this.cs);
/* 150 */       buffer.append("; principals=");
/* 151 */       for (int p = 0; (this.principals != null) && (p < this.principals.length); p++)
/* 152 */         buffer.append(this.principals[p]);
/* 153 */       buffer.append("; permissions=");
/* 154 */       buffer.append(this.permissions);
/* 155 */       return buffer.toString();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.AuthorizationInfo
 * JD-Core Version:    0.6.0
 */