/*     */ package org.jboss.security;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ 
/*     */ public class RunAsIdentity extends SimplePrincipal
/*     */   implements Cloneable, RunAs
/*     */ {
/*     */   private static final long serialVersionUID = -3236178735180485083L;
/*  46 */   private HashSet<Principal> runAsRoles = new HashSet();
/*     */   private HashSet<Principal> principalsSet;
/*     */   private static final String ANOYMOUS_PRINCIPAL = "anonymous";
/*     */ 
/*     */   public RunAsIdentity(String roleName, String principalName)
/*     */   {
/*  57 */     super(principalName != null ? principalName : "anonymous");
/*     */ 
/*  59 */     if (roleName == null) {
/*  60 */       throw new IllegalArgumentException("The run-as identity must have at least one role");
/*     */     }
/*  62 */     this.runAsRoles.add(new SimplePrincipal(roleName));
/*     */   }
/*     */ 
/*     */   public RunAsIdentity(String roleName, String principalName, Set<String> extraRoleNames)
/*     */   {
/*  70 */     this(roleName, principalName);
/*     */ 
/*  73 */     if (extraRoleNames != null)
/*     */     {
/*  75 */       Iterator it = extraRoleNames.iterator();
/*  76 */       while (it.hasNext())
/*     */       {
/*  78 */         String extraRoleName = (String)it.next();
/*  79 */         this.runAsRoles.add(new SimplePrincipal(extraRoleName));
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Set<Principal> getRunAsRoles()
/*     */   {
/*  90 */     return new HashSet(this.runAsRoles);
/*     */   }
/*     */ 
/*     */   public synchronized Set<Principal> getPrincipalsSet()
/*     */   {
/* 101 */     if (this.principalsSet == null)
/*     */     {
/* 103 */       this.principalsSet = new HashSet();
/* 104 */       this.principalsSet.add(this);
/* 105 */       SimpleGroup roles = new SimpleGroup("Roles");
/* 106 */       this.principalsSet.add(roles);
/* 107 */       Iterator iter = this.runAsRoles.iterator();
/* 108 */       while (iter.hasNext())
/*     */       {
/* 110 */         Principal role = (Principal)iter.next();
/* 111 */         roles.addMember(role);
/*     */       }
/*     */     }
/* 114 */     return this.principalsSet;
/*     */   }
/*     */ 
/*     */   public boolean doesUserHaveRole(Principal role)
/*     */   {
/* 119 */     return this.runAsRoles.contains(role);
/*     */   }
/*     */ 
/*     */   public boolean doesUserHaveRole(Set<Principal> methodRoles)
/*     */   {
/* 127 */     Iterator it = methodRoles.iterator();
/* 128 */     while (it.hasNext())
/*     */     {
/* 130 */       Principal role = (Principal)it.next();
/* 131 */       if (doesUserHaveRole(role))
/* 132 */         return true;
/*     */     }
/* 134 */     return false;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 143 */     return "[roles=" + this.runAsRoles + ",principal=" + getName() + "]";
/*     */   }
/*     */ 
/*     */   public synchronized Object clone() throws CloneNotSupportedException
/*     */   {
/* 148 */     RunAsIdentity clone = (RunAsIdentity)super.clone();
/* 149 */     if (clone != null)
/*     */     {
/* 151 */       clone.principalsSet = (this.principalsSet != null ? (HashSet)this.principalsSet.clone() : null);
/*     */ 
/* 153 */       clone.runAsRoles = ((HashSet)this.runAsRoles.clone());
/*     */     }
/* 155 */     return clone;
/*     */   }
/*     */ 
/*     */   public <T> T getIdentity()
/*     */   {
/* 160 */     return getName();
/*     */   }
/*     */ 
/*     */   public <T> T getProof()
/*     */   {
/* 165 */     return "JavaEE";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.RunAsIdentity
 * JD-Core Version:    0.6.0
 */