/*     */ package org.jboss.security;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.Principal;
/*     */ import java.security.PrivilegedAction;
/*     */ import javax.security.auth.Subject;
/*     */ import org.jboss.security.plugins.SecurityContextAssociation;
/*     */ 
/*     */ class SecurityAssociationActions
/*     */ {
/*     */   static void setSecurityContext(SecurityContext sc)
/*     */   {
/* 134 */     AccessController.doPrivileged(new PrivilegedAction(sc)
/*     */     {
/*     */       public Object run()
/*     */       {
/* 138 */         SecurityContextAssociation.setSecurityContext(this.val$sc);
/* 139 */         return null;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static SecurityContext getSecurityContext() {
/* 146 */     return (SecurityContext)AccessController.doPrivileged(new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/* 150 */         return SecurityContextAssociation.getSecurityContext();
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static void pushSecurityContext(Principal p, Object cred, Subject subject, String securityDomain)
/*     */   {
/* 158 */     AccessController.doPrivileged(new PrivilegedAction(p, cred, subject, securityDomain)
/*     */     {
/*     */       public Object run()
/*     */       {
/*     */         SecurityContext sc;
/*     */         try {
/* 165 */           sc = SecurityContextFactory.createSecurityContext(this.val$p, this.val$cred, this.val$subject, this.val$securityDomain);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 170 */           throw new RuntimeException(e);
/*     */         }
/* 172 */         SecurityContextAssociation.setSecurityContext(sc);
/* 173 */         return null;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static void setPrincipalInfo(Principal principal, Object credential, Subject subject) {
/* 180 */     SetPrincipalInfoAction action = new SetPrincipalInfoAction(principal, credential, subject);
/* 181 */     AccessController.doPrivileged(action);
/*     */   }
/*     */ 
/*     */   static void popPrincipalInfo() {
/* 185 */     PopPrincipalInfoAction action = new PopPrincipalInfoAction(null);
/* 186 */     AccessController.doPrivileged(action);
/*     */   }
/*     */ 
/*     */   static void setServer() {
/* 190 */     AccessController.doPrivileged(SetServerAction.ACTION);
/*     */   }
/*     */ 
/*     */   static void clear() {
/* 194 */     AccessController.doPrivileged(ClearAction.ACTION);
/*     */   }
/*     */ 
/*     */   static Subject getSubject() {
/* 198 */     Subject subject = (Subject)AccessController.doPrivileged(GetSubjectAction.ACTION);
/* 199 */     return subject;
/*     */   }
/*     */ 
/*     */   static Principal getPrincipal() {
/* 203 */     Principal principal = (Principal)AccessController.doPrivileged(GetPrincipalAction.ACTION);
/* 204 */     return principal;
/*     */   }
/*     */ 
/*     */   static Object getCredential() {
/* 208 */     Object credential = AccessController.doPrivileged(GetCredentialAction.ACTION);
/* 209 */     return credential;
/*     */   }
/*     */ 
/*     */   private static class GetCredentialAction
/*     */     implements PrivilegedAction
/*     */   {
/* 124 */     static PrivilegedAction ACTION = new GetCredentialAction();
/*     */ 
/*     */     public Object run() {
/* 127 */       Object credential = SecurityAssociation.getCredential();
/* 128 */       return credential;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class GetPrincipalAction
/*     */     implements PrivilegedAction
/*     */   {
/* 115 */     static PrivilegedAction ACTION = new GetPrincipalAction();
/*     */ 
/*     */     public Object run() {
/* 118 */       Principal principal = SecurityAssociation.getPrincipal();
/* 119 */       return principal;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class GetSubjectAction
/*     */     implements PrivilegedAction
/*     */   {
/* 106 */     static PrivilegedAction ACTION = new GetSubjectAction();
/*     */ 
/*     */     public Object run() {
/* 109 */       Subject subject = SecurityAssociation.getSubject();
/* 110 */       return subject;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class ClearAction
/*     */     implements PrivilegedAction
/*     */   {
/*  96 */     static PrivilegedAction ACTION = new ClearAction();
/*     */ 
/*     */     public Object run() {
/*  99 */       SecurityAssociation.clear();
/* 100 */       SecurityContextAssociation.clearSecurityContext();
/* 101 */       return null;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class SetServerAction
/*     */     implements PrivilegedAction
/*     */   {
/*  87 */     static PrivilegedAction ACTION = new SetServerAction();
/*     */ 
/*     */     public Object run() {
/*  90 */       SecurityAssociation.setServer();
/*  91 */       return null;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class PopPrincipalInfoAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     public Object run()
/*     */     {
/*  81 */       SecurityContextAssociation.clearSecurityContext();
/*  82 */       return null;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class SetPrincipalInfoAction
/*     */     implements PrivilegedAction
/*     */   {
/*     */     Principal principal;
/*     */     Object credential;
/*     */     Subject subject;
/*     */ 
/*     */     SetPrincipalInfoAction(Principal principal, Object credential, Subject subject)
/*     */     {
/*  49 */       this.principal = principal;
/*  50 */       this.credential = credential;
/*  51 */       this.subject = subject;
/*     */     }
/*     */ 
/*     */     public Object run()
/*     */     {
/*  56 */       SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/*  57 */       if (sc == null)
/*     */       {
/*     */         try
/*     */         {
/*  61 */           sc = SecurityContextFactory.createSecurityContext(this.principal, this.credential, this.subject, "CLIENT_PROXY");
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/*  66 */           throw new RuntimeException(e);
/*     */         }
/*     */       }
/*  69 */       SecurityContextAssociation.setSecurityContext(sc);
/*  70 */       this.credential = null;
/*  71 */       this.principal = null;
/*  72 */       this.subject = null;
/*  73 */       return null;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.SecurityAssociationActions
 * JD-Core Version:    0.6.0
 */