/*     */ package org.jboss.security;
/*     */ 
/*     */ import java.net.Authenticator;
/*     */ import java.net.PasswordAuthentication;
/*     */ import java.security.AccessController;
/*     */ import java.security.Principal;
/*     */ import java.security.PrivilegedAction;
/*     */ 
/*     */ public class SecurityAssociationAuthenticator extends Authenticator
/*     */ {
/*     */   protected PasswordAuthentication getPasswordAuthentication()
/*     */   {
/*  40 */     SecurityActions sa = SecurityAssociationAuthenticator.SecurityActions.UTIL.getSecurityActions();
/*  41 */     Principal principal = sa.getPrincipal();
/*  42 */     Object credential = sa.getCredential();
/*  43 */     String name = principal != null ? principal.getName() : null;
/*  44 */     char[] password = new char[0];
/*  45 */     if (credential != null)
/*     */     {
/*  47 */       if (password.getClass().isInstance(credential))
/*  48 */         password = (char[])(char[])credential;
/*     */       else
/*  50 */         password = credential.toString().toCharArray();
/*     */     }
/*  52 */     PasswordAuthentication auth = new PasswordAuthentication(name, password);
/*  53 */     return auth;
/*     */   }
/*     */ 
/*     */   static abstract interface SecurityActions
/*     */   {
/*  66 */     public static final SecurityActions NON_PRIVILEGED = new SecurityActions()
/*     */     {
/*     */       public Principal getPrincipal()
/*     */       {
/*  70 */         return SecurityAssociation.getPrincipal();
/*     */       }
/*     */ 
/*     */       public Object getCredential()
/*     */       {
/*  75 */         return SecurityAssociation.getCredential();
/*     */       }
/*  66 */     };
/*     */ 
/*  79 */     public static final SecurityActions PRIVILEGED = new SecurityActions()
/*     */     {
/*  81 */       private final PrivilegedAction getPrincipalAction = new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/*  85 */           return SecurityAssociation.getPrincipal();
/*     */         }
/*  81 */       };
/*     */ 
/*  89 */       private final PrivilegedAction getCredentialAction = new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/*  93 */           return SecurityAssociation.getCredential();
/*     */         }
/*  89 */       };
/*     */ 
/*     */       public Principal getPrincipal()
/*     */       {
/*  99 */         return (Principal)AccessController.doPrivileged(this.getPrincipalAction);
/*     */       }
/*     */ 
/*     */       public Object getCredential()
/*     */       {
/* 104 */         return AccessController.doPrivileged(this.getCredentialAction);
/*     */       }
/*  79 */     };
/*     */ 
/*     */     public abstract Principal getPrincipal();
/*     */ 
/*     */     public abstract Object getCredential();
/*     */ 
/*     */     public static class UTIL
/*     */     {
/*     */       static SecurityAssociationAuthenticator.SecurityActions getSecurityActions()
/*     */       {
/*  62 */         return System.getSecurityManager() == null ? SecurityAssociationAuthenticator.SecurityActions.NON_PRIVILEGED : SecurityAssociationAuthenticator.SecurityActions.PRIVILEGED;
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.SecurityAssociationAuthenticator
 * JD-Core Version:    0.6.0
 */