/*     */ package org.jboss.security.auth;
/*     */ 
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.login.LoginContext;
/*     */ import javax.security.auth.login.LoginException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ 
/*     */ public class SystemAuthenticator extends ServiceMBeanSupport
/*     */   implements SystemAuthenticatorMBean
/*     */ {
/*     */   private Subject systemSubject;
/*     */   private String securityDomain;
/*     */   private CallbackHandler callbackHandler;
/*     */ 
/*     */   public String getSecurityDomain()
/*     */   {
/*  53 */     return this.securityDomain;
/*     */   }
/*     */ 
/*     */   public void setSecurityDomain(String name)
/*     */   {
/*  60 */     this.securityDomain = name;
/*     */   }
/*     */ 
/*     */   public Class getCallbackHandler()
/*     */   {
/*  69 */     Class clazz = null;
/*  70 */     if (this.callbackHandler != null)
/*  71 */       clazz = this.callbackHandler.getClass();
/*  72 */     return clazz;
/*     */   }
/*     */ 
/*     */   public void setCallbackHandler(Class callbackHandlerClass)
/*     */     throws InstantiationException, IllegalAccessException
/*     */   {
/*  81 */     this.callbackHandler = ((CallbackHandler)callbackHandlerClass.newInstance());
/*     */   }
/*     */ 
/*     */   protected void startService() throws Exception
/*     */   {
/*     */     try
/*     */     {
/*  88 */       LoginContext lc = new LoginContext(this.securityDomain, this.callbackHandler);
/*  89 */       lc.login();
/*  90 */       this.systemSubject = lc.getSubject();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*  94 */       this.log.fatal("SystemAuthenticator failed, server will shutdown NOW!", t);
/*  95 */       LoginException le = new LoginException("SystemAuthenticator failed, msg=" + t.getMessage());
/*  96 */       Thread shutdownThread = new Thread("SystemAuthenticatorExitThread")
/*     */       {
/*     */         public void run()
/*     */         {
/* 100 */           System.exit(1);
/*     */         }
/*     */       };
/* 103 */       shutdownThread.start();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void stopService() throws Exception
/*     */   {
/* 109 */     if (this.systemSubject != null)
/*     */     {
/* 111 */       LoginContext lc = new LoginContext(this.securityDomain, this.systemSubject, this.callbackHandler);
/* 112 */       lc.logout();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.SystemAuthenticator
 * JD-Core Version:    0.6.0
 */