/*     */ package org.jboss.security.auth.container.modules;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Map;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.login.LoginContext;
/*     */ import javax.security.auth.login.LoginException;
/*     */ import javax.security.auth.message.AuthException;
/*     */ import javax.security.auth.message.AuthStatus;
/*     */ import javax.security.auth.message.MessageInfo;
/*     */ 
/*     */ public class DelegatingServerAuthModule extends AbstractServerAuthModule
/*     */ {
/*  43 */   private LoginContext loginContext = null;
/*  44 */   private String loginContextName = null;
/*     */ 
/*     */   public DelegatingServerAuthModule()
/*     */   {
/*     */   }
/*     */ 
/*     */   public DelegatingServerAuthModule(String loginModuleStackHolderName)
/*     */   {
/*  52 */     this.loginContextName = loginModuleStackHolderName;
/*     */   }
/*     */ 
/*     */   public Class[] getSupportedMessageTypes()
/*     */   {
/*  57 */     Class[] clarr = new Class[this.supportedTypes.size()];
/*  58 */     this.supportedTypes.toArray(clarr);
/*  59 */     return clarr;
/*     */   }
/*     */ 
/*     */   public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException
/*     */   {
/*  64 */     if (this.loginContext != null)
/*     */       try
/*     */       {
/*  67 */         this.loginContext.logout();
/*     */       }
/*     */       catch (LoginException e)
/*     */       {
/*  71 */         throw new AuthException(e.getLocalizedMessage());
/*     */       }
/*     */   }
/*     */ 
/*     */   public AuthStatus secureResponse(MessageInfo messageInfo, Subject arg1) throws AuthException
/*     */   {
/*  77 */     return null;
/*     */   }
/*     */ 
/*     */   protected boolean validate(Subject clientSubject)
/*     */     throws AuthException
/*     */   {
/*     */     try
/*     */     {
/*  85 */       this.loginContext = SecurityActions.createLoginContext(getSecurityDomainName(), clientSubject, this.callbackHandler);
/*  86 */       this.loginContext.login();
/*  87 */       return true;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/*  91 */     throw new AuthException(e.getLocalizedMessage());
/*     */   }
/*     */ 
/*     */   private String getSecurityDomainName()
/*     */   {
/*  97 */     if (this.loginContextName != null) {
/*  98 */       return this.loginContextName;
/*     */     }
/*     */ 
/* 101 */     String domainName = (String)this.options.get("javax.security.auth.login.LoginContext");
/* 102 */     if (domainName == null)
/*     */     {
/* 104 */       domainName = getClass().getName();
/*     */     }
/* 106 */     return domainName;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.container.modules.DelegatingServerAuthModule
 * JD-Core Version:    0.6.0
 */