/*     */ package org.jboss.security.auth.container.modules;
/*     */ 
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.message.AuthException;
/*     */ import javax.security.auth.message.AuthStatus;
/*     */ import javax.security.auth.message.MessageInfo;
/*     */ import javax.security.auth.message.MessagePolicy;
/*     */ import javax.security.auth.message.module.ClientAuthModule;
/*     */ import org.jboss.security.SimplePrincipal;
/*     */ 
/*     */ public class SimpleClientAuthModule
/*     */   implements ClientAuthModule
/*     */ {
/*  45 */   private Class[] supportedTypes = null;
/*  46 */   private SimplePrincipal principal = null;
/*  47 */   private Object credential = null;
/*     */ 
/*  49 */   private MessagePolicy requestPolicy = null;
/*  50 */   private MessagePolicy responsePolicy = null;
/*  51 */   private CallbackHandler handler = null;
/*  52 */   private Map options = null;
/*     */ 
/*     */   public SimpleClientAuthModule(Class[] supportedTypes)
/*     */   {
/*  56 */     this.supportedTypes = supportedTypes;
/*     */   }
/*     */ 
/*     */   public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options)
/*     */     throws AuthException
/*     */   {
/*  66 */     this.requestPolicy = requestPolicy;
/*  67 */     this.responsePolicy = responsePolicy;
/*  68 */     this.handler = handler;
/*  69 */     this.options = options;
/*     */   }
/*     */ 
/*     */   public AuthStatus secureRequest(MessageInfo param, Subject source)
/*     */     throws AuthException
/*     */   {
/*  78 */     source.getPrincipals().add(this.principal);
/*  79 */     source.getPublicCredentials().add(this.credential);
/*  80 */     return AuthStatus.SUCCESS;
/*     */   }
/*     */ 
/*     */   public AuthStatus validateResponse(MessageInfo messageInfo, Subject source, Subject recipient)
/*     */     throws AuthException
/*     */   {
/*  90 */     Set sourceSet = source.getPrincipals(SimplePrincipal.class);
/*  91 */     Set recipientSet = recipient.getPrincipals(SimplePrincipal.class);
/*  92 */     if ((sourceSet == null) && (recipientSet == null))
/*  93 */       throw new AuthException("Principals are null");
/*  94 */     if (sourceSet.size() != recipientSet.size())
/*  95 */       throw new AuthException("Principals size are different");
/*  96 */     return AuthStatus.SUCCESS;
/*     */   }
/*     */ 
/*     */   public Class[] getSupportedMessageTypes()
/*     */   {
/* 104 */     return this.supportedTypes;
/*     */   }
/*     */ 
/*     */   public void cleanSubject(MessageInfo messageInfo, Subject subject)
/*     */     throws AuthException
/*     */   {
/* 112 */     subject.getPrincipals().remove(this.principal);
/* 113 */     subject.getPublicCredentials().remove(this.credential);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.container.modules.SimpleClientAuthModule
 * JD-Core Version:    0.6.0
 */