/*     */ package org.jboss.security.auth.message.config;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.message.AuthException;
/*     */ import javax.security.auth.message.AuthStatus;
/*     */ import javax.security.auth.message.MessageInfo;
/*     */ import javax.security.auth.message.config.ServerAuthContext;
/*     */ import javax.security.auth.message.module.ServerAuthModule;
/*     */ 
/*     */ public class JBossServerAuthContext
/*     */   implements ServerAuthContext
/*     */ {
/*  49 */   private List<ServerAuthModule> modules = new ArrayList();
/*     */ 
/*  51 */   private Map<String, Map> moduleOptionsByName = new HashMap();
/*     */ 
/*     */   public JBossServerAuthContext(List<ServerAuthModule> modules, Map<String, Map> moduleNameToOptions, CallbackHandler cbh)
/*     */     throws AuthException
/*     */   {
/*  56 */     this.modules = modules;
/*  57 */     this.moduleOptionsByName = moduleNameToOptions;
/*  58 */     for (ServerAuthModule sam : modules)
/*     */     {
/*  60 */       sam.initialize(null, null, cbh, (Map)this.moduleOptionsByName.get(sam.getClass().getName()));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void cleanSubject(MessageInfo messageInfo, Subject subject)
/*     */     throws AuthException
/*     */   {
/*  71 */     for (ServerAuthModule sam : this.modules)
/*     */     {
/*  73 */       sam.cleanSubject(messageInfo, subject);
/*     */     }
/*     */   }
/*     */ 
/*     */   public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject)
/*     */     throws AuthException
/*     */   {
/*  82 */     AuthStatus status = null;
/*  83 */     for (ServerAuthModule sam : this.modules)
/*     */     {
/*  85 */       status = sam.secureResponse(messageInfo, serviceSubject);
/*     */     }
/*  87 */     return status;
/*     */   }
/*     */ 
/*     */   public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject)
/*     */     throws AuthException
/*     */   {
/*  96 */     List supportingModules = new ArrayList();
/*     */ 
/*  98 */     Class requestType = messageInfo.getRequestMessage().getClass();
/*  99 */     Class[] requestInterfaces = requestType.getInterfaces();
/*     */ 
/* 101 */     List intfaee = Arrays.asList(requestInterfaces);
/* 102 */     AuthStatus status = null;
/* 103 */     for (ServerAuthModule sam : this.modules)
/*     */     {
/* 105 */       List supportedTypes = Arrays.asList(sam.getSupportedMessageTypes());
/*     */ 
/* 108 */       for (Class clazz : intfaee)
/*     */       {
/* 110 */         if ((supportedTypes.contains(clazz)) && (!supportingModules.contains(sam))) {
/* 111 */           supportingModules.add(sam);
/*     */         }
/*     */       }
/*     */ 
/* 115 */       if ((supportedTypes.contains(requestType)) && (!supportingModules.contains(sam)))
/* 116 */         supportingModules.add(sam);
/*     */     }
/* 118 */     if (supportingModules.size() == 0) {
/* 119 */       throw new RuntimeException("No ServerAuthModule configured to support type:" + requestType);
/*     */     }
/* 121 */     for (ServerAuthModule sam : supportingModules)
/*     */     {
/* 123 */       status = sam.validateRequest(messageInfo, clientSubject, serviceSubject);
/* 124 */       if (status == AuthStatus.FAILURE)
/*     */         break;
/*     */     }
/* 127 */     return status;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.message.config.JBossServerAuthContext
 * JD-Core Version:    0.6.0
 */