/*     */ package org.jboss.security.auth.spi;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.security.acl.Group;
/*     */ import java.util.Map;
/*     */ import java.util.Properties;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.login.LoginException;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class CertRolesLoginModule extends BaseCertLoginModule
/*     */ {
/*  47 */   private String defaultRolesRsrcName = "defaultRoles.properties";
/*     */ 
/*  51 */   private String rolesRsrcName = "roles.properties";
/*     */   private Properties roles;
/*  59 */   private char roleGroupSeperator = '.';
/*     */   private boolean trace;
/*     */ 
/*     */   public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options)
/*     */   {
/*  80 */     super.initialize(subject, callbackHandler, sharedState, options);
/*  81 */     this.trace = this.log.isTraceEnabled();
/*  82 */     if (this.trace) {
/*  83 */       this.log.trace("enter: initialize(Subject, CallbackHandler, Map, Map)");
/*     */     }
/*     */     try
/*     */     {
/*  87 */       String option = (String)options.get("rolesProperties");
/*  88 */       if (option != null)
/*  89 */         this.rolesRsrcName = option;
/*  90 */       option = (String)options.get("defaultRolesProperties");
/*  91 */       if (option != null)
/*  92 */         this.defaultRolesRsrcName = option;
/*  93 */       option = (String)options.get("roleGroupSeperator");
/*  94 */       if (option != null) {
/*  95 */         this.roleGroupSeperator = option.charAt(0);
/*     */       }
/*  97 */       loadRoles();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 103 */       this.log.error("Failed to load users/passwords/role files", e);
/*     */     }
/*     */ 
/* 106 */     if (this.trace)
/* 107 */       this.log.trace("exit: initialize(Subject, CallbackHandler, Map, Map)");
/*     */   }
/*     */ 
/*     */   public boolean login() throws LoginException
/*     */   {
/* 112 */     if (this.trace) {
/* 113 */       this.log.trace("enter: login()");
/*     */     }
/* 115 */     if (this.roles == null)
/* 116 */       throw new LoginException("Missing roles.properties file.");
/* 117 */     boolean wasSuccessful = super.login();
/*     */ 
/* 119 */     if (this.trace) {
/* 120 */       this.log.trace("exit: login()");
/*     */     }
/* 122 */     return wasSuccessful;
/*     */   }
/*     */ 
/*     */   protected Group[] getRoleSets()
/*     */     throws LoginException
/*     */   {
/* 131 */     if (this.trace)
/* 132 */       this.log.trace("enter: getRoleSets()");
/* 133 */     String targetUser = getUsername();
/* 134 */     Group[] roleSets = Util.getRoleSets(targetUser, this.roles, this.roleGroupSeperator, this);
/* 135 */     if (this.trace)
/* 136 */       this.log.trace("exit: getRoleSets()");
/* 137 */     return roleSets;
/*     */   }
/*     */ 
/*     */   private void loadRoles() throws IOException
/*     */   {
/* 142 */     this.roles = Util.loadProperties(this.defaultRolesRsrcName, this.rolesRsrcName, this.log);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.spi.CertRolesLoginModule
 * JD-Core Version:    0.6.0
 */