/*     */ package org.jboss.security.auth.spi;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.security.MessageDigest;
/*     */ import java.security.NoSuchAlgorithmException;
/*     */ import java.util.Map;
/*     */ import javax.security.auth.callback.Callback;
/*     */ import org.jboss.crypto.digest.DigestCallback;
/*     */ import org.jboss.security.auth.callback.MapCallback;
/*     */ 
/*     */ public class RFC2617Digest
/*     */   implements DigestCallback
/*     */ {
/*     */   public static final String REALM = "realm";
/*     */   public static final String USERNAME = "username";
/*     */   public static final String DIGEST_URI = "digest-uri";
/*     */   public static final String NONCE = "nonce";
/*     */   public static final String CNONCE = "cnonce";
/*     */   public static final String NONCE_COUNT = "nc";
/*     */   public static final String QOP = "qop";
/*     */   public static final String ALGORITHM = "algorithm";
/*     */   public static final String AUTH_PARAM = "auth-param";
/*     */   public static final String METHOD = "method";
/*     */   public static final String A2HASH = "a2hash";
/* 217 */   private static char[] MD5_HEX = "0123456789abcdef".toCharArray();
/*     */   private MapCallback info;
/*     */   private String username;
/*     */   private String password;
/*     */   private boolean passwordIsA1Hash;
/*     */   String rfc2617;
/*     */ 
/*     */   public void init(Map options)
/*     */   {
/* 227 */     this.username = ((String)options.get("javax.security.auth.login.name"));
/* 228 */     this.password = ((String)options.get("javax.security.auth.login.password"));
/* 229 */     String flag = (String)options.get("passwordIsA1Hash");
/* 230 */     if (flag != null) {
/* 231 */       this.passwordIsA1Hash = Boolean.valueOf(flag).booleanValue();
/*     */     }
/*     */ 
/* 234 */     this.info = new MapCallback();
/* 235 */     Callback[] callbacks = { this.info };
/* 236 */     options.put("callbacks", callbacks);
/*     */   }
/*     */ 
/*     */   public void preDigest(MessageDigest digest)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void postDigest(MessageDigest digest) {
/* 244 */     String qop = (String)this.info.getInfo("qop");
/* 245 */     String realm = (String)this.info.getInfo("realm");
/* 246 */     String algorithm = (String)this.info.getInfo("algorithm");
/* 247 */     String nonce = (String)this.info.getInfo("nonce");
/* 248 */     String cnonce = (String)this.info.getInfo("cnonce");
/* 249 */     String method = (String)this.info.getInfo("method");
/* 250 */     String nc = (String)this.info.getInfo("nc");
/* 251 */     String digestURI = (String)this.info.getInfo("digest-uri");
/*     */ 
/* 253 */     if (algorithm == null) {
/* 254 */       algorithm = digest.getAlgorithm();
/*     */     }
/* 256 */     digest.reset();
/*     */ 
/* 258 */     String hA1 = null;
/*     */ 
/* 260 */     if ((algorithm == null) || (algorithm.equals("MD5")))
/*     */     {
/* 262 */       if (this.passwordIsA1Hash) {
/* 263 */         hA1 = this.password;
/*     */       }
/*     */       else {
/* 266 */         String A1 = this.username + ":" + realm + ":" + this.password;
/* 267 */         hA1 = H(A1, digest);
/*     */       }
/*     */     }
/* 270 */     else if (algorithm.equals("MD5-sess"))
/*     */     {
/* 272 */       if (this.passwordIsA1Hash)
/*     */       {
/* 274 */         hA1 = this.password + ":" + nonce + ":" + cnonce;
/*     */       }
/*     */       else
/*     */       {
/* 278 */         String A1 = this.username + ":" + realm + ":" + this.password;
/* 279 */         hA1 = H(A1, digest) + ":" + nonce + ":" + cnonce;
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 284 */       throw new IllegalArgumentException("Unsupported algorigthm: " + algorithm);
/*     */     }
/*     */ 
/* 288 */     String hA2 = (String)this.info.getInfo("a2hash");
/* 289 */     if (hA2 == null)
/*     */     {
/* 292 */       String A2 = null;
/* 293 */       if ((qop == null | qop.equals("auth")))
/*     */       {
/* 295 */         A2 = method + ":" + digestURI;
/*     */       }
/*     */       else
/*     */       {
/* 299 */         throw new IllegalArgumentException("Unsupported qop=" + qop);
/*     */       }
/* 301 */       hA2 = H(A2, digest);
/*     */     }
/*     */ 
/* 305 */     if (qop == null)
/*     */     {
/* 307 */       String extra = nonce + ":" + hA2;
/* 308 */       KD(hA1, extra, digest);
/*     */     }
/* 310 */     else if (qop.equals("auth"))
/*     */     {
/* 312 */       String extra = nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + hA2;
/*     */ 
/* 317 */       KD(hA1, extra, digest);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getInfoDigest(MessageDigest digest)
/*     */   {
/* 323 */     if (this.rfc2617 == null)
/*     */     {
/* 325 */       byte[] data = digest.digest();
/* 326 */       this.rfc2617 = cvtHex(data);
/*     */     }
/* 328 */     return this.rfc2617;
/*     */   }
/*     */ 
/*     */   private static String H(String data, MessageDigest digest)
/*     */   {
/* 333 */     digest.reset();
/* 334 */     byte[] x = digest.digest(data.getBytes());
/* 335 */     return cvtHex(x);
/*     */   }
/*     */ 
/*     */   private static void KD(String secret, String data, MessageDigest digest) {
/* 339 */     String x = secret + ":" + data;
/* 340 */     digest.reset();
/* 341 */     digest.update(x.getBytes());
/*     */   }
/*     */ 
/*     */   static String cvtHex(byte[] data)
/*     */   {
/* 364 */     char[] hash = new char[32];
/* 365 */     for (int i = 0; i < 16; i++)
/*     */     {
/* 367 */       int j = data[i] >> 4 & 0xF;
/* 368 */       hash[(i * 2)] = MD5_HEX[j];
/* 369 */       j = data[i] & 0xF;
/* 370 */       hash[(i * 2 + 1)] = MD5_HEX[j];
/*     */     }
/* 372 */     return new String(hash);
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */     throws NoSuchAlgorithmException
/*     */   {
/* 381 */     if (args.length != 3)
/*     */     {
/* 383 */       System.err.println("Usage: RFC2617Digest username realm password");
/* 384 */       System.err.println(" - username : the username");
/* 385 */       System.err.println(" - realm : the web app realm name");
/* 386 */       System.err.println(" - password : the plain text password");
/* 387 */       System.exit(1);
/*     */     }
/* 389 */     String username = args[0];
/* 390 */     String realm = args[1];
/* 391 */     String password = args[2];
/* 392 */     String A1 = username + ":" + realm + ":" + password;
/* 393 */     MessageDigest digest = MessageDigest.getInstance("MD5");
/* 394 */     String hA1 = H(A1, digest);
/* 395 */     System.out.println("RFC2617 A1 hash: " + hA1);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.spi.RFC2617Digest
 * JD-Core Version:    0.6.0
 */