/*     */ package org.jboss.security.auth.spi;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import java.security.acl.Group;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Enumeration;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import org.jboss.security.SimpleGroup;
/*     */ import org.jboss.security.SimplePrincipal;
/*     */ 
/*     */ public class Users
/*     */ {
/*     */   private HashMap users;
/*     */ 
/*     */   public Users()
/*     */   {
/*  42 */     this.users = new HashMap();
/*     */   }
/*     */ 
/*     */   public void addUser(User user)
/*     */   {
/* 142 */     this.users.put(user.getName(), user);
/*     */   }
/*     */ 
/*     */   public Iterator getUsers() {
/* 146 */     return this.users.values().iterator();
/*     */   }
/*     */ 
/*     */   public User getUser(String name) {
/* 150 */     User find = (User)this.users.get(name);
/* 151 */     return find;
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 156 */     return this.users.size();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 161 */     return "Users(" + System.identityHashCode(this) + "){" + "users=" + this.users + "}";
/*     */   }
/*     */ 
/*     */   public static class User
/*     */     implements Comparable
/*     */   {
/*     */     private String name;
/*     */     private String password;
/*     */     private String encoding;
/*  49 */     private HashMap roleGroups = new HashMap();
/*     */ 
/*     */     public User()
/*     */     {
/*     */     }
/*     */ 
/*     */     public User(String name) {
/*  56 */       this.name = name;
/*     */     }
/*     */ 
/*     */     public String getName() {
/*  60 */       return this.name;
/*     */     }
/*     */ 
/*     */     public void setName(String name) {
/*  64 */       this.name = name;
/*     */     }
/*     */ 
/*     */     public String getPassword() {
/*  68 */       return this.password;
/*     */     }
/*     */ 
/*     */     public void setPassword(String password) {
/*  72 */       this.password = password;
/*     */     }
/*     */ 
/*     */     public String getEncoding()
/*     */     {
/*  77 */       return this.encoding;
/*     */     }
/*     */ 
/*     */     public void setEncoding(String encoding) {
/*  81 */       this.encoding = encoding;
/*     */     }
/*     */ 
/*     */     public Group[] getRoleSets()
/*     */     {
/*  86 */       Group[] roleSets = new Group[this.roleGroups.size()];
/*  87 */       this.roleGroups.values().toArray(roleSets);
/*  88 */       return roleSets;
/*     */     }
/*     */ 
/*     */     public String[] getRoleNames() {
/*  92 */       return getRoleNames("Roles");
/*     */     }
/*     */ 
/*     */     public String[] getRoleNames(String roleGroup) {
/*  96 */       Group group = (Group)this.roleGroups.get(roleGroup);
/*  97 */       String[] names = new String[0];
/*  98 */       if (group != null)
/*     */       {
/* 100 */         ArrayList tmp = new ArrayList();
/* 101 */         Enumeration iter = group.members();
/* 102 */         while (iter.hasMoreElements())
/*     */         {
/* 104 */           Principal p = (Principal)iter.nextElement();
/* 105 */           tmp.add(p.getName());
/*     */         }
/* 107 */         names = new String[tmp.size()];
/* 108 */         tmp.toArray(names);
/*     */       }
/* 110 */       return names;
/*     */     }
/*     */ 
/*     */     public void addRole(String roleName, String roleGroup) {
/* 114 */       Group group = (Group)this.roleGroups.get(roleGroup);
/* 115 */       if (group == null)
/*     */       {
/* 117 */         group = new SimpleGroup(roleGroup);
/* 118 */         this.roleGroups.put(roleGroup, group);
/*     */       }
/* 120 */       SimplePrincipal role = new SimplePrincipal(roleName);
/* 121 */       group.addMember(role);
/*     */     }
/*     */ 
/*     */     public int compareTo(Object obj) {
/* 125 */       User u = (User)obj;
/* 126 */       return this.name.compareTo(u.name);
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 131 */       return "User{name='" + this.name + "'" + ", password=*" + ", encoding='" + this.encoding + "'" + ", roleGroups=" + this.roleGroups + "}";
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.spi.Users
 * JD-Core Version:    0.6.0
 */