/*     */ package org.jboss.security.auth.spi;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.URL;
/*     */ import java.security.acl.Group;
/*     */ import java.util.Map;
/*     */ import java.util.Properties;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import javax.security.auth.login.LoginException;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class UsersLoginModule extends UsernamePasswordLoginModule
/*     */ {
/*  57 */   private String usersRsrcName = "users.properties";
/*     */   private Properties users;
/*     */ 
/*     */   public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options)
/*     */   {
/*  69 */     super.initialize(subject, callbackHandler, sharedState, options);
/*     */     try
/*     */     {
/*  73 */       String option = (String)options.get("usersProperties");
/*  74 */       if (option != null) {
/*  75 */         this.usersRsrcName = option;
/*     */       }
/*     */ 
/*  78 */       loadUsers();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  84 */       this.log.error("Failed to load users/passwords/role files", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean login()
/*     */     throws LoginException
/*     */   {
/*  98 */     if (this.users == null) {
/*  99 */       throw new LoginException("Missing users.properties file.");
/*     */     }
/* 101 */     return super.login();
/*     */   }
/*     */ 
/*     */   protected Group[] getRoleSets()
/*     */     throws LoginException
/*     */   {
/* 111 */     return new Group[0];
/*     */   }
/*     */ 
/*     */   protected String getUsersPassword()
/*     */   {
/* 116 */     String username = getUsername();
/* 117 */     String password = null;
/* 118 */     if (username != null)
/* 119 */       password = this.users.getProperty(username, null);
/* 120 */     return password;
/*     */   }
/*     */ 
/*     */   private void loadUsers() throws IOException
/*     */   {
/* 125 */     this.users = loadProperties(this.usersRsrcName);
/*     */   }
/*     */ 
/*     */   private Properties loadProperties(String propertiesName)
/*     */     throws IOException
/*     */   {
/* 135 */     Properties bundle = null;
/* 136 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 137 */     URL url = loader.getResource(propertiesName);
/* 138 */     if (url == null) {
/* 139 */       throw new IOException("Properties file " + propertiesName + " not found");
/*     */     }
/* 141 */     this.log.trace("Properties file=" + url);
/*     */ 
/* 143 */     InputStream is = url.openStream();
/* 144 */     if (is != null)
/*     */     {
/* 146 */       bundle = new Properties();
/* 147 */       bundle.load(is);
/*     */     }
/*     */     else
/*     */     {
/* 151 */       throw new IOException("Properties file " + propertiesName + " not avilable");
/*     */     }
/* 153 */     return bundle;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.auth.spi.UsersLoginModule
 * JD-Core Version:    0.6.0
 */