/*     */ package org.jboss.security.authorization.modules.ejb;
/*     */ 
/*     */ import com.sun.xacml.Indenter;
/*     */ import com.sun.xacml.attr.StringAttribute;
/*     */ import com.sun.xacml.attr.TimeAttribute;
/*     */ import com.sun.xacml.ctx.Attribute;
/*     */ import com.sun.xacml.ctx.RequestCtx;
/*     */ import com.sun.xacml.ctx.Subject;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.net.URI;
/*     */ import java.security.Principal;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class EJBXACMLUtil
/*     */ {
/*  51 */   private static Logger log = Logger.getLogger(EJBXACMLUtil.class);
/*  52 */   private boolean trace = log.isTraceEnabled();
/*     */ 
/*     */   public RequestCtx createXACMLRequest(String ejbName, String methodName, Principal principal, Set<Principal> roles)
/*     */     throws Exception
/*     */   {
/*  61 */     if (principal == null) {
/*  62 */       throw new IllegalArgumentException("principal is null");
/*     */     }
/*  64 */     String action = methodName;
/*     */ 
/*  66 */     RequestCtx requestCtx = null;
/*  67 */     String username = principal.getName();
/*     */ 
/*  70 */     URI subjectAttrUri = new URI("urn:oasis:names:tc:xacml:1.0:subject:subject-id");
/*  71 */     Attribute subjectAttr = new Attribute(subjectAttrUri, null, null, new StringAttribute(username));
/*     */ 
/*  73 */     Set subjectAttrSet = new HashSet();
/*  74 */     subjectAttrSet.add(subjectAttr);
/*  75 */     subjectAttrSet.addAll(getXACMLRoleSet(roles));
/*     */ 
/*  77 */     Set subjectSet = new HashSet();
/*  78 */     subjectSet.add(new Subject(subjectAttrSet));
/*     */ 
/*  81 */     URI resourceUri = new URI("urn:oasis:names:tc:xacml:1.0:resource:resource-id");
/*  82 */     Attribute resourceAttr = new Attribute(resourceUri, null, null, new StringAttribute(ejbName));
/*     */ 
/*  84 */     Set resourceSet = new HashSet();
/*  85 */     resourceSet.add(resourceAttr);
/*     */ 
/*  88 */     Set actionSet = new HashSet();
/*  89 */     actionSet.add(new Attribute(new URI("urn:oasis:names:tc:xacml:1.0:action:action-id"), null, null, new StringAttribute(action)));
/*     */ 
/*  96 */     Set environSet = new HashSet();
/*     */ 
/*  98 */     URI currentTimeUri = new URI("urn:oasis:names:tc:xacml:1.0:environment:current-time");
/*  99 */     Attribute currentTimeAttr = new Attribute(currentTimeUri, null, null, new TimeAttribute());
/*     */ 
/* 101 */     environSet.add(currentTimeAttr);
/*     */ 
/* 104 */     requestCtx = new RequestCtx(subjectSet, resourceSet, actionSet, environSet);
/*     */ 
/* 106 */     if (this.trace)
/*     */     {
/* 108 */       ByteArrayOutputStream baos = new ByteArrayOutputStream();
/* 109 */       requestCtx.encode(baos, new Indenter());
/* 110 */       log.trace("XACML Request:" + baos.toString());
/* 111 */       baos.close();
/*     */     }
/* 113 */     return requestCtx;
/*     */   }
/*     */ 
/*     */   private Set<Attribute> getXACMLRoleSet(Set<Principal> roles) throws Exception
/*     */   {
/* 118 */     URI roleURI = new URI("urn:oasis:names:tc:xacml:2.0:subject:role");
/*     */ 
/* 120 */     Set roleset = new HashSet();
/* 121 */     Iterator iter = roles != null ? roles.iterator() : null;
/* 122 */     while ((iter != null) && (iter.hasNext()))
/*     */     {
/* 124 */       Principal role = (Principal)iter.next();
/* 125 */       Attribute roleAttr = new Attribute(roleURI, null, null, new StringAttribute(role.getName()));
/*     */ 
/* 127 */       roleset.add(roleAttr);
/*     */     }
/* 129 */     return roleset;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.authorization.modules.ejb.EJBXACMLUtil
 * JD-Core Version:    0.6.0
 */