/*     */ package org.jboss.security.authorization.modules.web;
/*     */ 
/*     */ import com.sun.xacml.Policy;
/*     */ import com.sun.xacml.ctx.RequestCtx;
/*     */ import java.security.Principal;
/*     */ import java.util.Map;
/*     */ import javax.security.jacc.PolicyContext;
/*     */ import javax.servlet.http.HttpServletRequest;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.AuthorizationManager;
/*     */ import org.jboss.security.authorization.PolicyRegistration;
/*     */ import org.jboss.security.authorization.Resource;
/*     */ import org.jboss.security.authorization.modules.AuthorizationModuleDelegate;
/*     */ import org.jboss.security.authorization.resources.WebResource;
/*     */ import org.jboss.security.authorization.sunxacml.JBossXACMLUtil;
/*     */ 
/*     */ public class WebXACMLPolicyModuleDelegate extends AuthorizationModuleDelegate
/*     */ {
/*     */   public WebXACMLPolicyModuleDelegate()
/*     */   {
/*  56 */     log = Logger.getLogger(getClass());
/*  57 */     this.trace = log.isTraceEnabled();
/*     */   }
/*     */ 
/*     */   public int authorize(Resource resource)
/*     */   {
/*  65 */     if (!(resource instanceof WebResource)) {
/*  66 */       throw new IllegalArgumentException("resource is not a WebResource");
/*     */     }
/*  68 */     WebResource webResource = (WebResource)resource;
/*     */ 
/*  71 */     Map map = resource.getMap();
/*  72 */     if (map == null) {
/*  73 */       throw new IllegalStateException("Map from the Resource is null");
/*     */     }
/*  75 */     if (map.size() == 0) {
/*  76 */       throw new IllegalStateException("Map from the Resource is size zero");
/*     */     }
/*     */ 
/*  80 */     HttpServletRequest request = (HttpServletRequest)webResource.getServletRequest();
/*     */ 
/*  82 */     AuthorizationManager am = (AuthorizationManager)map.get("authorizationManager");
/*  83 */     if (am == null)
/*  84 */       throw new IllegalStateException("Authorization Manager is null");
/*  85 */     if ((am instanceof PolicyRegistration))
/*  86 */       this.policyRegistration = ((PolicyRegistration)am);
/*  87 */     Boolean userDataCheck = checkBooleanValue((Boolean)map.get("userDataPermissionCheck"));
/*  88 */     Boolean roleRefCheck = checkBooleanValue((Boolean)map.get("roleRefPermissionCheck"));
/*     */ 
/*  91 */     if ((userDataCheck.booleanValue()) || (roleRefCheck.booleanValue())) {
/*  92 */       return 1;
/*     */     }
/*  94 */     if (request == null) {
/*  95 */       throw new IllegalStateException("Request is null");
/*     */     }
/*  97 */     return process(request, am);
/*     */   }
/*     */ 
/*     */   private Boolean checkBooleanValue(Boolean bool)
/*     */   {
/* 107 */     if (bool == null)
/* 108 */       return Boolean.FALSE;
/* 109 */     return bool;
/*     */   }
/*     */ 
/*     */   private int process(HttpServletRequest request, AuthorizationManager am)
/*     */   {
/* 120 */     Principal userP = request.getUserPrincipal();
/* 121 */     if (userP == null) {
/* 122 */       throw new IllegalStateException("User Principal is null");
/*     */     }
/* 124 */     int result = -1;
/* 125 */     WebXACMLUtil util = new WebXACMLUtil();
/*     */     try
/*     */     {
/* 128 */       RequestCtx requestCtx = util.createXACMLRequest(request, am, am.getUserRoles(userP));
/* 129 */       String contextID = PolicyContext.getContextID();
/* 130 */       Policy policy = (Policy)this.policyRegistration.getPolicy(contextID, null);
/* 131 */       if (policy == null)
/* 132 */         throw new IllegalStateException("Missing xacml policy for contextid:" + contextID);
/* 133 */       result = JBossXACMLUtil.checkXACMLAuthorization(requestCtx, policy);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 137 */       if (this.trace)
/* 138 */         log.trace("Exception in processing:", e);
/* 139 */       result = -1;
/*     */     }
/* 141 */     return result;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.authorization.modules.web.WebXACMLPolicyModuleDelegate
 * JD-Core Version:    0.6.0
 */