/*     */ package org.jboss.security.authorization.sunxacml;
/*     */ 
/*     */ import com.sun.xacml.Indenter;
/*     */ import com.sun.xacml.PDP;
/*     */ import com.sun.xacml.PDPConfig;
/*     */ import com.sun.xacml.Policy;
/*     */ import com.sun.xacml.ctx.RequestCtx;
/*     */ import com.sun.xacml.ctx.ResponseCtx;
/*     */ import com.sun.xacml.ctx.Result;
/*     */ import com.sun.xacml.finder.AttributeFinder;
/*     */ import com.sun.xacml.finder.PolicyFinder;
/*     */ import com.sun.xacml.finder.impl.CurrentEnvModule;
/*     */ import com.sun.xacml.finder.impl.SelectorModule;
/*     */ import com.sun.xacml.support.finder.URLPolicyFinderModule;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.net.URI;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class JBossXACMLUtil
/*     */ {
/*  59 */   private static Logger log = Logger.getLogger(JBossXACMLUtil.class);
/*  60 */   private static boolean trace = log.isTraceEnabled();
/*     */ 
/*     */   public static int analyzeResponseCtx(ResponseCtx response)
/*     */     throws Exception
/*     */   {
/*  73 */     if (trace)
/*     */     {
/*  75 */       ByteArrayOutputStream baos = new ByteArrayOutputStream();
/*  76 */       response.encode(baos, new Indenter());
/*  77 */       log.trace("XACML Response:" + baos.toString());
/*  78 */       baos.close();
/*     */     }
/*  80 */     int result = -1;
/*  81 */     Set results = response.getResults();
/*  82 */     if (results.size() > 1)
/*  83 */       throw new IllegalArgumentException("Number of results > 1");
/*  84 */     Iterator iter = results.iterator();
/*  85 */     if (iter.hasNext())
/*     */     {
/*  87 */       Result res = (Result)iter.next();
/*  88 */       int decision = res.getDecision();
/*  89 */       if (decision == 0)
/*  90 */         result = 1;
/*     */     }
/*  92 */     return result;
/*     */   }
/*     */ 
/*     */   public static synchronized int checkXACMLAuthorization(RequestCtx request, Policy policy)
/*     */     throws Exception
/*     */   {
/* 106 */     ResponseCtx response = getXACMLResponse(request, policy);
/* 107 */     return analyzeResponseCtx(response);
/*     */   }
/*     */ 
/*     */   public static URI getDefaultPolicyID()
/*     */   {
/* 116 */     URI policyID = null;
/*     */     try
/*     */     {
/* 119 */       policyID = new URI("urn:org:jboss:xacml:support:finder:dynamic-policy-set");
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 123 */       log.debug("Exception in getDefaultPolicyID:", e);
/*     */     }
/* 125 */     return policyID;
/*     */   }
/*     */ 
/*     */   public static synchronized ResponseCtx getXACMLResponse(RequestCtx request, Policy policy)
/*     */   {
/* 138 */     AttributeFinder attributeFinder = new AttributeFinder();
/* 139 */     List attributeModules = new ArrayList();
/* 140 */     attributeModules.add(new CurrentEnvModule());
/* 141 */     attributeModules.add(new SelectorModule());
/* 142 */     attributeFinder.setModules(attributeModules);
/*     */ 
/* 145 */     PolicyFinder policyFinder = new PolicyFinder();
/* 146 */     HashSet policyModules = new HashSet();
/* 147 */     policyModules.add(new EnclosingPolicyFinderModule(policy));
/*     */ 
/* 151 */     policyModules.add(new URLPolicyFinderModule());
/* 152 */     policyFinder.setModules(policyModules);
/*     */ 
/* 154 */     PDP pdp = new PDP(new PDPConfig(attributeFinder, policyFinder, null));
/*     */ 
/* 156 */     return pdp.evaluate(request);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.authorization.sunxacml.JBossXACMLUtil
 * JD-Core Version:    0.6.0
 */