/*     */ package org.jboss.security.config;
/*     */ 
/*     */ import org.jboss.security.auth.login.BaseAuthenticationInfo;
/*     */ 
/*     */ public class ApplicationPolicy
/*     */ {
/*     */   private String name;
/*     */   private BaseAuthenticationInfo authenticationInfo;
/*     */   private AuthorizationInfo authorizationInfo;
/*     */   private AuditInfo auditInfo;
/*     */   private MappingInfo roleMappingInfo;
/*     */   private MappingInfo principalMappingInfo;
/*     */   private IdentityTrustInfo identityTrustInfo;
/*     */   private String baseApplicationPolicyName;
/*     */   private PolicyConfig policyConfig;
/*     */ 
/*     */   public ApplicationPolicy(String theName)
/*     */   {
/*  56 */     if (theName == null)
/*  57 */       throw new IllegalArgumentException("name is null");
/*  58 */     this.name = theName;
/*     */   }
/*     */ 
/*     */   public ApplicationPolicy(String theName, BaseAuthenticationInfo info)
/*     */   {
/*  63 */     this(theName);
/*  64 */     this.authenticationInfo = info;
/*     */   }
/*     */ 
/*     */   public ApplicationPolicy(String theName, AuthorizationInfo info)
/*     */   {
/*  69 */     this(theName);
/*  70 */     this.authorizationInfo = info;
/*     */   }
/*     */ 
/*     */   public ApplicationPolicy(String theName, BaseAuthenticationInfo info, AuthorizationInfo info2)
/*     */   {
/*  76 */     this(theName);
/*  77 */     this.authenticationInfo = info;
/*  78 */     this.authorizationInfo = info2;
/*     */   }
/*     */ 
/*     */   public BaseAuthenticationInfo getAuthenticationInfo()
/*     */   {
/*  83 */     BaseAuthenticationInfo bai = null;
/*  84 */     ApplicationPolicy ap = getBaseApplicationPolicy();
/*  85 */     if (ap != null)
/*  86 */       bai = ap.getAuthenticationInfo();
/*  87 */     if ((bai != null) && (this.authenticationInfo == null))
/*  88 */       return bai;
/*  89 */     if (bai != null) {
/*  90 */       return (BaseAuthenticationInfo)this.authenticationInfo.merge(bai);
/*     */     }
/*  92 */     return this.authenticationInfo;
/*     */   }
/*     */ 
/*     */   public void setAuthenticationInfo(BaseAuthenticationInfo authenticationInfo)
/*     */   {
/*  97 */     this.authenticationInfo = authenticationInfo;
/*     */   }
/*     */ 
/*     */   public AuthorizationInfo getAuthorizationInfo()
/*     */   {
/* 102 */     AuthorizationInfo bai = null;
/* 103 */     ApplicationPolicy ap = getBaseApplicationPolicy();
/* 104 */     if (ap != null)
/* 105 */       bai = ap.getAuthorizationInfo();
/* 106 */     if ((bai != null) && (this.authorizationInfo == null))
/* 107 */       return bai;
/* 108 */     if (bai != null) {
/* 109 */       return (AuthorizationInfo)this.authorizationInfo.merge(bai);
/*     */     }
/* 111 */     return this.authorizationInfo;
/*     */   }
/*     */ 
/*     */   public void setAuthorizationInfo(AuthorizationInfo authorizationInfo)
/*     */   {
/* 116 */     this.authorizationInfo = authorizationInfo;
/*     */   }
/*     */ 
/*     */   public MappingInfo getRoleMappingInfo()
/*     */   {
/* 121 */     MappingInfo bai = null;
/* 122 */     ApplicationPolicy ap = getBaseApplicationPolicy();
/* 123 */     if (ap != null) {
/* 124 */       bai = ap.getRoleMappingInfo();
/*     */     }
/* 126 */     if ((bai != null) && (this.roleMappingInfo == null))
/* 127 */       return bai;
/* 128 */     if (bai != null) {
/* 129 */       return (MappingInfo)this.roleMappingInfo.merge(bai);
/*     */     }
/* 131 */     return this.roleMappingInfo;
/*     */   }
/*     */ 
/*     */   public void setRoleMappingInfo(MappingInfo roleMappingInfo)
/*     */   {
/* 136 */     this.roleMappingInfo = roleMappingInfo;
/*     */   }
/*     */ 
/*     */   public MappingInfo getPrincipalMappingInfo()
/*     */   {
/* 141 */     MappingInfo bai = null;
/* 142 */     ApplicationPolicy ap = getBaseApplicationPolicy();
/* 143 */     if (ap != null) {
/* 144 */       bai = ap.getPrincipalMappingInfo();
/*     */     }
/* 146 */     if ((bai != null) && (this.principalMappingInfo == null))
/* 147 */       return bai;
/* 148 */     if (bai != null) {
/* 149 */       return (MappingInfo)this.principalMappingInfo.merge(bai);
/*     */     }
/* 151 */     return this.principalMappingInfo;
/*     */   }
/*     */ 
/*     */   public void setPrincipalMappingInfo(MappingInfo principalMappingInfo)
/*     */   {
/* 157 */     this.principalMappingInfo = principalMappingInfo;
/*     */   }
/*     */ 
/*     */   public AuditInfo getAuditInfo()
/*     */   {
/* 162 */     AuditInfo bai = null;
/* 163 */     ApplicationPolicy ap = getBaseApplicationPolicy();
/* 164 */     if (ap != null) {
/* 165 */       bai = ap.getAuditInfo();
/*     */     }
/* 167 */     if ((bai != null) && (this.auditInfo == null))
/* 168 */       return bai;
/* 169 */     if (bai != null) {
/* 170 */       return (AuditInfo)this.auditInfo.merge(bai);
/*     */     }
/* 172 */     return this.auditInfo;
/*     */   }
/*     */ 
/*     */   public void setAuditInfo(AuditInfo auditInfo)
/*     */   {
/* 177 */     this.auditInfo = auditInfo;
/*     */   }
/*     */ 
/*     */   public IdentityTrustInfo getIdentityTrustInfo()
/*     */   {
/* 182 */     IdentityTrustInfo bai = null;
/* 183 */     ApplicationPolicy ap = getBaseApplicationPolicy();
/* 184 */     if (ap != null) {
/* 185 */       bai = ap.getIdentityTrustInfo();
/*     */     }
/* 187 */     if ((bai != null) && (this.identityTrustInfo == null))
/* 188 */       return bai;
/* 189 */     if (bai != null) {
/* 190 */       return (IdentityTrustInfo)this.identityTrustInfo.merge(bai);
/*     */     }
/* 192 */     return this.identityTrustInfo;
/*     */   }
/*     */ 
/*     */   public void setIdentityTrustInfo(IdentityTrustInfo identityTrustInfo)
/*     */   {
/* 197 */     this.identityTrustInfo = identityTrustInfo;
/*     */   }
/*     */ 
/*     */   public String getBaseApplicationPolicyName()
/*     */   {
/* 202 */     return this.baseApplicationPolicyName;
/*     */   }
/*     */ 
/*     */   public void setBaseApplicationPolicyName(String baseApplicationPolicy)
/*     */   {
/* 207 */     this.baseApplicationPolicyName = baseApplicationPolicy;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 212 */     return this.name;
/*     */   }
/*     */ 
/*     */   public PolicyConfig getPolicyConfig()
/*     */   {
/* 217 */     return this.policyConfig;
/*     */   }
/*     */ 
/*     */   public void setPolicyConfig(PolicyConfig policyConfig)
/*     */   {
/* 222 */     this.policyConfig = policyConfig;
/*     */   }
/*     */ 
/*     */   private ApplicationPolicy getBaseApplicationPolicy()
/*     */   {
/* 227 */     ApplicationPolicy ap = null;
/* 228 */     if (this.baseApplicationPolicyName != null)
/*     */     {
/* 230 */       ap = this.policyConfig.get(this.baseApplicationPolicyName);
/*     */ 
/* 232 */       if (ap == null)
/* 233 */         ap = SecurityConfiguration.getApplicationPolicy(this.baseApplicationPolicyName);
/*     */     }
/* 235 */     return ap;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.config.ApplicationPolicy
 * JD-Core Version:    0.6.0
 */