/*    */ package org.jboss.security.factories;
/*    */ 
/*    */ import java.security.AccessController;
/*    */ import java.security.PrivilegedActionException;
/*    */ import java.security.PrivilegedExceptionAction;
/*    */ 
/*    */ class SecurityActions
/*    */ {
/*    */   static ClassLoader getContextClassLoader()
/*    */     throws PrivilegedActionException
/*    */   {
/* 41 */     return (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction()
/*    */     {
/*    */       public Object run() throws Exception
/*    */       {
/* 45 */         return Thread.currentThread().getContextClassLoader();
/*    */       }
/*    */     });
/*    */   }
/*    */ 
/*    */   static Class<Object> loadClass(String fqn) throws PrivilegedActionException
/*    */   {
/* 53 */     return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(fqn)
/*    */     {
/*    */       public Object run() throws Exception
/*    */       {
/* 57 */         ClassLoader tcl = Thread.currentThread().getContextClassLoader();
/* 58 */         return tcl.loadClass(this.val$fqn);
/*    */       }
/*    */     });
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.factories.SecurityActions
 * JD-Core Version:    0.6.0
 */