/*     */ package org.jboss.security.integration;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import javax.security.auth.callback.CallbackHandler;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.AuthenticationManager;
/*     */ import org.jboss.security.AuthorizationManager;
/*     */ import org.jboss.security.ISecurityManagement;
/*     */ import org.jboss.security.audit.AuditManager;
/*     */ import org.jboss.security.auth.callback.SecurityAssociationHandler;
/*     */ import org.jboss.security.config.SecurityConfiguration;
/*     */ import org.jboss.security.identitytrust.IdentityTrustManager;
/*     */ import org.jboss.security.mapping.MappingManager;
/*     */ import org.jboss.security.plugins.JaasSecurityDomain;
/*     */ import org.jboss.security.plugins.SecurityDomainContext;
/*     */ import org.jboss.util.CachePolicy;
/*     */ import org.jboss.util.TimedCachePolicy;
/*     */ 
/*     */ public class JNDIBasedSecurityManagement
/*     */   implements ISecurityManagement
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*  60 */   protected static Logger log = Logger.getLogger(JNDIBasedSecurityManagement.class);
/*     */ 
/*  62 */   static ConcurrentHashMap<String, SecurityDomainContext> securityMgrMap = new ConcurrentHashMap();
/*     */ 
/*  64 */   protected String BASE_CTX = "java:/jaas";
/*     */ 
/*  66 */   protected String authenticationMgrClass = "org.jboss.security.plugins.JaasSecurityManager";
/*     */ 
/*  68 */   protected String authorizationMgrClass = "org.jboss.security.plugins.JBossAuthorizationManager";
/*     */ 
/*  70 */   protected String auditMgrClass = "org.jboss.security.plugins.audit.JBossAuditManager";
/*     */ 
/*  72 */   protected String identityTrustMgrClass = "org.jboss.security.plugins.identitytrust.JBossIdentityTrustManager";
/*     */ 
/*  74 */   protected String mappingMgrClass = "org.jboss.security.plugins.mapping.JBossMappingManager";
/*     */ 
/*  76 */   protected CallbackHandler callBackHandler = new SecurityAssociationHandler();
/*     */ 
/*  79 */   protected boolean enableIdentity = false;
/*     */ 
/*  82 */   protected boolean enableAudit = true;
/*     */ 
/*  84 */   private CachePolicy cachePolicy = null;
/*     */ 
/*  86 */   private ConcurrentHashMap<String, AuthenticationManager> authMgrMap = new ConcurrentHashMap();
/*  87 */   private ConcurrentHashMap<String, AuthorizationManager> authzMgrMap = new ConcurrentHashMap();
/*  88 */   private ConcurrentHashMap<String, MappingManager> mappingMgrMap = new ConcurrentHashMap();
/*  89 */   private ConcurrentHashMap<String, AuditManager> auditMgrMap = new ConcurrentHashMap();
/*  90 */   private ConcurrentHashMap<String, IdentityTrustManager> idmMgrMap = new ConcurrentHashMap();
/*     */ 
/*     */   public AuditManager getAuditManager(String securityDomain)
/*     */   {
/*  98 */     AuditManager auditManager = null;
/*     */     try
/*     */     {
/* 101 */       if (this.enableAudit)
/*     */       {
/* 103 */         auditManager = (AuditManager)this.auditMgrMap.get(securityDomain);
/* 104 */         if (auditManager == null)
/*     */         {
/* 106 */           auditManager = (AuditManager)lookUpJNDI(securityDomain + "/auditMgr");
/* 107 */           this.auditMgrMap.put(securityDomain, auditManager);
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 113 */       log.trace("Exception in getting audit mgr", e);
/*     */     }
/* 115 */     return auditManager;
/*     */   }
/*     */ 
/*     */   public AuthenticationManager getAuthenticationManager(String securityDomain)
/*     */   {
/* 120 */     AuthenticationManager am = null;
/*     */     try
/*     */     {
/* 123 */       am = (AuthenticationManager)this.authMgrMap.get(securityDomain);
/* 124 */       if (am == null)
/*     */       {
/* 126 */         am = (AuthenticationManager)lookUpJNDI(securityDomain + "/authenticationMgr");
/* 127 */         this.authMgrMap.put(securityDomain, am);
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 132 */       log.trace("Exception in getting authentication mgr", e);
/*     */     }
/* 134 */     return am;
/*     */   }
/*     */ 
/*     */   public AuthorizationManager getAuthorizationManager(String securityDomain)
/*     */   {
/* 139 */     AuthorizationManager am = null;
/*     */     try
/*     */     {
/* 142 */       am = (AuthorizationManager)this.authzMgrMap.get(securityDomain);
/* 143 */       if (am == null)
/*     */       {
/* 145 */         am = (AuthorizationManager)lookUpJNDI(securityDomain + "/authorizationMgr");
/* 146 */         this.authzMgrMap.put(securityDomain, am);
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 151 */       log.trace("Exception in getting authorization mgr", e);
/*     */     }
/* 153 */     return am;
/*     */   }
/*     */ 
/*     */   public IdentityTrustManager getIdentityTrustManager(String securityDomain)
/*     */   {
/* 158 */     IdentityTrustManager am = null;
/*     */     try
/*     */     {
/* 161 */       if (this.enableIdentity)
/*     */       {
/* 163 */         am = (IdentityTrustManager)this.idmMgrMap.get(securityDomain);
/* 164 */         if (am == null)
/*     */         {
/* 166 */           am = (IdentityTrustManager)lookUpJNDI(securityDomain + "/identityTrustMgr");
/* 167 */           this.idmMgrMap.put(securityDomain, am);
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 173 */       log.trace("Exception in getting IdentityTrustManager", e);
/*     */     }
/* 175 */     return am;
/*     */   }
/*     */ 
/*     */   public MappingManager getMappingManager(String securityDomain)
/*     */   {
/* 180 */     MappingManager am = null;
/*     */     try
/*     */     {
/* 183 */       am = (MappingManager)this.mappingMgrMap.get(securityDomain);
/* 184 */       if (am == null)
/*     */       {
/* 186 */         am = (MappingManager)lookUpJNDI(securityDomain + "/mappingMgr");
/* 187 */         this.mappingMgrMap.put(securityDomain, am);
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 192 */       log.trace("Exception in getting MappingManager", e);
/*     */     }
/* 194 */     return am;
/*     */   }
/*     */ 
/*     */   public void setAuthenticationMgrClass(String authenticationMgrClass)
/*     */   {
/* 199 */     this.authenticationMgrClass = authenticationMgrClass;
/*     */   }
/*     */ 
/*     */   public void setAuthorizationMgrClass(String authorizationMgrClass)
/*     */   {
/* 204 */     this.authorizationMgrClass = authorizationMgrClass;
/*     */   }
/*     */ 
/*     */   public void setAuditMgrClass(String auditMgrClass)
/*     */   {
/* 209 */     this.auditMgrClass = auditMgrClass;
/*     */   }
/*     */ 
/*     */   public void setEnableAudit(boolean enableAudit)
/*     */   {
/* 214 */     this.enableAudit = enableAudit;
/*     */   }
/*     */ 
/*     */   public void setEnableIdentity(boolean enableIdentity)
/*     */   {
/* 219 */     this.enableIdentity = enableIdentity;
/*     */   }
/*     */ 
/*     */   public void setIdentityTrustMgrClass(String identityTrustMgrClass)
/*     */   {
/* 224 */     this.identityTrustMgrClass = identityTrustMgrClass;
/*     */   }
/*     */ 
/*     */   public void setMappingMgrClass(String mappingMgrClass)
/*     */   {
/* 229 */     this.mappingMgrClass = mappingMgrClass;
/*     */   }
/*     */ 
/*     */   public void setCallBackHandler(CallbackHandler callBackHandler)
/*     */   {
/* 234 */     this.callBackHandler = callBackHandler;
/*     */   }
/*     */ 
/*     */   public void setBaseContext(String ctx)
/*     */   {
/* 239 */     if (ctx == null)
/* 240 */       throw new IllegalArgumentException("ctx is null");
/* 241 */     this.BASE_CTX = ctx;
/*     */   }
/*     */ 
/*     */   public void setCachePolicy(CachePolicy cp)
/*     */   {
/* 246 */     this.cachePolicy = cp;
/*     */   }
/*     */ 
/*     */   public static void setCacheTimeout(String securityDomain, int timeoutInSecs, int resInSecs)
/*     */   {
/* 259 */     SecurityDomainContext securityDomainCtx = (SecurityDomainContext)securityMgrMap.get(securityDomain);
/* 260 */     if (securityDomainCtx == null)
/*     */     {
/*     */       try
/*     */       {
/* 264 */         String lookupStr = "java:/jaas/" + securityDomain;
/* 265 */         securityDomainCtx = (SecurityDomainContext)new InitialContext().lookup(lookupStr);
/* 266 */         securityMgrMap.put(securityDomain, securityDomainCtx);
/*     */       }
/*     */       catch (NamingException e)
/*     */       {
/* 270 */         log.trace("SetCacheTimeOut:Failed to look up SecurityDomainCtx:" + securityDomain);
/*     */       }
/*     */     }
/* 273 */     if (securityDomainCtx != null)
/*     */     {
/* 275 */       CachePolicy cache = securityDomainCtx.getAuthenticationCache();
/* 276 */       if ((cache != null) && ((cache instanceof TimedCachePolicy)))
/*     */       {
/* 278 */         TimedCachePolicy tcp = (TimedCachePolicy)cache;
/* 279 */         synchronized (tcp)
/*     */         {
/* 281 */           tcp.setDefaultLifetime(timeoutInSecs);
/* 282 */           tcp.setResolution(resInSecs);
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 287 */         log.warn("Failed to find cache policy for securityDomain='" + securityDomain + "'");
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void setDefaultCacheTimeout(int defaultCacheTimeout)
/*     */   {
/* 295 */     SecurityConstantsBridge.defaultCacheTimeout = defaultCacheTimeout;
/*     */   }
/*     */ 
/*     */   public static void setDefaultCacheResolution(int defaultCacheResolution)
/*     */   {
/* 300 */     SecurityConstantsBridge.defaultCacheResolution = defaultCacheResolution;
/*     */   }
/*     */ 
/*     */   public SecurityDomainContext createSecurityDomainContext(String domain) throws Exception
/*     */   {
/* 305 */     AuthenticationManager am = createAuthenticationManager(domain);
/* 306 */     if (this.cachePolicy == null)
/*     */     {
/* 308 */       this.cachePolicy = createDefaultCachePolicy();
/*     */     }
/*     */ 
/* 311 */     setSecurityDomainCache(am, this.cachePolicy);
/*     */ 
/* 313 */     if (SecurityConfiguration.isDeepCopySubjectMode())
/*     */     {
/* 315 */       setDeepCopySubjectMode(am);
/*     */     }
/*     */ 
/* 318 */     SecurityDomainContext securityDomainContext = new SecurityDomainContext(am, this.cachePolicy);
/*     */ 
/* 320 */     securityDomainContext.setAuthorizationManager(createAuthorizationManager(domain));
/* 321 */     securityDomainContext.setAuditMgr(createAuditManager(domain));
/* 322 */     securityDomainContext.setIdentityTrustMgr(createIdentityTrustManager(domain));
/* 323 */     securityDomainContext.setMappingMgr(createMappingManager(domain));
/* 324 */     return securityDomainContext;
/*     */   }
/*     */ 
/*     */   public void registerJaasSecurityDomainInstance(String domain, JaasSecurityDomain jsd)
/*     */     throws Exception
/*     */   {
/* 336 */     SecurityDomainContext sdc = (SecurityDomainContext)securityMgrMap.get(domain);
/* 337 */     if (sdc != null)
/*     */     {
/* 339 */       sdc.setAuthenticationManager(jsd);
/*     */     }
/*     */     else
/*     */     {
/* 343 */       sdc = createSecurityDomainContext(domain);
/* 344 */       sdc.setAuthenticationManager(jsd);
/*     */     }
/* 346 */     securityMgrMap.put(domain, sdc);
/*     */   }
/*     */ 
/*     */   private Object lookUpJNDI(String ctxName)
/*     */   {
/*     */     try
/*     */     {
/* 355 */       Context ctx = new InitialContext();
/* 356 */       return ctx.lookup(this.BASE_CTX + "/" + ctxName);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 360 */       log.trace("Look up of JNDI for " + ctxName + " failed with " + e.getLocalizedMessage());
/* 361 */     }return null;
/*     */   }
/*     */ 
/*     */   private AuthenticationManager createAuthenticationManager(String securityDomain)
/*     */     throws Exception
/*     */   {
/* 367 */     Class clazz = SecurityActions.getContextClassLoader().loadClass(this.authenticationMgrClass);
/* 368 */     Constructor ctr = clazz.getConstructor(new Class[] { String.class, CallbackHandler.class });
/* 369 */     return (AuthenticationManager)ctr.newInstance(new Object[] { securityDomain, this.callBackHandler });
/*     */   }
/*     */ 
/*     */   private AuthorizationManager createAuthorizationManager(String securityDomain) throws Exception
/*     */   {
/* 374 */     Class clazz = SecurityActions.getContextClassLoader().loadClass(this.authorizationMgrClass);
/* 375 */     Constructor ctr = clazz.getConstructor(new Class[] { String.class });
/* 376 */     return (AuthorizationManager)ctr.newInstance(new Object[] { securityDomain });
/*     */   }
/*     */ 
/*     */   private AuditManager createAuditManager(String securityDomain) throws Exception
/*     */   {
/* 381 */     Class clazz = SecurityActions.getContextClassLoader().loadClass(this.auditMgrClass);
/* 382 */     Constructor ctr = clazz.getConstructor(new Class[] { String.class });
/* 383 */     return (AuditManager)ctr.newInstance(new Object[] { securityDomain });
/*     */   }
/*     */ 
/*     */   private MappingManager<?> createMappingManager(String securityDomain) throws Exception
/*     */   {
/* 388 */     Class clazz = SecurityActions.getContextClassLoader().loadClass(this.mappingMgrClass);
/* 389 */     Constructor ctr = clazz.getConstructor(new Class[] { String.class });
/* 390 */     return (MappingManager)ctr.newInstance(new Object[] { securityDomain });
/*     */   }
/*     */ 
/*     */   private IdentityTrustManager createIdentityTrustManager(String securityDomain) throws Exception
/*     */   {
/* 395 */     Class clazz = SecurityActions.getContextClassLoader().loadClass(this.identityTrustMgrClass);
/* 396 */     Constructor ctr = clazz.getConstructor(new Class[] { String.class });
/* 397 */     return (IdentityTrustManager)ctr.newInstance(new Object[] { securityDomain });
/*     */   }
/*     */ 
/*     */   private Object createObject(String fqn) throws Exception
/*     */   {
/* 402 */     Class clazz = SecurityActions.getContextClassLoader().loadClass(fqn);
/* 403 */     return clazz.newInstance();
/*     */   }
/*     */ 
/*     */   private static void setSecurityDomainCache(AuthenticationManager securityMgr, CachePolicy cachePolicy)
/*     */   {
/*     */     try
/*     */     {
/* 416 */       Class[] setCachePolicyTypes = { CachePolicy.class };
/* 417 */       Method m = securityMgr.getClass().getMethod("setCachePolicy", setCachePolicyTypes);
/* 418 */       Object[] setCachePolicyArgs = { cachePolicy };
/* 419 */       m.invoke(securityMgr, setCachePolicyArgs);
/* 420 */       log.debug("setCachePolicy, c=" + setCachePolicyArgs[0]);
/*     */     }
/*     */     catch (Exception e2)
/*     */     {
/* 424 */       if (log.isTraceEnabled())
/* 425 */         log.trace("Optional setCachePolicy failed" + e2.getLocalizedMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void setDeepCopySubjectMode(AuthenticationManager securityMgr)
/*     */   {
/*     */     try
/*     */     {
/* 438 */       Class[] argsType = { Boolean.class };
/* 439 */       Method m = securityMgr.getClass().getMethod("setDeepCopySubjectOption", argsType);
/* 440 */       Object[] deepCopyArgs = { Boolean.TRUE };
/* 441 */       m.invoke(securityMgr, deepCopyArgs);
/* 442 */       log.trace("setDeepCopySubjectOption, option=" + deepCopyArgs[0]);
/*     */     }
/*     */     catch (Exception e2)
/*     */     {
/* 446 */       if (log.isTraceEnabled())
/* 447 */         log.trace("Optional setDeepCopySubjectMode failed" + e2.getLocalizedMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   private CachePolicy createDefaultCachePolicy()
/*     */   {
/* 457 */     TimedCachePolicy cachePolicy = new TimedCachePolicy(SecurityConstantsBridge.defaultCacheTimeout, true, SecurityConstantsBridge.defaultCacheResolution);
/*     */ 
/* 461 */     cachePolicy.create();
/* 462 */     cachePolicy.start();
/* 463 */     return cachePolicy;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.integration.JNDIBasedSecurityManagement
 * JD-Core Version:    0.6.0
 */