/*    */ package org.jboss.security.integration.ejb;
/*    */ 
/*    */ import java.security.Principal;
/*    */ import java.util.HashMap;
/*    */ import java.util.Map;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.security.SecurityContext;
/*    */ import org.jboss.security.audit.AuditEvent;
/*    */ import org.jboss.security.audit.AuditManager;
/*    */ import org.jboss.security.authorization.Resource;
/*    */ 
/*    */ public abstract class SecurityHelper
/*    */ {
/*    */   protected SecurityContext securityContext;
/* 46 */   protected static Logger log = null;
/*    */ 
/*    */   public SecurityHelper(SecurityContext sc)
/*    */   {
/* 50 */     log = Logger.getLogger(getClass());
/* 51 */     if (sc == null)
/* 52 */       sc = SecurityActions.getSecurityContext();
/* 53 */     if (sc == null)
/* 54 */       throw new IllegalArgumentException("Security Context is null");
/* 55 */     this.securityContext = sc;
/*    */   }
/*    */ 
/*    */   protected void authorizationAudit(String level, Resource resource, Exception e)
/*    */   {
/* 63 */     if (this.securityContext.getAuditManager() == null) {
/* 64 */       return;
/*    */     }
/*    */ 
/* 67 */     String exceptionMessage = e != null ? e.getLocalizedMessage() : "";
/* 68 */     Map cmap = new HashMap();
/* 69 */     cmap.putAll(resource.getMap());
/* 70 */     cmap.put("Resource:", resource.toString());
/* 71 */     cmap.put("Exception:", exceptionMessage);
/* 72 */     audit(level, cmap, null);
/*    */   }
/*    */ 
/*    */   protected void audit(String level, Map<String, Object> contextMap, Exception e)
/*    */   {
/* 78 */     AuditManager am = this.securityContext.getAuditManager();
/* 79 */     if (am == null)
/* 80 */       return;
/* 81 */     contextMap.put("Source", getClass().getName());
/* 82 */     AuditEvent ae = new AuditEvent(level, contextMap, e);
/* 83 */     am.audit(ae);
/*    */   }
/*    */ 
/*    */   protected Map<String, Object> getContextMap(Principal principal, String methodName)
/*    */   {
/* 88 */     Map cmap = new HashMap();
/* 89 */     cmap.put("principal", principal);
/* 90 */     cmap.put("method", methodName);
/* 91 */     return cmap;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.integration.ejb.SecurityHelper
 * JD-Core Version:    0.6.0
 */