/*     */ package org.jboss.security.jacc;
/*     */ 
/*     */ import java.security.CodeSource;
/*     */ import java.security.Permission;
/*     */ import java.security.PermissionCollection;
/*     */ import java.security.Policy;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.jacc.EJBMethodPermission;
/*     */ import javax.security.jacc.EJBRoleRefPermission;
/*     */ import javax.security.jacc.PolicyConfiguration;
/*     */ import javax.security.jacc.PolicyContext;
/*     */ import javax.security.jacc.PolicyContextException;
/*     */ import javax.security.jacc.WebResourcePermission;
/*     */ import javax.security.jacc.WebRoleRefPermission;
/*     */ import javax.security.jacc.WebUserDataPermission;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class DelegatingPolicy extends Policy
/*     */ {
/*  55 */   private static Logger log = Logger.getLogger(DelegatingPolicy.class);
/*     */   private static DelegatingPolicy instance;
/*     */   private Policy delegate;
/*  66 */   private ConcurrentHashMap activePolicies = new ConcurrentHashMap();
/*     */ 
/*  71 */   private ConcurrentHashMap openPolicies = new ConcurrentHashMap();
/*     */   private boolean trace;
/*  79 */   private PolicyProxy policyProxy = new PolicyProxy(this);
/*     */ 
/*  85 */   private Class[] externalPermissionTypes = new Class[0];
/*     */ 
/*     */   public static synchronized DelegatingPolicy getInstance()
/*     */   {
/*  89 */     if (instance == null)
/*     */     {
/*  91 */       instance = new DelegatingPolicy();
/*     */     }
/*  93 */     return instance;
/*     */   }
/*     */ 
/*     */   public DelegatingPolicy()
/*     */   {
/*  98 */     this(null);
/*     */   }
/*     */ 
/*     */   public DelegatingPolicy(Policy delegate)
/*     */   {
/* 103 */     if (delegate == null)
/* 104 */       delegate = Policy.getPolicy();
/* 105 */     this.delegate = delegate;
/* 106 */     this.trace = log.isTraceEnabled();
/* 107 */     if (instance == null) {
/* 108 */       instance = this;
/*     */     }
/*     */ 
/* 121 */     Permission permission = new RuntimePermission("test");
/* 122 */     boolean loadedPerms = (!(permission instanceof EJBMethodPermission)) && (!(permission instanceof EJBRoleRefPermission)) && (!(permission instanceof WebResourcePermission)) && (!(permission instanceof WebRoleRefPermission)) && (!(permission instanceof WebUserDataPermission));
/*     */ 
/* 127 */     if (this.trace) {
/* 128 */       log.trace("Loaded JACC permissions: " + loadedPerms);
/*     */     }
/* 130 */     Class c = PolicyContext.class;
/*     */   }
/*     */ 
/*     */   public Class[] getExternalPermissionTypes()
/*     */   {
/* 135 */     return this.externalPermissionTypes;
/*     */   }
/*     */ 
/*     */   public void setExternalPermissionTypes(Class[] externalPermissionTypes) {
/* 139 */     if (externalPermissionTypes == null)
/* 140 */       externalPermissionTypes = new Class[0];
/* 141 */     this.externalPermissionTypes = externalPermissionTypes;
/*     */   }
/*     */ 
/*     */   public PermissionCollection getPermissions(ProtectionDomain domain)
/*     */   {
/* 146 */     PermissionCollection pc = super.getPermissions(domain);
/* 147 */     PermissionCollection delegated = this.delegate.getPermissions(domain);
/* 148 */     for (Enumeration e = delegated.elements(); e.hasMoreElements(); )
/*     */     {
/* 150 */       Permission p = (Permission)e.nextElement();
/* 151 */       pc.add(p);
/*     */     }
/* 153 */     return pc;
/*     */   }
/*     */ 
/*     */   public boolean implies(ProtectionDomain domain, Permission permission)
/*     */   {
/* 158 */     boolean isJaccPermission = ((permission instanceof EJBMethodPermission)) || ((permission instanceof EJBRoleRefPermission)) || ((permission instanceof WebResourcePermission)) || ((permission instanceof WebRoleRefPermission)) || ((permission instanceof WebUserDataPermission));
/*     */ 
/* 163 */     boolean implied = false;
/*     */ 
/* 165 */     if ((!isJaccPermission) && (this.externalPermissionTypes.length > 0))
/*     */     {
/* 167 */       Class pc = permission.getClass();
/* 168 */       for (int n = 0; n < this.externalPermissionTypes.length; n++)
/*     */       {
/* 170 */         Class epc = this.externalPermissionTypes[n];
/* 171 */         if (!epc.isAssignableFrom(pc))
/*     */           continue;
/* 173 */         isJaccPermission = true;
/* 174 */         break;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 179 */     if (!isJaccPermission)
/*     */     {
/* 182 */       implied = this.delegate.implies(domain, permission);
/*     */     }
/*     */     else
/*     */     {
/* 186 */       if (this.trace)
/*     */       {
/* 188 */         log.trace("implies, domain=" + domain + ", permission=" + permission);
/*     */         try
/*     */         {
/* 191 */           Subject caller = (Subject)PolicyContext.getContext("javax.security.auth.Subject.container");
/* 192 */           log.trace("implies javax.security.auth.Subject.container: " + caller);
/*     */         }
/*     */         catch (Throwable e)
/*     */         {
/* 196 */           log.trace("Failed to access Subject context", e);
/*     */         }
/*     */       }
/* 199 */       String contextID = PolicyContext.getContextID();
/* 200 */       ContextPolicy contextPolicy = (ContextPolicy)this.activePolicies.get(contextID);
/* 201 */       if (contextPolicy != null)
/* 202 */         implied = contextPolicy.implies(domain, permission);
/* 203 */       else if (this.trace)
/* 204 */         log.trace("No PolicyContext found for contextID=" + contextID);
/*     */     }
/* 206 */     if (this.trace)
/*     */     {
/* 208 */       log.trace("implied=" + implied);
/*     */     }
/* 210 */     return implied;
/*     */   }
/*     */ 
/*     */   public PermissionCollection getPermissions(CodeSource cs)
/*     */   {
/* 227 */     PermissionCollection pc = null;
/* 228 */     String contextID = PolicyContext.getContextID();
/* 229 */     if (contextID == null)
/*     */     {
/* 231 */       pc = this.delegate.getPermissions(cs);
/*     */     }
/*     */     else
/*     */     {
/* 235 */       ContextPolicy policy = (ContextPolicy)this.activePolicies.get(contextID);
/* 236 */       if (policy != null)
/*     */       {
/* 238 */         pc = policy.getPermissions();
/*     */       }
/*     */       else
/*     */       {
/* 242 */         pc = this.delegate.getPermissions(cs);
/*     */       }
/*     */     }
/* 245 */     return pc;
/*     */   }
/*     */ 
/*     */   public void refresh()
/*     */   {
/*     */   }
/*     */ 
/*     */   public Policy getPolicyProxy()
/*     */   {
/* 263 */     return this.policyProxy;
/*     */   }
/*     */ 
/*     */   public String listContextPolicies()
/*     */   {
/* 274 */     StringBuffer tmp = new StringBuffer("<ActiveContextPolicies>");
/* 275 */     Iterator iter = this.activePolicies.keySet().iterator();
/* 276 */     while (iter.hasNext())
/*     */     {
/* 278 */       String contextID = (String)iter.next();
/* 279 */       ContextPolicy cp = (ContextPolicy)this.activePolicies.get(contextID);
/* 280 */       tmp.append(cp);
/* 281 */       tmp.append('\n');
/*     */     }
/* 283 */     tmp.append("</ActiveContextPolicies>");
/*     */ 
/* 285 */     tmp.append("<OpenContextPolicies>");
/* 286 */     iter = this.openPolicies.keySet().iterator();
/* 287 */     while (iter.hasNext())
/*     */     {
/* 289 */       String contextID = (String)iter.next();
/* 290 */       ContextPolicy cp = (ContextPolicy)this.openPolicies.get(contextID);
/* 291 */       tmp.append(cp);
/* 292 */       tmp.append('\n');
/*     */     }
/* 294 */     tmp.append("</OpenContextPolicies>");
/*     */ 
/* 296 */     return tmp.toString();
/*     */   }
/*     */ 
/*     */   synchronized ContextPolicy getContextPolicy(String contextID)
/*     */     throws PolicyContextException
/*     */   {
/* 302 */     ContextPolicy policy = (ContextPolicy)this.openPolicies.get(contextID);
/* 303 */     if (policy == null)
/* 304 */       throw new PolicyContextException("No ContextPolicy exists for contextID=" + contextID);
/* 305 */     return policy;
/*     */   }
/*     */ 
/*     */   synchronized void initPolicyConfiguration(String contextID, boolean remove)
/*     */     throws PolicyContextException
/*     */   {
/* 320 */     ContextPolicy policy = (ContextPolicy)this.activePolicies.remove(contextID);
/* 321 */     if (policy == null)
/* 322 */       policy = (ContextPolicy)this.openPolicies.get(contextID);
/* 323 */     if (policy == null)
/*     */     {
/* 325 */       policy = new ContextPolicy(contextID);
/*     */     }
/*     */ 
/* 328 */     this.openPolicies.put(contextID, policy);
/* 329 */     if (remove == true)
/* 330 */       policy.clear();
/*     */   }
/*     */ 
/*     */   void addToExcludedPolicy(String contextID, Permission permission)
/*     */     throws PolicyContextException
/*     */   {
/* 336 */     ContextPolicy policy = getContextPolicy(contextID);
/* 337 */     policy.addToExcludedPolicy(permission);
/*     */   }
/*     */ 
/*     */   void addToExcludedPolicy(String contextID, PermissionCollection permissions)
/*     */     throws PolicyContextException
/*     */   {
/* 343 */     ContextPolicy policy = getContextPolicy(contextID);
/* 344 */     policy.addToExcludedPolicy(permissions);
/*     */   }
/*     */ 
/*     */   void addToRole(String contextID, String roleName, Permission permission)
/*     */     throws PolicyContextException
/*     */   {
/* 350 */     ContextPolicy policy = getContextPolicy(contextID);
/* 351 */     policy.addToRole(roleName, permission);
/*     */   }
/*     */ 
/*     */   void addToRole(String contextID, String roleName, PermissionCollection permissions)
/*     */     throws PolicyContextException
/*     */   {
/* 357 */     ContextPolicy policy = getContextPolicy(contextID);
/* 358 */     policy.addToRole(roleName, permissions);
/*     */   }
/*     */ 
/*     */   void addToUncheckedPolicy(String contextID, Permission permission)
/*     */     throws PolicyContextException
/*     */   {
/* 364 */     ContextPolicy policy = getContextPolicy(contextID);
/* 365 */     policy.addToUncheckedPolicy(permission);
/*     */   }
/*     */ 
/*     */   void addToUncheckedPolicy(String contextID, PermissionCollection permissions)
/*     */     throws PolicyContextException
/*     */   {
/* 371 */     ContextPolicy policy = getContextPolicy(contextID);
/* 372 */     policy.addToUncheckedPolicy(permissions);
/*     */   }
/*     */ 
/*     */   void linkConfiguration(String contextID, PolicyConfiguration link)
/*     */     throws PolicyContextException
/*     */   {
/* 378 */     ContextPolicy policy = getContextPolicy(contextID);
/* 379 */     ContextPolicy linkPolicy = getContextPolicy(link.getContextID());
/* 380 */     policy.linkConfiguration(linkPolicy);
/*     */   }
/*     */ 
/*     */   public void commit(String contextID)
/*     */     throws PolicyContextException
/*     */   {
/* 394 */     ContextPolicy policy = getContextPolicy(contextID);
/* 395 */     this.openPolicies.remove(contextID);
/* 396 */     this.activePolicies.put(contextID, policy);
/* 397 */     policy.commit();
/*     */   }
/*     */ 
/*     */   public void delete(String contextID)
/*     */     throws PolicyContextException
/*     */   {
/* 403 */     ContextPolicy policy = (ContextPolicy)this.activePolicies.remove(contextID);
/* 404 */     if (policy == null)
/* 405 */       policy = (ContextPolicy)this.openPolicies.remove(contextID);
/* 406 */     if (policy != null)
/* 407 */       policy.delete();
/*     */   }
/*     */ 
/*     */   void removeExcludedPolicy(String contextID)
/*     */     throws PolicyContextException
/*     */   {
/* 413 */     ContextPolicy policy = getContextPolicy(contextID);
/* 414 */     policy.removeExcludedPolicy();
/*     */   }
/*     */ 
/*     */   void removeRole(String contextID, String roleName)
/*     */     throws PolicyContextException
/*     */   {
/* 420 */     ContextPolicy policy = getContextPolicy(contextID);
/* 421 */     policy.removeRole(roleName);
/*     */   }
/*     */ 
/*     */   void removeUncheckedPolicy(String contextID)
/*     */     throws PolicyContextException
/*     */   {
/* 427 */     ContextPolicy policy = getContextPolicy(contextID);
/* 428 */     policy.removeUncheckedPolicy();
/*     */   }
/*     */ 
/*     */   private static class PolicyProxy extends Policy
/*     */   {
/*     */     private Policy delegate;
/*     */ 
/*     */     PolicyProxy(Policy delegate)
/*     */     {
/* 441 */       this.delegate = delegate;
/*     */     }
/*     */ 
/*     */     public void refresh()
/*     */     {
/* 446 */       this.delegate.refresh();
/*     */     }
/*     */ 
/*     */     public PermissionCollection getPermissions(CodeSource codesource)
/*     */     {
/* 451 */       return this.delegate.getPermissions(codesource);
/*     */     }
/*     */ 
/*     */     public boolean implies(ProtectionDomain domain, Permission permission)
/*     */     {
/* 456 */       return this.delegate.implies(domain, permission);
/*     */     }
/*     */ 
/*     */     public PermissionCollection getPermissions(ProtectionDomain domain)
/*     */     {
/* 461 */       return this.delegate.getPermissions(domain);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.jacc.DelegatingPolicy
 * JD-Core Version:    0.6.0
 */