/*     */ package org.jboss.security.jndi;
/*     */ 
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.security.Principal;
/*     */ import java.util.Hashtable;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.naming.NamingContextFactory;
/*     */ import org.jboss.security.SimplePrincipal;
/*     */ 
/*     */ public class JndiLoginInitialContextFactory extends NamingContextFactory
/*     */ {
/*     */   public Context getInitialContext(Hashtable env)
/*     */     throws NamingException
/*     */   {
/*  69 */     Object credentials = env.get("java.naming.security.credentials");
/*  70 */     Object principal = env.get("java.naming.security.principal");
/*  71 */     Principal securityPrincipal = null;
/*     */ 
/*  75 */     String flag = (String)env.get("jnp.multi-threaded");
/*  76 */     if (Boolean.valueOf(flag).booleanValue() == true)
/*     */     {
/*  81 */       SecurityAssociationActions.setServer();
/*     */     }
/*  83 */     boolean restoreLoginIdentity = false;
/*  84 */     flag = (String)env.get("jnp.restoreLoginIdentity");
/*  85 */     if (flag != null) {
/*  86 */       restoreLoginIdentity = Boolean.parseBoolean(flag);
/*     */     }
/*  88 */     if ((principal instanceof Principal))
/*     */     {
/*  90 */       securityPrincipal = (Principal)principal;
/*     */     }
/*     */     else
/*     */     {
/*  95 */       String username = principal.toString();
/*  96 */       securityPrincipal = new SimplePrincipal(username);
/*     */     }
/*     */ 
/*  99 */     if (restoreLoginIdentity)
/*     */     {
/* 101 */       SecurityAssociationActions.setPrincipalInfo(securityPrincipal, credentials, null);
/*     */     }
/*     */     else
/*     */     {
/* 105 */       SecurityAssociationActions.setPrincipalInfo(securityPrincipal, credentials);
/*     */     }
/*     */ 
/* 108 */     Context iniCtx = super.getInitialContext(env);
/* 109 */     if (restoreLoginIdentity)
/*     */     {
/* 112 */       ClassLoader loader = SecurityAssociationActions.getContextClassLoader();
/* 113 */       ContextProxy handler = new ContextProxy(iniCtx);
/* 114 */       Class[] ifaces = { Context.class };
/* 115 */       iniCtx = (Context)Proxy.newProxyInstance(loader, ifaces, handler);
/*     */     }
/* 117 */     return iniCtx;
/*     */   }
/*     */ 
/*     */   public static class ContextProxy
/*     */     implements InvocationHandler
/*     */   {
/*     */     private Context delegate;
/*     */ 
/*     */     ContextProxy(Context delegate)
/*     */     {
/* 128 */       this.delegate = delegate;
/*     */     }
/*     */ 
/*     */     public Object invoke(Object proxy, Method method, Object[] args) throws Throwable
/*     */     {
/* 133 */       boolean close = false;
/*     */       try
/*     */       {
/* 136 */         close = method.getName().equals("close");
/* 137 */         Object localObject1 = method.invoke(this.delegate, args);
/*     */         return localObject1;
/*     */       }
/*     */       catch (InvocationTargetException e)
/*     */       {
/* 141 */         throw e.getTargetException();
/*     */       }
/*     */       finally
/*     */       {
/* 145 */         if (close)
/*     */         {
/*     */           try
/*     */           {
/* 150 */             SecurityAssociationActions.popPrincipalInfo(); } catch (Throwable ignore) {
/*     */           }
/*     */         }
/*     */       }
/* 154 */       throw localObject2;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.jndi.JndiLoginInitialContextFactory
 * JD-Core Version:    0.6.0
 */