/*    */ package org.jboss.security.jndi;
/*    */ 
/*    */ import java.security.Principal;
/*    */ import java.util.Hashtable;
/*    */ import javax.naming.AuthenticationException;
/*    */ import javax.naming.Context;
/*    */ import javax.naming.NamingException;
/*    */ import javax.security.auth.login.LoginContext;
/*    */ import javax.security.auth.login.LoginException;
/*    */ import org.jboss.security.auth.callback.UsernamePasswordHandler;
/*    */ import org.jnp.interfaces.NamingContextFactory;
/*    */ 
/*    */ public class LoginInitialContextFactory extends NamingContextFactory
/*    */ {
/*    */   public Context getInitialContext(Hashtable env)
/*    */     throws NamingException
/*    */   {
/* 60 */     String protocol = "other";
/* 61 */     Object prop = env.get("java.naming.security.protocol");
/* 62 */     if (prop != null) {
/* 63 */       protocol = prop.toString();
/*    */     }
/*    */ 
/* 66 */     Object credentials = env.get("java.naming.security.credentials");
/* 67 */     Object principal = env.get("java.naming.security.principal");
/*    */     try
/*    */     {
/*    */       String username;
/*    */       String username;
/* 72 */       if ((principal instanceof Principal))
/*    */       {
/* 74 */         Principal p = (Principal)principal;
/* 75 */         username = p.getName();
/*    */       }
/*    */       else
/*    */       {
/* 79 */         username = principal.toString();
/*    */       }
/* 81 */       UsernamePasswordHandler handler = new UsernamePasswordHandler(username, credentials);
/*    */ 
/* 84 */       LoginContext lc = new LoginContext(protocol, handler);
/* 85 */       lc.login();
/*    */     }
/*    */     catch (LoginException e)
/*    */     {
/* 89 */       AuthenticationException ex = new AuthenticationException("Failed to login using protocol=" + protocol);
/* 90 */       ex.setRootCause(e);
/* 91 */       throw ex;
/*    */     }
/*    */ 
/* 95 */     Context iniCtx = super.getInitialContext(env);
/* 96 */     return iniCtx;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.jndi.LoginInitialContextFactory
 * JD-Core Version:    0.6.0
 */