/*     */ package org.jboss.security.mapping.providers;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.security.Principal;
/*     */ import java.security.acl.Group;
/*     */ import java.util.Enumeration;
/*     */ import java.util.HashSet;
/*     */ import java.util.StringTokenizer;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.SimplePrincipal;
/*     */ 
/*     */ public class MappingProviderUtil
/*     */ {
/*  44 */   public static Logger log = Logger.getLogger(MappingProviderUtil.class);
/*     */ 
/*     */   public static Group addPrincipals(Group grp, Enumeration<? extends Principal> en)
/*     */   {
/*  54 */     while (en.hasMoreElements())
/*  55 */       grp.addMember((Principal)en.nextElement());
/*  56 */     return grp;
/*     */   }
/*     */ 
/*     */   public static Group addRoles(Group roles, String[] addRoles)
/*     */   {
/*  67 */     Class pClass = getPrincipalClass(roles);
/*  68 */     for (String str : addRoles)
/*     */     {
/*  70 */       roles.addMember(instantiatePrincipal(pClass, str));
/*     */     }
/*  72 */     return roles;
/*     */   }
/*     */ 
/*     */   public static String[] getRolesFromCommaSeparatedString(String str)
/*     */   {
/*  83 */     if (str == null)
/*  84 */       throw new IllegalArgumentException("str is null");
/*  85 */     StringTokenizer st = new StringTokenizer(str, ",");
/*  86 */     int numTokens = st != null ? st.countTokens() : 0;
/*  87 */     String[] tokens = new String[numTokens];
/*  88 */     for (int i = 0; i < numTokens; i++)
/*     */     {
/*  90 */       tokens[i] = st.nextToken();
/*     */     }
/*  92 */     return tokens;
/*     */   }
/*     */ 
/*     */   public static Principal instantiatePrincipal(Class cls, String role)
/*     */   {
/* 103 */     Principal p = null;
/*     */     try
/*     */     {
/* 106 */       Constructor ctr = cls.getConstructor(new Class[] { String.class });
/* 107 */       p = (Principal)ctr.newInstance(new Object[] { role });
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 111 */       if (log.isTraceEnabled())
/* 112 */         log.trace("Encountered exception in mapping provider:instantiatePrincipal:", e);
/*     */     }
/* 114 */     return p;
/*     */   }
/*     */ 
/*     */   public static Group removePrincipals(Group grp)
/*     */   {
/* 124 */     HashSet removeset = new HashSet();
/* 125 */     Enumeration en = grp.members();
/* 126 */     while (en.hasMoreElements())
/*     */     {
/* 128 */       removeset.add(en.nextElement());
/*     */     }
/*     */ 
/* 131 */     for (Principal p : removeset)
/* 132 */       grp.removeMember(p);
/* 133 */     return grp;
/*     */   }
/*     */ 
/*     */   public static Group removeRoles(Group roles, String[] removeRoles)
/*     */   {
/* 145 */     Class pClass = getPrincipalClass(roles);
/* 146 */     for (String str : removeRoles)
/*     */     {
/* 148 */       roles.removeMember(instantiatePrincipal(pClass, str));
/*     */     }
/* 150 */     return roles;
/*     */   }
/*     */ 
/*     */   public static Group replacePrincipals(Group fg, Group sg)
/*     */   {
/* 161 */     return addPrincipals(removePrincipals(fg), sg.members());
/*     */   }
/*     */ 
/*     */   private static Class getPrincipalClass(Group roles)
/*     */   {
/* 167 */     Class principalClass = SimplePrincipal.class;
/* 168 */     Enumeration en = roles.members();
/* 169 */     if (en.hasMoreElements())
/*     */     {
/* 171 */       principalClass = ((Principal)roles.members().nextElement()).getClass();
/*     */     }
/* 173 */     return principalClass;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.security.mapping.providers.MappingProviderUtil
 * JD-Core Version:    0.6.0
 */